/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.ranger;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Schema;
import org.apache.gravitino.authorization.AuthorizationMetadataObject;
import org.apache.gravitino.authorization.AuthorizationPrivilege;
import org.apache.gravitino.authorization.AuthorizationSecurableObject;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.authorization.MetadataObjectChange;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.common.PathBasedMetadataObject;
import org.apache.gravitino.authorization.common.PathBasedSecurableObject;
import org.apache.gravitino.authorization.ranger.RangerAuthorizationPlugin;
import org.apache.gravitino.authorization.ranger.RangerHadoopSQLMetadataObject;
import org.apache.gravitino.authorization.ranger.RangerPrivileges;
import org.apache.gravitino.authorization.ranger.reference.RangerDefines;
import org.apache.gravitino.exceptions.AuthorizationPluginException;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.apache.ranger.RangerServiceException;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAuthorizationHDFSPlugin
extends RangerAuthorizationPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAuthorizationHDFSPlugin.class);
    private static final Pattern HDFS_PATTERN = Pattern.compile("^hdfs://[^/]*");

    public RangerAuthorizationHDFSPlugin(String metalake, Map<String, String> config) {
        super(metalake, config);
    }

    public Map<Privilege.Name, Set<AuthorizationPrivilege>> privilegesMappingRule() {
        return ImmutableMap.of((Object)Privilege.Name.USE_CATALOG, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE)), (Object)Privilege.Name.CREATE_CATALOG, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.WRITE), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE)), (Object)Privilege.Name.USE_SCHEMA, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE)), (Object)Privilege.Name.CREATE_SCHEMA, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.WRITE), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE)), (Object)Privilege.Name.CREATE_TABLE, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.WRITE), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE)), (Object)Privilege.Name.MODIFY_TABLE, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.WRITE), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE)), (Object)Privilege.Name.SELECT_TABLE, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE)), (Object)Privilege.Name.READ_FILESET, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE)), (Object)Privilege.Name.WRITE_FILESET, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.WRITE), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE)));
    }

    public Set<AuthorizationPrivilege> ownerMappingRule() {
        return ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.WRITE), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE));
    }

    @Override
    public List<String> policyResourceDefinesRule() {
        return ImmutableList.of((Object)RangerDefines.PolicyResource.PATH.getName());
    }

    String getAuthorizationPath(PathBasedMetadataObject pathBasedMetadataObject) {
        return HDFS_PATTERN.matcher(pathBasedMetadataObject.path()).replaceAll("");
    }

    @Override
    public RangerPolicy findManagedPolicy(AuthorizationMetadataObject authzMetadataObject) throws AuthorizationPluginException {
        List nsMetadataObj = authzMetadataObject.names();
        PathBasedMetadataObject pathAuthzMetadataObject = (PathBasedMetadataObject)authzMetadataObject;
        HashMap<String, String> preciseFilters = new HashMap<String, String>();
        for (int i = 0; i < nsMetadataObj.size() && i < this.policyResourceDefinesRule().size(); ++i) {
            preciseFilters.put(this.policyResourceDefinesRule().get(i), this.getAuthorizationPath(pathAuthzMetadataObject));
        }
        return this.preciseFindPolicy(authzMetadataObject, preciseFilters);
    }

    @Override
    protected List<RangerPolicy> wildcardSearchPolies(AuthorizationMetadataObject authzMetadataObject) {
        Preconditions.checkArgument((boolean)(authzMetadataObject instanceof PathBasedMetadataObject));
        PathBasedMetadataObject pathBasedMetadataObject = (PathBasedMetadataObject)authzMetadataObject;
        List<String> resourceDefines = this.policyResourceDefinesRule();
        HashMap<String, String> searchFilters = new HashMap<String, String>();
        searchFilters.put("serviceName", this.rangerServiceName);
        resourceDefines.stream().forEach(resourceDefine -> searchFilters.put("resource:" + resourceDefine, this.getAuthorizationPath(pathBasedMetadataObject)));
        try {
            return this.rangerClient.findPolicies(searchFilters);
        }
        catch (RangerServiceException e) {
            throw new AuthorizationPluginException((Throwable)e, "Failed to find the policies in the Ranger", new Object[0]);
        }
    }

    @Override
    protected void renameMetadataObject(AuthorizationMetadataObject authzMetadataObject, AuthorizationMetadataObject newAuthzMetadataObject) {
        Preconditions.checkArgument((boolean)(authzMetadataObject instanceof PathBasedMetadataObject), (Object)"The metadata object must be a PathBasedMetadataObject");
        Preconditions.checkArgument((boolean)(newAuthzMetadataObject instanceof PathBasedMetadataObject), (Object)"The metadata object must be a PathBasedMetadataObject");
        this.updatePolicyByMetadataObject(newAuthzMetadataObject.type().metadataObjectType(), authzMetadataObject, newAuthzMetadataObject);
    }

    @Override
    protected void updatePolicyByMetadataObject(MetadataObject.Type operationType, AuthorizationMetadataObject oldAuthzMetaObject, AuthorizationMetadataObject newAuthzMetaObject) {
        PathBasedMetadataObject newPathBasedMetadataObject = (PathBasedMetadataObject)newAuthzMetaObject;
        List<RangerPolicy> oldPolicies = this.wildcardSearchPolies(oldAuthzMetaObject);
        List<RangerPolicy> existNewPolicies = this.wildcardSearchPolies(newAuthzMetaObject);
        if (oldPolicies.isEmpty()) {
            LOG.warn("Cannot find the Ranger policy for the metadata object({})!", (Object)oldAuthzMetaObject);
            return;
        }
        if (!existNewPolicies.isEmpty()) {
            LOG.warn("The Ranger policy for the metadata object({}) already exists!", (Object)newAuthzMetaObject);
        }
        oldPolicies.stream().forEach(policy -> {
            try {
                policy.setName(this.getAuthorizationPath(newPathBasedMetadataObject));
                policy.getResources().put(this.rangerHelper.policyResourceDefines.get(0), new RangerPolicy.RangerPolicyResource(this.getAuthorizationPath(newPathBasedMetadataObject)));
                boolean alreadyExist = existNewPolicies.stream().anyMatch(existNewPolicy -> existNewPolicy.getName().equals(policy.getName()) || existNewPolicy.getResources().equals(policy.getResources()));
                if (alreadyExist) {
                    LOG.warn("The Ranger policy for the metadata object({}) already exists!", (Object)newAuthzMetaObject);
                    return;
                }
                this.rangerClient.updatePolicy(policy.getId(), (RangerPolicy)policy);
            }
            catch (RangerServiceException e) {
                LOG.error("Failed to rename the policy {}!", policy);
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    protected void removeMetadataObject(AuthorizationMetadataObject authzMetadataObject) {
        if (authzMetadataObject.type().equals((Object)RangerHadoopSQLMetadataObject.Type.SCHEMA)) {
            this.removeSchemaMetadataObject(authzMetadataObject);
        } else if (authzMetadataObject.type().equals((Object)RangerHadoopSQLMetadataObject.Type.TABLE)) {
            this.removeTableMetadataObject(authzMetadataObject);
        } else if (authzMetadataObject.type().equals((Object)RangerHadoopSQLMetadataObject.Type.COLUMN) || authzMetadataObject.type().equals(PathBasedMetadataObject.Type.PATH)) {
            this.removePolicyByMetadataObject(authzMetadataObject);
        } else {
            throw new IllegalArgumentException("Unsupported authorization metadata object type: " + authzMetadataObject.type());
        }
    }

    private void removeSchemaMetadataObject(AuthorizationMetadataObject authzMetadataObject) {
        Preconditions.checkArgument((boolean)(authzMetadataObject instanceof PathBasedMetadataObject), (Object)"The metadata object must be a PathBasedMetadataObject");
        Preconditions.checkArgument((authzMetadataObject.type() == RangerHadoopSQLMetadataObject.Type.SCHEMA ? 1 : 0) != 0, (Object)"The metadata object type must be SCHEMA");
        Preconditions.checkArgument((authzMetadataObject.names().size() == 1 ? 1 : 0) != 0, (Object)"The size of the metadata object's name must be 1.");
        if ("*".equals(authzMetadataObject.name())) {
            String catalogName = (String)authzMetadataObject.names().get(0);
            NameIdentifier[] schemas = GravitinoEnv.getInstance().schemaDispatcher().listSchemas(Namespace.of((String[])new String[]{this.metalake, catalogName}));
            Arrays.asList(schemas).stream().forEach(schema -> {
                List schemaLocations = AuthorizationUtils.getMetadataObjectLocation((NameIdentifier)NameIdentifier.of((String[])new String[]{this.metalake, catalogName, schema.name()}), (Entity.EntityType)Entity.EntityType.SCHEMA);
                schemaLocations.stream().forEach(locationPath -> {
                    ImmutableList names = ImmutableList.of((Object)this.metalake, (Object)catalogName, (Object)schema.name());
                    PathBasedMetadataObject schemaMetadataObject = new PathBasedMetadataObject(AuthorizationMetadataObject.getParentFullName((List)names), AuthorizationMetadataObject.getLastName((List)names), locationPath, (AuthorizationMetadataObject.Type)PathBasedMetadataObject.Type.PATH);
                    this.removeSchemaMetadataObject((AuthorizationMetadataObject)schemaMetadataObject);
                });
            });
        } else {
            NameIdentifier[] tables = GravitinoEnv.getInstance().tableDispatcher().listTables(Namespace.of((String[])new String[]{authzMetadataObject.name()}));
            Arrays.asList(tables).stream().forEach(table -> {
                NameIdentifier identifier = NameIdentifier.of((String[])new String[]{authzMetadataObject.name(), table.name()});
                List tabLocations = AuthorizationUtils.getMetadataObjectLocation((NameIdentifier)identifier, (Entity.EntityType)Entity.EntityType.TABLE);
                tabLocations.stream().forEach(locationPath -> {
                    PathBasedMetadataObject tableMetadataObject = new PathBasedMetadataObject(authzMetadataObject.name(), table.name(), locationPath, (AuthorizationMetadataObject.Type)PathBasedMetadataObject.Type.PATH);
                    this.removeTableMetadataObject((AuthorizationMetadataObject)tableMetadataObject);
                });
            });
            Schema schema2 = GravitinoEnv.getInstance().schemaDispatcher().loadSchema(NameIdentifier.of((String[])new String[]{authzMetadataObject.name()}));
            List schemaLocations = AuthorizationUtils.getMetadataObjectLocation((NameIdentifier)NameIdentifier.parse((String)authzMetadataObject.fullName()), (Entity.EntityType)Entity.EntityType.SCHEMA);
            schemaLocations.stream().forEach(locationPath -> {
                PathBasedMetadataObject schemaMetadataObject = new PathBasedMetadataObject(authzMetadataObject.name(), schema2.name(), locationPath, (AuthorizationMetadataObject.Type)PathBasedMetadataObject.Type.PATH);
                this.removePolicyByMetadataObject((AuthorizationMetadataObject)schemaMetadataObject);
            });
        }
    }

    private void removeTableMetadataObject(AuthorizationMetadataObject authzMetadataObject) {
        Preconditions.checkArgument((boolean)(authzMetadataObject instanceof PathBasedMetadataObject), (Object)"The metadata object must be a PathBasedMetadataObject");
        Preconditions.checkArgument((authzMetadataObject.names().size() == 3 ? 1 : 0) != 0, (Object)"The metadata object names must be 3");
        Preconditions.checkArgument((authzMetadataObject.type() == PathBasedMetadataObject.Type.PATH ? 1 : 0) != 0, (Object)"The metadata object type must be PATH");
        this.removePolicyByMetadataObject(authzMetadataObject);
    }

    @Override
    protected RangerPolicy createPolicyAddResources(AuthorizationMetadataObject metadataObject) {
        Preconditions.checkArgument((boolean)(metadataObject instanceof PathBasedMetadataObject), (Object)"The metadata object must be a PathBasedMetadataObject");
        PathBasedMetadataObject pathBasedMetadataObject = (PathBasedMetadataObject)metadataObject;
        RangerPolicy policy = new RangerPolicy();
        policy.setService(this.rangerServiceName);
        policy.setName(this.getAuthorizationPath(pathBasedMetadataObject));
        RangerPolicy.RangerPolicyResource policyResource = new RangerPolicy.RangerPolicyResource(this.getAuthorizationPath(pathBasedMetadataObject), Boolean.valueOf(false), Boolean.valueOf(true));
        policy.getResources().put(RangerDefines.PolicyResource.PATH.getName(), policyResource);
        return policy;
    }

    @Override
    public AuthorizationSecurableObject generateAuthorizationSecurableObject(List<String> names, String path, AuthorizationMetadataObject.Type type, Set<AuthorizationPrivilege> privileges) {
        PathBasedMetadataObject authMetadataObject = new PathBasedMetadataObject(AuthorizationMetadataObject.getParentFullName(names), AuthorizationMetadataObject.getLastName(names), path, type);
        authMetadataObject.validateAuthorizationMetadataObject();
        return new PathBasedSecurableObject(authMetadataObject.parent(), authMetadataObject.name(), path, authMetadataObject.type(), privileges);
    }

    public Set<Privilege.Name> allowPrivilegesRule() {
        return ImmutableSet.of((Object)Privilege.Name.CREATE_FILESET, (Object)Privilege.Name.READ_FILESET, (Object)Privilege.Name.WRITE_FILESET);
    }

    public Set<MetadataObject.Type> allowMetadataObjectTypesRule() {
        return ImmutableSet.of((Object)MetadataObject.Type.FILESET, (Object)MetadataObject.Type.SCHEMA, (Object)MetadataObject.Type.CATALOG, (Object)MetadataObject.Type.METALAKE);
    }

    public List<AuthorizationSecurableObject> translatePrivilege(SecurableObject securableObject) {
        ArrayList<AuthorizationSecurableObject> rangerSecurableObjects = new ArrayList<AuthorizationSecurableObject>();
        NameIdentifier identifier = securableObject.type().equals((Object)MetadataObject.Type.METALAKE) ? NameIdentifier.of((String[])new String[]{securableObject.fullName()}) : NameIdentifier.parse((String)String.join((CharSequence)".", this.metalake, securableObject.fullName()));
        securableObject.privileges().stream().filter(Objects::nonNull).forEach(gravitinoPrivilege -> {
            HashSet rangerPrivileges = new HashSet();
            if (!this.privilegesMappingRule().containsKey(gravitinoPrivilege.name())) {
                return;
            }
            this.privilegesMappingRule().get(gravitinoPrivilege.name()).stream().forEach(rangerPrivilege -> rangerPrivileges.add(new RangerPrivileges.RangerHDFSPrivilegeImpl((AuthorizationPrivilege)rangerPrivilege, gravitinoPrivilege.condition())));
            block0 : switch (gravitinoPrivilege.name()) {
                case USE_CATALOG: 
                case CREATE_CATALOG: {
                    break;
                }
                case USE_SCHEMA: {
                    switch (securableObject.type()) {
                        case METALAKE: 
                        case CATALOG: 
                        case SCHEMA: {
                            AuthorizationUtils.getMetadataObjectLocation((NameIdentifier)identifier, (Entity.EntityType)MetadataObjectUtil.toEntityType((MetadataObject)securableObject)).stream().forEach(locationPath -> {
                                PathBasedMetadataObject pathBaseMetadataObject = new PathBasedMetadataObject(securableObject.parent(), securableObject.name(), locationPath, (AuthorizationMetadataObject.Type)PathBasedMetadataObject.Type.PATH);
                                pathBaseMetadataObject.validateAuthorizationMetadataObject();
                                rangerSecurableObjects.add(this.generateAuthorizationSecurableObject(pathBaseMetadataObject.names(), (String)locationPath, (AuthorizationMetadataObject.Type)PathBasedMetadataObject.Type.PATH, rangerPrivileges));
                            });
                            break block0;
                        }
                    }
                    throw new AuthorizationPluginException("The privilege %s is not supported for the securable object: %s", new Object[]{gravitinoPrivilege.name(), securableObject.type()});
                }
                case CREATE_SCHEMA: {
                    switch (securableObject.type()) {
                        case METALAKE: 
                        case CATALOG: {
                            AuthorizationUtils.getMetadataObjectLocation((NameIdentifier)identifier, (Entity.EntityType)MetadataObjectUtil.toEntityType((MetadataObject)securableObject)).stream().forEach(locationPath -> {
                                PathBasedMetadataObject pathBaseMetadataObject = new PathBasedMetadataObject(securableObject.parent(), securableObject.name(), locationPath, (AuthorizationMetadataObject.Type)PathBasedMetadataObject.Type.PATH);
                                pathBaseMetadataObject.validateAuthorizationMetadataObject();
                                rangerSecurableObjects.add(this.generateAuthorizationSecurableObject(pathBaseMetadataObject.names(), (String)locationPath, (AuthorizationMetadataObject.Type)PathBasedMetadataObject.Type.PATH, rangerPrivileges));
                            });
                            break block0;
                        }
                    }
                    throw new AuthorizationPluginException("The privilege %s is not supported for the securable object: %s", new Object[]{gravitinoPrivilege.name(), securableObject.type()});
                }
                case SELECT_TABLE: 
                case CREATE_TABLE: 
                case MODIFY_TABLE: {
                    break;
                }
                case CREATE_FILESET: {
                    break;
                }
                case READ_FILESET: 
                case WRITE_FILESET: {
                    switch (securableObject.type()) {
                        case METALAKE: 
                        case CATALOG: 
                        case SCHEMA: {
                            break block0;
                        }
                        case FILESET: {
                            this.translateMetadataObject((MetadataObject)securableObject).stream().forEach(metadataObject -> {
                                Preconditions.checkArgument((boolean)(metadataObject instanceof PathBasedMetadataObject), (Object)"The metadata object must be a PathBasedMetadataObject");
                                PathBasedMetadataObject pathBasedMetadataObject = (PathBasedMetadataObject)metadataObject;
                                rangerSecurableObjects.add(this.generateAuthorizationSecurableObject(pathBasedMetadataObject.names(), this.getAuthorizationPath(pathBasedMetadataObject), (AuthorizationMetadataObject.Type)PathBasedMetadataObject.Type.PATH, rangerPrivileges));
                            });
                            break block0;
                        }
                    }
                    throw new AuthorizationPluginException("The privilege %s is not supported for the securable object: %s", new Object[]{gravitinoPrivilege.name(), securableObject.type()});
                }
                default: {
                    throw new AuthorizationPluginException("The privilege %s is not supported for the securable object: %s", new Object[]{gravitinoPrivilege.name(), securableObject.type()});
                }
            }
        });
        return rangerSecurableObjects;
    }

    public List<AuthorizationSecurableObject> translateOwner(MetadataObject gravitinoMetadataObject) {
        ArrayList<AuthorizationSecurableObject> rangerSecurableObjects = new ArrayList<AuthorizationSecurableObject>();
        switch (gravitinoMetadataObject.type()) {
            case METALAKE: 
            case CATALOG: 
            case SCHEMA: {
                break;
            }
            case FILESET: {
                this.translateMetadataObject(gravitinoMetadataObject).stream().forEach(metadataObject -> {
                    Preconditions.checkArgument((boolean)(metadataObject instanceof PathBasedMetadataObject), (Object)"The metadata object must be a PathBasedMetadataObject");
                    PathBasedMetadataObject pathBasedMetadataObject = (PathBasedMetadataObject)metadataObject;
                    rangerSecurableObjects.add(this.generateAuthorizationSecurableObject(pathBasedMetadataObject.names(), this.getAuthorizationPath(pathBasedMetadataObject), (AuthorizationMetadataObject.Type)PathBasedMetadataObject.Type.PATH, this.ownerMappingRule()));
                });
                break;
            }
            default: {
                throw new AuthorizationPluginException("The owner privilege is not supported for the securable object: %s", new Object[]{gravitinoMetadataObject.type()});
            }
        }
        return rangerSecurableObjects;
    }

    public List<AuthorizationMetadataObject> translateMetadataObject(MetadataObject metadataObject) {
        ArrayList<AuthorizationMetadataObject> authzMetadataObjects = new ArrayList<AuthorizationMetadataObject>();
        Entity.EntityType entityType = MetadataObjectUtil.toEntityType((MetadataObject)metadataObject);
        NameIdentifier identifier = metadataObject.type().equals((Object)MetadataObject.Type.METALAKE) ? NameIdentifier.of((String[])new String[]{metadataObject.fullName()}) : NameIdentifier.parse((String)String.join((CharSequence)".", this.metalake, metadataObject.fullName()));
        List locations = AuthorizationUtils.getMetadataObjectLocation((NameIdentifier)identifier, (Entity.EntityType)entityType);
        locations.stream().forEach(locationPath -> {
            PathBasedMetadataObject pathBaseMetadataObject = new PathBasedMetadataObject(metadataObject.parent(), metadataObject.name(), locationPath, (AuthorizationMetadataObject.Type)PathBasedMetadataObject.Type.PATH);
            pathBaseMetadataObject.validateAuthorizationMetadataObject();
            authzMetadataObjects.add((AuthorizationMetadataObject)pathBaseMetadataObject);
        });
        return authzMetadataObjects;
    }

    @Override
    public Boolean onMetadataUpdated(MetadataObjectChange ... changes) throws RuntimeException {
        for (MetadataObjectChange change : changes) {
            if (change instanceof MetadataObjectChange.RenameMetadataObject) {
                MetadataObject metadataObject = ((MetadataObjectChange.RenameMetadataObject)change).metadataObject();
                MetadataObject newMetadataObject = ((MetadataObjectChange.RenameMetadataObject)change).newMetadataObject();
                Preconditions.checkArgument((metadataObject.type() == newMetadataObject.type() ? 1 : 0) != 0, (Object)"The old and new metadata object type must be equal!");
                if (metadataObject.type() == MetadataObject.Type.METALAKE) {
                    this.metalake = newMetadataObject.name();
                    continue;
                }
                if (metadataObject.type() == MetadataObject.Type.CATALOG) continue;
                List<AuthorizationMetadataObject> oldAuthzMetadataObjects = this.translateMetadataObject(metadataObject);
                List<AuthorizationMetadataObject> newAuthzMetadataObjects = this.translateMetadataObject(newMetadataObject);
                Preconditions.checkArgument((oldAuthzMetadataObjects.size() == newAuthzMetadataObjects.size() ? 1 : 0) != 0, (Object)"The old and new metadata objects size must be equal!");
                for (int i = 0; i < oldAuthzMetadataObjects.size(); ++i) {
                    AuthorizationMetadataObject newAuthzMetadataObject;
                    AuthorizationMetadataObject oldAuthMetadataObject = oldAuthzMetadataObjects.get(i);
                    if (oldAuthMetadataObject.equals(newAuthzMetadataObject = newAuthzMetadataObjects.get(i))) {
                        LOG.info("The metadata object({}) and new metadata object({}) are equal, so ignore rename!", (Object)oldAuthMetadataObject.fullName(), (Object)newAuthzMetadataObject.fullName());
                        continue;
                    }
                    this.renameMetadataObject(oldAuthMetadataObject, newAuthzMetadataObject);
                }
                continue;
            }
            if (change instanceof MetadataObjectChange.RemoveMetadataObject) {
                MetadataObjectChange.RemoveMetadataObject changeMetadataObject = (MetadataObjectChange.RemoveMetadataObject)change;
                ArrayList authzMetadataObjects = new ArrayList();
                changeMetadataObject.getLocations().stream().forEach(locationPath -> {
                    PathBasedMetadataObject pathBaseMetadataObject = new PathBasedMetadataObject(changeMetadataObject.metadataObject().parent(), changeMetadataObject.metadataObject().name(), locationPath, (AuthorizationMetadataObject.Type)PathBasedMetadataObject.Type.PATH);
                    pathBaseMetadataObject.validateAuthorizationMetadataObject();
                    authzMetadataObjects.add(pathBaseMetadataObject);
                });
                authzMetadataObjects.forEach(this::removeMetadataObject);
                continue;
            }
            throw new IllegalArgumentException("Unsupported metadata object change type: " + (change == null ? "null" : change.getClass().getSimpleName()));
        }
        return Boolean.TRUE;
    }
}

