/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.rel.partitions;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.gravitino.rel.expressions.literals.Literal;
import org.apache.gravitino.rel.partitions.IdentityPartition;
import org.apache.gravitino.rel.partitions.ListPartition;
import org.apache.gravitino.rel.partitions.Partition;
import org.apache.gravitino.rel.partitions.RangePartition;

public class Partitions {
    public static Partition[] EMPTY_PARTITIONS = new Partition[0];

    public static RangePartition range(String name, Literal<?> upper, Literal<?> lower, Map<String, String> properties) {
        return new RangePartitionImpl(name, upper, lower, properties);
    }

    public static ListPartition list(String name, Literal<?>[][] lists, Map<String, String> properties) {
        return new ListPartitionImpl(name, lists, properties);
    }

    public static IdentityPartition identity(String name, String[][] fieldNames, Literal<?>[] values, Map<String, String> properties) {
        return new IdentityPartitionImpl(name, fieldNames, values, properties);
    }

    public static IdentityPartition identity(String[][] fieldNames, Literal<?>[] values) {
        return Partitions.identity(null, fieldNames, values, null);
    }

    private Partitions() {
    }

    private static class IdentityPartitionImpl
    implements IdentityPartition {
        private final String name;
        private final String[][] fieldNames;
        private final Literal<?>[] values;
        private final Map<String, String> properties;

        private IdentityPartitionImpl(String name, String[][] fieldNames, Literal<?>[] values, Map<String, String> properties) {
            this.name = name;
            this.fieldNames = fieldNames;
            this.values = values;
            this.properties = properties;
        }

        @Override
        public String[][] fieldNames() {
            return this.fieldNames;
        }

        @Override
        public Literal<?>[] values() {
            return this.values;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Map<String, String> properties() {
            return this.properties;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IdentityPartitionImpl)) {
                return false;
            }
            IdentityPartitionImpl that = (IdentityPartitionImpl)o;
            return Objects.equals(this.name, that.name) && Arrays.deepEquals((Object[])this.fieldNames, (Object[])that.fieldNames) && Arrays.equals(this.values, that.values) && Objects.equals(this.properties, that.properties);
        }

        public int hashCode() {
            int result = Objects.hash(this.name, this.properties);
            result = 31 * result + Arrays.deepHashCode((Object[])this.fieldNames);
            result = 31 * result + Arrays.hashCode(this.values);
            return result;
        }
    }

    private static class ListPartitionImpl
    implements ListPartition {
        private final String name;
        private final Literal<?>[][] lists;
        private final Map<String, String> properties;

        private ListPartitionImpl(String name, Literal<?>[][] lists, Map<String, String> properties) {
            this.name = name;
            this.properties = properties;
            this.lists = lists;
        }

        @Override
        public Literal<?>[][] lists() {
            return this.lists;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Map<String, String> properties() {
            return this.properties;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ListPartitionImpl)) {
                return false;
            }
            ListPartitionImpl that = (ListPartitionImpl)o;
            return Objects.equals(this.name, that.name) && Arrays.deepEquals(this.lists, that.lists) && Objects.equals(this.properties, that.properties);
        }

        public int hashCode() {
            int result = Objects.hash(this.name, this.properties);
            result = 31 * result + Arrays.deepHashCode(this.lists);
            return result;
        }
    }

    private static class RangePartitionImpl
    implements RangePartition {
        private final String name;
        private final Literal<?> upper;
        private final Literal<?> lower;
        private final Map<String, String> properties;

        private RangePartitionImpl(String name, Literal<?> upper, Literal<?> lower, Map<String, String> properties) {
            this.name = name;
            this.properties = properties;
            this.upper = upper;
            this.lower = lower;
        }

        @Override
        public Literal<?> upper() {
            return this.upper;
        }

        @Override
        public Literal<?> lower() {
            return this.lower;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Map<String, String> properties() {
            return this.properties;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RangePartitionImpl)) {
                return false;
            }
            RangePartitionImpl that = (RangePartitionImpl)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.upper, that.upper) && Objects.equals(this.lower, that.lower) && Objects.equals(this.properties, that.properties);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.upper, this.lower, this.properties);
        }
    }
}

