/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.paimon.Snapshot;
import org.apache.paimon.branch.TableBranch;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.utils.FileUtils;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.StringUtils;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchManager {
    private static final Logger LOG = LoggerFactory.getLogger(BranchManager.class);
    public static final String BRANCH_PREFIX = "branch-";
    public static final String DEFAULT_MAIN_BRANCH = "main";
    private final FileIO fileIO;
    private final Path tablePath;
    private final SnapshotManager snapshotManager;
    private final TagManager tagManager;
    private final SchemaManager schemaManager;

    public BranchManager(FileIO fileIO, Path path, SnapshotManager snapshotManager, TagManager tagManager, SchemaManager schemaManager) {
        this.fileIO = fileIO;
        this.tablePath = path;
        this.snapshotManager = snapshotManager;
        this.tagManager = tagManager;
        this.schemaManager = schemaManager;
    }

    public Path branchDirectory() {
        return new Path(this.tablePath + "/branch");
    }

    public static String getBranchPath(Path tablePath, String branchName) {
        return tablePath.toString() + "/branch/" + BRANCH_PREFIX + branchName;
    }

    public Path branchPath(String branchName) {
        return new Path(BranchManager.getBranchPath(this.tablePath, branchName));
    }

    public void createBranch(String branchName) {
        Preconditions.checkArgument((!branchName.equals(DEFAULT_MAIN_BRANCH) ? 1 : 0) != 0, (Object)String.format("Branch name '%s' is the default branch and cannot be used.", DEFAULT_MAIN_BRANCH));
        Preconditions.checkArgument((!StringUtils.isBlank((String)branchName) ? 1 : 0) != 0, (String)"Branch name '%s' is blank.", (Object[])new Object[]{branchName});
        Preconditions.checkArgument((!this.branchExists(branchName) ? 1 : 0) != 0, (String)"Branch name '%s' already exists.", (Object[])new Object[]{branchName});
        Preconditions.checkArgument((!branchName.chars().allMatch(Character::isDigit) ? 1 : 0) != 0, (String)"Branch name cannot be pure numeric string but is '%s'.", (Object[])new Object[]{branchName});
        try {
            TableSchema latestSchema = this.schemaManager.latest().get();
            this.fileIO.copyFileUtf8(this.schemaManager.toSchemaPath(latestSchema.id()), this.schemaManager.branchSchemaPath(branchName, latestSchema.id()));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Exception occurs when create branch '%s' (directory in %s).", branchName, BranchManager.getBranchPath(this.tablePath, branchName)), e);
        }
    }

    public void createBranch(String branchName, long snapshotId) {
        Preconditions.checkArgument((!branchName.equals(DEFAULT_MAIN_BRANCH) ? 1 : 0) != 0, (Object)String.format("Branch name '%s' is the default branch and cannot be used.", DEFAULT_MAIN_BRANCH));
        Preconditions.checkArgument((!StringUtils.isBlank((String)branchName) ? 1 : 0) != 0, (String)"Branch name '%s' is blank.", (Object[])new Object[]{branchName});
        Preconditions.checkArgument((!this.branchExists(branchName) ? 1 : 0) != 0, (String)"Branch name '%s' already exists.", (Object[])new Object[]{branchName});
        Preconditions.checkArgument((!branchName.chars().allMatch(Character::isDigit) ? 1 : 0) != 0, (String)"Branch name cannot be pure numeric string but is '%s'.", (Object[])new Object[]{branchName});
        Snapshot snapshot = this.snapshotManager.snapshot(snapshotId);
        try {
            this.fileIO.copyFileUtf8(this.snapshotManager.snapshotPath(snapshotId), this.snapshotManager.branchSnapshotPath(branchName, snapshot.id()));
            this.fileIO.copyFileUtf8(this.schemaManager.toSchemaPath(snapshot.schemaId()), this.schemaManager.branchSchemaPath(branchName, snapshot.schemaId()));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Exception occurs when create branch '%s' (directory in %s).", branchName, BranchManager.getBranchPath(this.tablePath, branchName)), e);
        }
    }

    public void createBranch(String branchName, String tagName) {
        Preconditions.checkArgument((!branchName.equals(DEFAULT_MAIN_BRANCH) ? 1 : 0) != 0, (Object)String.format("Branch name '%s' is the default branch and cannot be used.", DEFAULT_MAIN_BRANCH));
        Preconditions.checkArgument((!StringUtils.isBlank((String)branchName) ? 1 : 0) != 0, (String)"Branch name '%s' is blank.", (Object[])new Object[]{branchName});
        Preconditions.checkArgument((!this.branchExists(branchName) ? 1 : 0) != 0, (String)"Branch name '%s' already exists.", (Object[])new Object[]{branchName});
        Preconditions.checkArgument((boolean)this.tagManager.tagExists(tagName), (String)"Tag name '%s' not exists.", (Object[])new Object[]{tagName});
        Preconditions.checkArgument((!branchName.chars().allMatch(Character::isDigit) ? 1 : 0) != 0, (String)"Branch name cannot be pure numeric string but is '%s'.", (Object[])new Object[]{branchName});
        Snapshot snapshot = this.tagManager.taggedSnapshot(tagName);
        try {
            this.fileIO.copyFileUtf8(this.tagManager.tagPath(tagName), this.tagManager.branchTagPath(branchName, tagName));
            this.fileIO.copyFileUtf8(this.snapshotManager.snapshotPath(snapshot.id()), this.snapshotManager.branchSnapshotPath(branchName, snapshot.id()));
            this.fileIO.copyFileUtf8(this.schemaManager.toSchemaPath(snapshot.schemaId()), this.schemaManager.branchSchemaPath(branchName, snapshot.schemaId()));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Exception occurs when create branch '%s' (directory in %s).", branchName, BranchManager.getBranchPath(this.tablePath, branchName)), e);
        }
    }

    public void deleteBranch(String branchName) {
        Preconditions.checkArgument((boolean)this.branchExists(branchName), (String)"Branch name '%s' doesn't exist.", (Object[])new Object[]{branchName});
        try {
            this.fileIO.delete(this.branchPath(branchName), true);
        }
        catch (IOException e) {
            LOG.info(String.format("Deleting the branch failed due to an exception in deleting the directory %s. Please try again.", BranchManager.getBranchPath(this.tablePath, branchName)), (Throwable)e);
        }
    }

    public boolean fileExists(Path path) {
        try {
            return this.fileIO.exists(path);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to determine if path '%s' exists.", path), e);
        }
    }

    public boolean branchExists(String branchName) {
        Path branchPath = this.branchPath(branchName);
        return this.fileExists(branchPath);
    }

    public long branchCount() {
        try {
            return FileUtils.listVersionedDirectories(this.fileIO, this.branchDirectory(), BRANCH_PREFIX).count();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<TableBranch> branches() {
        try {
            List paths = FileUtils.listVersionedDirectories(this.fileIO, this.branchDirectory(), BRANCH_PREFIX).map(status -> Pair.of((Object)status.getPath(), (Object)status.getModificationTime())).collect(Collectors.toList());
            PriorityQueue<TableBranch> pq = new PriorityQueue<TableBranch>(Comparator.comparingLong(TableBranch::getCreateTime));
            for (Pair path : paths) {
                String branchName = ((Path)path.getLeft()).getName().substring(BRANCH_PREFIX.length());
                Optional<TableSchema> tableSchema = this.schemaManager.latest(branchName);
                if (!tableSchema.isPresent()) {
                    pq.add(new TableBranch(branchName, (Long)path.getValue()));
                    continue;
                }
                FileStoreTable branchTable = FileStoreTableFactory.create(this.fileIO, new Path(BranchManager.getBranchPath(this.tablePath, branchName)));
                SortedMap<Snapshot, List<String>> snapshotTags = branchTable.tagManager().tags();
                Long earliestSnapshotId = branchTable.snapshotManager().earliestSnapshotId();
                if (snapshotTags.isEmpty()) {
                    pq.add(new TableBranch(branchName, earliestSnapshotId, (Long)path.getValue()));
                    continue;
                }
                Snapshot snapshot = snapshotTags.firstKey();
                if (earliestSnapshotId.longValue() == snapshot.id()) {
                    List tags = (List)snapshotTags.get(snapshot);
                    Preconditions.checkArgument((tags.size() == 1 ? 1 : 0) != 0);
                    pq.add(new TableBranch(branchName, (String)tags.get(0), snapshot.id(), (Long)path.getValue()));
                    continue;
                }
                pq.add(new TableBranch(branchName, earliestSnapshotId, (Long)path.getValue()));
            }
            ArrayList<TableBranch> branches = new ArrayList<TableBranch>(pq.size());
            while (!pq.isEmpty()) {
                branches.add(pq.poll());
            }
            return branches;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

