/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.net.URI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.core.codec.Hints;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.server.DefaultServerResponseBuilder;
import org.springframework.web.reactive.function.server.EntityResponse;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

class DefaultEntityResponseBuilder<T>
implements EntityResponse.Builder<T> {
    private final T entity;
    private final BodyInserter<T, ? super ServerHttpResponse> inserter;
    private HttpStatusCode status = HttpStatus.OK;
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, ResponseCookie> cookies = new LinkedMultiValueMap();
    private final Map<String, Object> hints = new HashMap<String, Object>();

    public DefaultEntityResponseBuilder(T entity, BodyInserter<T, ? super ServerHttpResponse> inserter) {
        this.entity = entity;
        this.inserter = inserter;
    }

    @Override
    public EntityResponse.Builder<T> status(HttpStatusCode status) {
        Assert.notNull((Object)status, (String)"HttpStatusCode must not be null");
        this.status = status;
        return this;
    }

    @Override
    public EntityResponse.Builder<T> status(int status) {
        return this.status(HttpStatusCode.valueOf((int)status));
    }

    @Override
    public EntityResponse.Builder<T> cookie(ResponseCookie cookie) {
        Assert.notNull((Object)cookie, (String)"ResponseCookie must not be null");
        this.cookies.add((Object)cookie.getName(), (Object)cookie);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> cookies(Consumer<MultiValueMap<String, ResponseCookie>> cookiesConsumer) {
        cookiesConsumer.accept(this.cookies);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> header(String headerName, String ... headerValues) {
        for (String headerValue : headerValues) {
            this.headers.add(headerName, headerValue);
        }
        return this;
    }

    @Override
    public EntityResponse.Builder<T> headers(HttpHeaders headers) {
        this.headers.putAll((Map)headers);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> headers(Consumer<HttpHeaders> headersConsumer) {
        Assert.notNull(headersConsumer, (String)"HeadersConsumer must not be null");
        headersConsumer.accept(this.headers);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> allow(HttpMethod ... allowedMethods) {
        this.headers.setAllow(new LinkedHashSet<HttpMethod>(Arrays.asList(allowedMethods)));
        return this;
    }

    @Override
    public EntityResponse.Builder<T> allow(Set<HttpMethod> allowedMethods) {
        this.headers.setAllow(allowedMethods);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> contentLength(long contentLength) {
        this.headers.setContentLength(contentLength);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> contentType(MediaType contentType) {
        this.headers.setContentType(contentType);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> eTag(String tag) {
        this.headers.setETag(tag);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> hint(String key, Object value) {
        this.hints.put(key, value);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> hints(Consumer<Map<String, Object>> hintsConsumer) {
        hintsConsumer.accept(this.hints);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> lastModified(ZonedDateTime lastModified) {
        this.headers.setLastModified(lastModified);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> lastModified(Instant lastModified) {
        this.headers.setLastModified(lastModified);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> location(URI location) {
        this.headers.setLocation(location);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> cacheControl(CacheControl cacheControl) {
        this.headers.setCacheControl(cacheControl);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> varyBy(String ... requestHeaders) {
        this.headers.setVary(Arrays.asList(requestHeaders));
        return this;
    }

    @Override
    public Mono<EntityResponse<T>> build() {
        return Mono.just(new DefaultEntityResponse<T>(this.status, this.headers, this.cookies, this.entity, this.inserter, this.hints));
    }

    private static final class DefaultEntityResponse<T>
    extends DefaultServerResponseBuilder.AbstractServerResponse
    implements EntityResponse<T> {
        private final T entity;
        private final BodyInserter<T, ? super ServerHttpResponse> inserter;

        public DefaultEntityResponse(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, ResponseCookie> cookies, T entity, BodyInserter<T, ? super ServerHttpResponse> inserter, Map<String, Object> hints) {
            super(statusCode, headers, cookies, hints);
            this.entity = entity;
            this.inserter = inserter;
        }

        @Override
        public T entity() {
            return this.entity;
        }

        @Override
        public BodyInserter<T, ? super ServerHttpResponse> inserter() {
            return this.inserter;
        }

        @Override
        protected Mono<Void> writeToInternal(final ServerWebExchange exchange2, final ServerResponse.Context context) {
            return this.inserter().insert(exchange2.getResponse(), new BodyInserter.Context(){

                @Override
                public List<HttpMessageWriter<?>> messageWriters() {
                    return context.messageWriters();
                }

                @Override
                public Optional<ServerHttpRequest> serverRequest() {
                    return Optional.of(exchange2.getRequest());
                }

                @Override
                public Map<String, Object> hints() {
                    hints.put(Hints.LOG_PREFIX_HINT, exchange2.getLogPrefix());
                    return hints;
                }
            });
        }
    }
}

