/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.scheduler.netty.process;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import org.apache.hertzbeat.common.entity.message.ClusterMsg;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.common.support.SpringContextHolder;
import org.apache.hertzbeat.common.util.ArrowUtil;
import org.apache.hertzbeat.remoting.netty.NettyRemotingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectCyclicDataResponseProcessor
implements NettyRemotingProcessor {
    private static final Logger log = LoggerFactory.getLogger(CollectCyclicDataResponseProcessor.class);

    public ClusterMsg.Message handle(ChannelHandlerContext ctx, ClusterMsg.Message message) {
        CommonDataQueue dataQueue = SpringContextHolder.getBean(CommonDataQueue.class);
        List<CollectRep.MetricsData> metricsDataList = ArrowUtil.deserializeMetricsData(message.getMsg().toByteArray());
        for (CollectRep.MetricsData metricsData : metricsDataList) {
            if (metricsData == null) continue;
            dataQueue.sendMetricsData(metricsData);
        }
        return null;
    }
}

