/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.push.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.push.config.PushErrorRequestWrapper;
import org.apache.hertzbeat.push.config.PushSuccessRequestWrapper;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Metrics Push Gateway API")
@RestController
@RequestMapping(value={"/api/push/prometheus/**"})
public class PushPrometheusController {
    @PostMapping
    @Operation(summary="Prometheus push gateway", description="Push prometheus metric data to hertzbeat")
    public ResponseEntity<Message<Void>> pushMetrics(HttpServletRequest request) {
        if (request instanceof PushErrorRequestWrapper) {
            PushErrorRequestWrapper error = (PushErrorRequestWrapper)request;
            return ResponseEntity.badRequest().body((Object)Message.success((String)String.format("Push failed, job: %s, instance: %s", error.getJob(), error.getInstance())));
        }
        if (request instanceof PushSuccessRequestWrapper) {
            PushSuccessRequestWrapper success = (PushSuccessRequestWrapper)request;
            return ResponseEntity.ok((Object)Message.success((String)String.format("Push success, job: %s, instance: %s", success.getJob(), success.getInstance())));
        }
        return ResponseEntity.badRequest().body((Object)Message.success((String)String.format("Request  %s not matched.", request.getRequestURI())));
    }
}

