/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.s7;

import java.util.List;
import org.apache.hertzbeat.collector.collect.plc.AbstractPlcCollectImpl;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.PlcProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.S7Protocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public class S7CollectImpl
extends AbstractPlcCollectImpl {
    private static final Logger log = LoggerFactory.getLogger(S7CollectImpl.class);

    @Override
    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        S7Protocol s7 = metrics.getS7();
        List registerAddressList = s7.getRegisterAddresses();
        if (!StringUtils.hasText((String)s7.getRackId())) {
            s7.setRackId("0");
        }
        if (!StringUtils.hasText((String)s7.getSlotId())) {
            s7.setSlotId("0");
        }
        if (!StringUtils.hasText((String)s7.getControllerType())) {
            s7.setControllerType("S7_1500");
        }
        if (!StringUtils.hasText((String)s7.getTimeout())) {
            s7.setTimeout("5000");
        }
        PlcProtocol plc = metrics.getPlc() == null ? new PlcProtocol() : metrics.getPlc();
        plc.setRegisterAddresses(registerAddressList);
        BeanUtils.copyProperties((Object)s7, (Object)plc);
        metrics.setPlc(plc);
        super.preCheck(metrics);
    }

    @Override
    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        super.collect(builder, metrics);
    }

    public String supportProtocol() {
        return "s7";
    }

    @Override
    protected String getConnectionString(Metrics metrics) {
        S7Protocol s7Protocol = metrics.getS7();
        return "s7://" + s7Protocol.getHost() + ":" + s7Protocol.getPort() + "?remote-rack:" + s7Protocol.getRackId() + "&remote-slot:" + s7Protocol.getSlotId() + "&controller-type=" + s7Protocol.getControllerType();
    }

    @Override
    protected PlcReadRequest buildRequest(Metrics metrics, PlcConnection connection) {
        S7Protocol s7Protocol = metrics.getS7();
        List registerAddressList = s7Protocol.getRegisterAddresses();
        PlcReadRequest.Builder requestBuilder = connection.readRequestBuilder();
        for (int i = 0; i < registerAddressList.size(); ++i) {
            String s1 = (String)registerAddressList.get(i);
            requestBuilder.addTagAddress(metrics.getS7().getAddressSyntax() + ":" + i, s1);
        }
        return requestBuilder.build();
    }
}

