/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;

abstract class TimeoutCommand<T> {
    private final long startTime;
    private final int timeout;
    private final T command;
    private final SQLServerConnection sqlServerConnection;

    TimeoutCommand(int timeout, T command, SQLServerConnection sqlServerConnection) {
        this.timeout = timeout;
        this.command = command;
        this.sqlServerConnection = sqlServerConnection;
        this.startTime = System.currentTimeMillis();
    }

    protected boolean canTimeout() {
        long currentTime = System.currentTimeMillis();
        return (currentTime - this.startTime) / 1000L >= (long)this.timeout;
    }

    protected T getCommand() {
        return this.command;
    }

    protected SQLServerConnection getSqlServerConnection() {
        return this.sqlServerConnection;
    }

    protected abstract void interrupt() throws Exception;
}

