/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import java.util.HashMap;
import java.util.Map;

public enum ModbusErrorCode {
    ILLEGAL_FUNCTION(1),
    ILLEGAL_DATA_ADDRESS(2),
    ILLEGAL_DATA_VALUE(3),
    SLAVE_DEVICE_FAILURE(4),
    ACKNOWLEDGE(5),
    SLAVE_DEVICE_BUSY(6),
    NEGATIVE_ACKNOWLEDGE(7),
    MEMORY_PARITY_ERROR(8),
    GATEWAY_PATH_UNAVAILABLE(10),
    GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND(11);

    private static final Map<Short, ModbusErrorCode> map;
    private final short value;

    static {
        map = new HashMap<Short, ModbusErrorCode>();
        ModbusErrorCode[] modbusErrorCodeArray = ModbusErrorCode.values();
        int n = modbusErrorCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModbusErrorCode value = modbusErrorCodeArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private ModbusErrorCode(short value) {
        this.value = value;
    }

    public short getValue() {
        return this.value;
    }

    public static ModbusErrorCode enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }
}

