/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.hertzbeat.common.entity.alerter.JsonMapAttributeConverter;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_status_page_component")
@Schema(description="status page component entity")
@EntityListeners(value={AuditingEntityListener.class})
public class StatusPageComponent {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="ID", example="87584674384")
    private Long id;
    @Schema(title="org id", example="1234")
    private Long orgId;
    @Schema(title="component name", example="Gateway")
    @NotBlank
    private String name;
    @Schema(title="component desc", example="TanCloud Gateway")
    private String description;
    @Schema(title="component label", example="{env:test}", accessMode=Schema.AccessMode.READ_WRITE)
    @Convert(converter=JsonMapAttributeConverter.class)
    @Column(length=4096)
    private Map<String, String> labels;
    @Schema(title="calculate status method: 0-auto 1-manual", example="0")
    private byte method;
    @Schema(title="config state when use manual method: 0-Normal 1-Abnormal 2-unknown", example="0")
    private byte configState;
    @Schema(title="component current state: 0-Normal 1-Abnormal 2-unknown", example="0")
    private byte state;
    @Schema(title="The creator of this record", example="tom")
    @CreatedBy
    private String creator;
    @Schema(title="The modifier of this record", example="tom")
    @LastModifiedBy
    private String modifier;
    @Schema(title="Record create time", example="1612198922000")
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record modify time", example="1612198444000")
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public static StatusPageComponentBuilder builder() {
        return new StatusPageComponentBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public byte getMethod() {
        return this.method;
    }

    public byte getConfigState() {
        return this.configState;
    }

    public byte getState() {
        return this.state;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public void setMethod(byte method) {
        this.method = method;
    }

    public void setConfigState(byte configState) {
        this.configState = configState;
    }

    public void setState(byte state) {
        this.state = state;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatusPageComponent)) {
            return false;
        }
        StatusPageComponent other = (StatusPageComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMethod() != other.getMethod()) {
            return false;
        }
        if (this.getConfigState() != other.getConfigState()) {
            return false;
        }
        if (this.getState() != other.getState()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$orgId = this.getOrgId();
        Long other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        return !(this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatusPageComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMethod();
        result = result * 59 + this.getConfigState();
        result = result * 59 + this.getState();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        return result;
    }

    public String toString() {
        return "StatusPageComponent(id=" + this.getId() + ", orgId=" + this.getOrgId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", labels=" + this.getLabels() + ", method=" + this.getMethod() + ", configState=" + this.getConfigState() + ", state=" + this.getState() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public StatusPageComponent(Long id, Long orgId, String name, String description, Map<String, String> labels, byte method, byte configState, byte state, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.orgId = orgId;
        this.name = name;
        this.description = description;
        this.labels = labels;
        this.method = method;
        this.configState = configState;
        this.state = state;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public StatusPageComponent() {
    }

    public static class StatusPageComponentBuilder {
        private Long id;
        private Long orgId;
        private String name;
        private String description;
        private Map<String, String> labels;
        private byte method;
        private byte configState;
        private byte state;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        StatusPageComponentBuilder() {
        }

        public StatusPageComponentBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public StatusPageComponentBuilder orgId(Long orgId) {
            this.orgId = orgId;
            return this;
        }

        public StatusPageComponentBuilder name(String name) {
            this.name = name;
            return this;
        }

        public StatusPageComponentBuilder description(String description) {
            this.description = description;
            return this;
        }

        public StatusPageComponentBuilder labels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public StatusPageComponentBuilder method(byte method) {
            this.method = method;
            return this;
        }

        public StatusPageComponentBuilder configState(byte configState) {
            this.configState = configState;
            return this;
        }

        public StatusPageComponentBuilder state(byte state) {
            this.state = state;
            return this;
        }

        public StatusPageComponentBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public StatusPageComponentBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public StatusPageComponentBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public StatusPageComponentBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public StatusPageComponent build() {
            return new StatusPageComponent(this.id, this.orgId, this.name, this.description, this.labels, this.method, this.configState, this.state, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "StatusPageComponent.StatusPageComponentBuilder(id=" + this.id + ", orgId=" + this.orgId + ", name=" + this.name + ", description=" + this.description + ", labels=" + this.labels + ", method=" + this.method + ", configState=" + this.configState + ", state=" + this.state + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

