/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.subject.creater;

import com.usthe.sureness.subject.Subject;
import com.usthe.sureness.subject.SubjectCreate;
import com.usthe.sureness.subject.support.JwtSubject;
import com.usthe.sureness.util.JsonWebTokenUtil;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class JwtSubjectSpringReactiveCreator
implements SubjectCreate {
    private static final Logger logger = LoggerFactory.getLogger(JwtSubjectSpringReactiveCreator.class);

    @Override
    public boolean canSupportSubject(Object context) {
        String authorization;
        if (context instanceof ServerHttpRequest && (authorization = ((ServerHttpRequest)context).getHeaders().getFirst("Authorization")) != null && authorization.startsWith("Bearer")) {
            String jwtValue = authorization.replace("Bearer", "").trim();
            return !JsonWebTokenUtil.isNotJsonWebToken(jwtValue);
        }
        return false;
    }

    @Override
    public Subject createSubject(Object context) {
        String authorization = ((ServerHttpRequest)context).getHeaders().getFirst("Authorization");
        if (authorization != null && authorization.startsWith("Bearer")) {
            String jwtValue = authorization.replace("Bearer", "").trim();
            if (JsonWebTokenUtil.isNotJsonWebToken(jwtValue)) {
                if (logger.isInfoEnabled()) {
                    logger.info("can not create JwtSubject by this request message, is not jwt");
                }
                return null;
            }
            InetSocketAddress remoteAddress = ((ServerHttpRequest)context).getRemoteAddress();
            String remoteHost = remoteAddress == null ? "" : remoteAddress.getHostString();
            String requestUri = ((ServerHttpRequest)context).getPath().value();
            String requestType = ((ServerHttpRequest)context).getMethodValue();
            String targetUri = requestUri.concat("===").concat(requestType.toLowerCase());
            return JwtSubject.builder(jwtValue).setRemoteHost(remoteHost).setTargetResource(targetUri).build();
        }
        return null;
    }
}

