/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.cache.manager;

import cn.afterturn.easypoi.cache.manager.IFileLoader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLoaderImpl
implements IFileLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLoaderImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getFile(String url) {
        byte[] byArray;
        InputStream fileis = null;
        ByteArrayOutputStream baos = null;
        try {
            int len;
            if (url.startsWith("http")) {
                URL urlObj = new URL(url);
                URLConnection urlConnection = urlObj.openConnection();
                urlConnection.setConnectTimeout(30000);
                urlConnection.setReadTimeout(60000);
                urlConnection.setDoInput(true);
                fileis = urlConnection.getInputStream();
            } else {
                try {
                    fileis = new FileInputStream(url);
                }
                catch (FileNotFoundException e) {
                    fileis = FileLoaderImpl.class.getClassLoader().getResourceAsStream(url);
                }
            }
            baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = fileis.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            byArray = baos.toByteArray();
        }
        catch (Exception e) {
            try {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileis);
                IOUtils.closeQuietly(baos);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)fileis);
            IOUtils.closeQuietly(baos);
        }
        IOUtils.closeQuietly((Closeable)fileis);
        IOUtils.closeQuietly((Closeable)baos);
        return byArray;
        LOGGER.error(fileis + "\u8fd9\u4e2a\u8def\u5f84\u6587\u4ef6\u6ca1\u6709\u627e\u5230,\u8bf7\u67e5\u8be2");
        return null;
    }
}

