/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.config;

import com.alibaba.nacos.api.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;

public enum ConfigType {
    PROPERTIES("properties"),
    XML("xml"),
    JSON("json"),
    TEXT("text"),
    HTML("html"),
    YAML("yaml"),
    UNSET("unset");

    private final String type;
    private static final Map<String, ConfigType> LOCAL_MAP;

    private ConfigType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static ConfigType getDefaultType() {
        return TEXT;
    }

    public static Boolean isValidType(String type) {
        if (StringUtils.isBlank(type)) {
            return false;
        }
        return null != LOCAL_MAP.get(type);
    }

    static {
        LOCAL_MAP = new HashMap<String, ConfigType>();
        for (ConfigType configType : ConfigType.values()) {
            LOCAL_MAP.put(configType.getType(), configType);
        }
    }
}

