/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.dto;

import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Alarm Statistics Information")
public class AlertSummary {
    @Schema(title="Total number of alerts (including processed and unprocessed alerts)", example="134", accessMode=Schema.AccessMode.READ_ONLY)
    private long total;
    @Schema(title="Number of alerts handled", example="34", accessMode=Schema.AccessMode.READ_ONLY)
    private long dealNum;
    @Schema(title="Alarm handling rate", example="39.34", accessMode=Schema.AccessMode.READ_ONLY)
    private float rate;
    @Schema(title="Number of alarms whose alarm severity is warning alarms (referring to unhandled alarms)", example="43", accessMode=Schema.AccessMode.READ_ONLY)
    private long priorityWarningNum;
    @Schema(title="Number of alarms whose alarm severity is critical alarms (referring to unhandled alarms)", example="56", accessMode=Schema.AccessMode.READ_ONLY)
    private long priorityCriticalNum;
    @Schema(title="Number of alarms whose alarm severity is urgent alarms (referring to unhandled alarms)", example="23", accessMode=Schema.AccessMode.READ_ONLY)
    private long priorityEmergencyNum;

    public long getTotal() {
        return this.total;
    }

    public long getDealNum() {
        return this.dealNum;
    }

    public float getRate() {
        return this.rate;
    }

    public long getPriorityWarningNum() {
        return this.priorityWarningNum;
    }

    public long getPriorityCriticalNum() {
        return this.priorityCriticalNum;
    }

    public long getPriorityEmergencyNum() {
        return this.priorityEmergencyNum;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setDealNum(long dealNum) {
        this.dealNum = dealNum;
    }

    public void setRate(float rate) {
        this.rate = rate;
    }

    public void setPriorityWarningNum(long priorityWarningNum) {
        this.priorityWarningNum = priorityWarningNum;
    }

    public void setPriorityCriticalNum(long priorityCriticalNum) {
        this.priorityCriticalNum = priorityCriticalNum;
    }

    public void setPriorityEmergencyNum(long priorityEmergencyNum) {
        this.priorityEmergencyNum = priorityEmergencyNum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlertSummary)) {
            return false;
        }
        AlertSummary other = (AlertSummary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (this.getDealNum() != other.getDealNum()) {
            return false;
        }
        if (Float.compare(this.getRate(), other.getRate()) != 0) {
            return false;
        }
        if (this.getPriorityWarningNum() != other.getPriorityWarningNum()) {
            return false;
        }
        if (this.getPriorityCriticalNum() != other.getPriorityCriticalNum()) {
            return false;
        }
        return this.getPriorityEmergencyNum() == other.getPriorityEmergencyNum();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlertSummary;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        long $dealNum = this.getDealNum();
        result = result * 59 + (int)($dealNum >>> 32 ^ $dealNum);
        result = result * 59 + Float.floatToIntBits(this.getRate());
        long $priorityWarningNum = this.getPriorityWarningNum();
        result = result * 59 + (int)($priorityWarningNum >>> 32 ^ $priorityWarningNum);
        long $priorityCriticalNum = this.getPriorityCriticalNum();
        result = result * 59 + (int)($priorityCriticalNum >>> 32 ^ $priorityCriticalNum);
        long $priorityEmergencyNum = this.getPriorityEmergencyNum();
        result = result * 59 + (int)($priorityEmergencyNum >>> 32 ^ $priorityEmergencyNum);
        return result;
    }

    public String toString() {
        return "AlertSummary(total=" + this.getTotal() + ", dealNum=" + this.getDealNum() + ", rate=" + this.getRate() + ", priorityWarningNum=" + this.getPriorityWarningNum() + ", priorityCriticalNum=" + this.getPriorityCriticalNum() + ", priorityEmergencyNum=" + this.getPriorityEmergencyNum() + ")";
    }

    public AlertSummary(long total, long dealNum, float rate, long priorityWarningNum, long priorityCriticalNum, long priorityEmergencyNum) {
        this.total = total;
        this.dealNum = dealNum;
        this.rate = rate;
        this.priorityWarningNum = priorityWarningNum;
        this.priorityCriticalNum = priorityCriticalNum;
        this.priorityEmergencyNum = priorityEmergencyNum;
    }

    public AlertSummary() {
    }
}

