/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.websocket;

import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@ChannelHandler.Sharable
@Singleton
public class MqttWebSocketCodec
extends ChannelDuplexHandler {
    @NotNull
    public static final String NAME = "ws.mqtt";

    @Inject
    MqttWebSocketCodec() {
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        if (msg instanceof WebSocketFrame) {
            WebSocketFrame webSocketFrame = (WebSocketFrame)msg;
            if (msg instanceof BinaryWebSocketFrame || msg instanceof ContinuationWebSocketFrame) {
                ctx.fireChannelRead((Object)webSocketFrame.content());
            } else if (msg instanceof TextWebSocketFrame) {
                webSocketFrame.release();
                MqttDisconnectUtil.close(ctx.channel(), "Must not receive text websocket frames");
            } else if (msg instanceof CloseWebSocketFrame) {
                webSocketFrame.release();
                ctx.close();
            } else if (msg instanceof PingWebSocketFrame) {
                ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(webSocketFrame.content()));
            } else {
                webSocketFrame.release();
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void write(@NotNull ChannelHandlerContext ctx, @NotNull Object msg, @NotNull ChannelPromise promise) {
        if (msg instanceof ByteBuf) {
            ctx.write((Object)new BinaryWebSocketFrame((ByteBuf)msg), promise);
        } else {
            ctx.write(msg, promise);
        }
    }

    public boolean isSharable() {
        return true;
    }
}

