/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.stream.JsonGenerator;
import org.glassfish.json.JsonGeneratorImpl;
import org.glassfish.json.JsonPrettyGeneratorImpl;
import org.glassfish.json.JsonProviderImpl;

class JsonWriterImpl
implements JsonWriter {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final JsonGenerator generator;
    private boolean writeDone;

    JsonWriterImpl(Writer writer) {
        this(writer, Collections.emptyMap());
    }

    JsonWriterImpl(Writer writer, Map<String, ?> config) {
        boolean prettyPrinting = JsonProviderImpl.isPrettyPrintingEnabled(config);
        this.generator = prettyPrinting ? new JsonPrettyGeneratorImpl(writer) : new JsonGeneratorImpl(writer);
    }

    JsonWriterImpl(OutputStream out) {
        this(out, UTF_8, Collections.emptyMap());
    }

    JsonWriterImpl(OutputStream out, Map<String, ?> config) {
        this(out, UTF_8, config);
    }

    JsonWriterImpl(OutputStream out, Charset charset, Map<String, ?> config) {
        boolean prettyPrinting = JsonProviderImpl.isPrettyPrintingEnabled(config);
        this.generator = prettyPrinting ? new JsonPrettyGeneratorImpl(out, charset) : new JsonGeneratorImpl(out, charset);
    }

    @Override
    public void writeArray(JsonArray array) {
        if (this.writeDone) {
            throw new IllegalStateException("write/writeObject/writeArray/close method is already called.");
        }
        this.writeDone = true;
        this.generator.writeStartArray();
        for (JsonValue value : array) {
            this.generator.write(value);
        }
        this.generator.writeEnd();
    }

    @Override
    public void writeObject(JsonObject object) {
        if (this.writeDone) {
            throw new IllegalStateException("write/writeObject/writeArray/close method is already called.");
        }
        this.writeDone = true;
        this.generator.writeStartObject();
        for (Map.Entry e : object.entrySet()) {
            this.generator.write((String)e.getKey(), (JsonValue)e.getValue());
        }
        this.generator.writeEnd();
    }

    @Override
    public void write(JsonStructure value) {
        if (value instanceof JsonArray) {
            this.writeArray((JsonArray)value);
        } else {
            this.writeObject((JsonObject)value);
        }
    }

    @Override
    public void close() {
        this.writeDone = true;
        this.generator.close();
    }
}

