/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.extracting;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ansj.app.extracting.ExtractingTask;
import org.ansj.app.extracting.Lexical;
import org.ansj.app.extracting.domain.ExtractingResult;
import org.ansj.app.extracting.domain.Rule;
import org.ansj.app.extracting.domain.RuleIndex;
import org.ansj.app.extracting.exception.RuleFormatException;
import org.ansj.domain.Result;
import org.ansj.domain.Term;
import org.ansj.library.DicLibrary;
import org.ansj.recognition.arrimpl.UserDefineRecognition;
import org.ansj.splitWord.analysis.DicAnalysis;
import org.ansj.util.Graph;
import org.ansj.util.TermUtil;
import org.nlpcn.commons.lang.tire.domain.Forest;
import org.nlpcn.commons.lang.util.IOUtil;
import org.nlpcn.commons.lang.util.StringUtil;

public class Extracting {
    private RuleIndex ruleIndex = new RuleIndex();

    public Extracting() {
    }

    public Extracting(List<String> lines) throws RuleFormatException {
        this.addRules(lines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extracting(InputStream is, String encoding) throws RuleFormatException, IOException {
        try {
            List lines = IOUtil.readFile2List((BufferedReader)IOUtil.getReader((InputStream)is, (String)encoding));
            this.addRules(lines);
        }
        finally {
            is.close();
        }
    }

    public Extracting(Reader reader) throws RuleFormatException, IOException {
        try {
            List lines = IOUtil.readFile2List((BufferedReader)new BufferedReader(reader));
            this.addRules(lines);
        }
        finally {
            reader.close();
        }
    }

    public void addRules(List<String> lines) throws RuleFormatException {
        for (String line : lines) {
            this.addRuleStr(line);
        }
    }

    public void addRule(Rule rule) {
        this.ruleIndex.add(rule);
    }

    public void addRuleStr(String line) throws RuleFormatException {
        if (StringUtil.isNotBlank((CharSequence)line)) {
            this.addRule(Lexical.parse(line));
        }
    }

    public ExtractingResult parse(String content, Forest ... forests) {
        Forest[] myForests = null;
        if (forests == null) {
            myForests = new Forest[]{this.ruleIndex.getForest()};
        } else if (forests.length == 0) {
            myForests = new Forest[]{this.ruleIndex.getForest(), DicLibrary.get()};
        } else {
            myForests = new Forest[forests.length + 1];
            myForests[0] = this.ruleIndex.getForest();
            for (int i = 0; i < forests.length; ++i) {
                myForests[i + 1] = forests[i];
            }
        }
        Result terms = DicAnalysis.parse(content, myForests);
        return this.parse(terms, false);
    }

    public ExtractingResult parse(Result terms) {
        return this.parse(terms, true);
    }

    private ExtractingResult parse(Result terms, boolean useForest) {
        Object result;
        if (terms == null || terms.size() == 0) {
            return new ExtractingResult();
        }
        if (useForest) {
            Graph graph = new Graph(terms);
            new UserDefineRecognition(TermUtil.InsertTermType.REPLACE, this.ruleIndex.getForest()).recognition(graph);
            graph.rmLittlePath();
            result = new ArrayList();
            int length = graph.terms.length - 1;
            for (int i = 0; i < length; ++i) {
                if (graph.terms[i] == null) continue;
                result.add(graph.terms[i]);
            }
            terms = new Result((List<Term>)result);
        }
        ArrayList<ExtractingTask> tasks = new ArrayList<ExtractingTask>();
        result = new ExtractingResult();
        for (int i = 0; i < terms.size(); ++i) {
            Term term = terms.get(i);
            HashSet<Rule> sets = new HashSet<Rule>();
            Set<Rule> rules = this.ruleIndex.getRules(term.getName());
            if (rules != null) {
                sets.addAll(rules);
            }
            if ((rules = this.ruleIndex.getRules(":" + term.getNatureStr())) != null) {
                sets.addAll(rules);
            }
            if ((rules = this.ruleIndex.getRules(":*")) != null) {
                sets.addAll(rules);
            }
            for (Rule rule : sets) {
                tasks.add(new ExtractingTask((ExtractingResult)result, rule, i, terms));
            }
        }
        for (ExtractingTask task : tasks) {
            task.run();
        }
        return result;
    }
}

