/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.dic.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Vector;
import org.ansj.dic.PathToStream;
import org.ansj.exception.LibraryException;
import org.nlpcn.commons.lang.util.logging.Log;
import org.nlpcn.commons.lang.util.logging.LogFactory;

public class File2Stream
extends PathToStream {
    private static final Log LOG = LogFactory.getLog(File2Stream.class);

    @Override
    public InputStream toStream(String path) {
        File file;
        LOG.info("path to stream " + path);
        if (path.startsWith("file://")) {
            path = path.substring(7);
        }
        if ((file = new File(path)).exists() && file.canRead()) {
            try {
                if (file.isDirectory()) {
                    return this.multiple(path);
                }
                return new FileInputStream(file);
            }
            catch (Exception e) {
                throw new LibraryException(e);
            }
        }
        throw new LibraryException(" path :" + path + " file:" + file.getAbsolutePath() + " not found or can not to read");
    }

    private InputStream multiple(String path) throws FileNotFoundException {
        File[] libs = new File[]{};
        File file = new File(path);
        if (file.exists() && file.canRead()) {
            File[] files;
            if (file.isFile()) {
                libs = new File[]{file};
            } else if (file.isDirectory() && (files = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.canRead() && !file.isHidden() && !file.isDirectory();
                }
            })) != null && files.length > 0) {
                libs = files;
            }
        }
        if (libs.length == 0) {
            throw new LibraryException("not find any file in path : " + path);
        }
        if (libs.length == 1) {
            return new FileInputStream(libs[0]);
        }
        Vector<InputStream> vector = new Vector<InputStream>(libs.length);
        for (int i = 0; i < libs.length; ++i) {
            vector.add(new FileInputStream(libs[i]));
            if (i >= libs.length - 1) continue;
            vector.add(new ByteArrayInputStream("\n".getBytes(StandardCharsets.UTF_8)));
        }
        return new SequenceInputStream(vector.elements());
    }
}

