/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.util;

import java.io.IOException;
import java.io.Reader;

public class AnsjReader
extends Reader {
    private Reader in;
    private char[] cb;
    private static int defaultCharBufferSize = 8192;
    private int start = 0;
    private int tempStart = 0;
    int offe = 0;
    int len = 0;
    boolean isRead = false;
    boolean ok = false;
    boolean firstRead = true;
    int tempOffe;
    int tempLen;

    public AnsjReader(Reader in, int sz) {
        super((Object)in);
        if (sz <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.in = in;
        this.cb = new char[sz];
    }

    public AnsjReader(Reader in) {
        this(in, defaultCharBufferSize);
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        throw new IOException("AnsjBufferedReader not support this interface! ");
    }

    public String readLine() throws IOException {
        this.ensureOpen();
        StringBuilder sb = null;
        this.start = this.tempStart;
        this.firstRead = true;
        while (true) {
            this.tempLen = 0;
            this.ok = false;
            this.readString();
            if (!(this.isRead || this.tempLen != 0 && this.len != 0)) {
                if (sb != null) {
                    return sb.toString();
                }
                return null;
            }
            if (!this.isRead) {
                this.tempStart += this.tempLen;
                if (sb == null) {
                    return new String(this.cb, this.tempOffe, this.tempLen);
                }
                sb.append(this.cb, this.tempOffe, this.tempLen);
                return sb.toString();
            }
            if (this.tempLen == 0) continue;
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(this.cb, this.tempOffe, this.tempLen);
            this.tempStart += this.tempLen;
        }
    }

    private void readString() throws IOException {
        int i;
        if (this.offe <= 0) {
            if (this.offe == -1) {
                this.isRead = false;
                return;
            }
            this.len = this.in.read(this.cb);
            if (this.len <= 0) {
                this.isRead = false;
                return;
            }
        }
        this.isRead = true;
        char c = '\u0000';
        for (i = this.offe; i < this.len && ((c = this.cb[i]) == '\r' || c == '\n'); ++i) {
            if (!this.firstRead) {
                ++this.tempStart;
                this.tempOffe = this.offe = ++i;
                this.isRead = false;
                return;
            }
            ++this.tempStart;
            ++this.start;
        }
        if (i == this.len) {
            this.isRead = true;
            this.offe = 0;
            return;
        }
        this.firstRead = false;
        this.offe = i;
        while (i < this.len) {
            c = this.cb[i];
            if (c == '\n' || c == '\r') {
                this.isRead = false;
                break;
            }
            ++i;
        }
        this.tempOffe = this.offe;
        this.tempLen = i - this.offe;
        if (i == this.len) {
            if (this.len < this.cb.length) {
                this.isRead = false;
                this.offe = -1;
            } else {
                this.offe = 0;
            }
        } else {
            this.offe = i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                return;
            }
            try {
                this.in.close();
            }
            finally {
                this.in = null;
                this.cb = null;
            }
        }
    }

    public int getStart() {
        return this.start;
    }
}

