/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.coprocessor;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.AggregationHelper;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.protobuf.generated.AggregateProtos;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ByteString;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcCallback;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class AggregationClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(AggregationClient.class);
    private final Connection connection;

    public AggregationClient(Configuration cfg) {
        try {
            this.connection = ConnectionFactory.createConnection(cfg);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> R max(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        try (Table table = this.connection.getTable(tableName);){
            R r = this.max(table, ci, scan);
            return r;
        }
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> R max(Table table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = AggregationHelper.validateArgAndGetPB(scan, ci, false);
        class MaxCallBack
        implements Batch.Callback<R> {
            R max = null;

            MaxCallBack() {
            }

            R getMax() {
                return this.max;
            }

            @Override
            public synchronized void update(byte[] region, byte[] row, R result) {
                this.max = this.max == null || result != null && ci.compare(this.max, result) < 0 ? result : this.max;
            }
        }
        MaxCallBack aMaxCallBack = new MaxCallBack();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan.getStartRow(), scan.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, R>(){

            @Override
            public R call(AggregateProtos.AggregateService instance) throws IOException {
                AggregationClientRpcController controller = new AggregationClientRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback<AggregateProtos.AggregateResponse> rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback<AggregateProtos.AggregateResponse>();
                instance.getMax(controller, requestArg, rpcCallback);
                AggregateProtos.AggregateResponse response = rpcCallback.get();
                if (controller.failed()) {
                    throw new IOException(controller.errorText());
                }
                if (response.getFirstPartCount() > 0) {
                    ByteString b = response.getFirstPart(0);
                    Object q = AggregationHelper.getParsedGenericInstance(ci.getClass(), 3, b);
                    return ci.getCellValueFromProto(q);
                }
                return null;
            }
        }, aMaxCallBack);
        return aMaxCallBack.getMax();
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> R min(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        try (Table table = this.connection.getTable(tableName);){
            R r = this.min(table, ci, scan);
            return r;
        }
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> R min(Table table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = AggregationHelper.validateArgAndGetPB(scan, ci, false);
        class MinCallBack
        implements Batch.Callback<R> {
            private R min = null;

            MinCallBack() {
            }

            public R getMinimum() {
                return this.min;
            }

            @Override
            public synchronized void update(byte[] region, byte[] row, R result) {
                this.min = this.min == null || result != null && ci.compare(result, this.min) < 0 ? result : this.min;
            }
        }
        MinCallBack minCallBack = new MinCallBack();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan.getStartRow(), scan.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, R>(){

            @Override
            public R call(AggregateProtos.AggregateService instance) throws IOException {
                AggregationClientRpcController controller = new AggregationClientRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback<AggregateProtos.AggregateResponse> rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback<AggregateProtos.AggregateResponse>();
                instance.getMin(controller, requestArg, rpcCallback);
                AggregateProtos.AggregateResponse response = rpcCallback.get();
                if (controller.failed()) {
                    throw new IOException(controller.errorText());
                }
                if (response.getFirstPartCount() > 0) {
                    ByteString b = response.getFirstPart(0);
                    Object q = AggregationHelper.getParsedGenericInstance(ci.getClass(), 3, b);
                    return ci.getCellValueFromProto(q);
                }
                return null;
            }
        }, minCallBack);
        log.debug("Min fom all regions is: " + minCallBack.getMinimum());
        return minCallBack.getMinimum();
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> long rowCount(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        try (Table table = this.connection.getTable(tableName);){
            long l = this.rowCount(table, ci, scan);
            return l;
        }
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> long rowCount(Table table, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = AggregationHelper.validateArgAndGetPB(scan, ci, true);
        class RowNumCallback
        implements Batch.Callback<Long> {
            private final AtomicLong rowCountL = new AtomicLong(0L);

            RowNumCallback() {
            }

            public long getRowNumCount() {
                return this.rowCountL.get();
            }

            @Override
            public void update(byte[] region, byte[] row, Long result) {
                this.rowCountL.addAndGet(result);
            }
        }
        RowNumCallback rowNum = new RowNumCallback();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan.getStartRow(), scan.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, Long>(){

            @Override
            public Long call(AggregateProtos.AggregateService instance) throws IOException {
                AggregationClientRpcController controller = new AggregationClientRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback<AggregateProtos.AggregateResponse> rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback<AggregateProtos.AggregateResponse>();
                instance.getRowNum(controller, requestArg, rpcCallback);
                AggregateProtos.AggregateResponse response = rpcCallback.get();
                if (controller.failed()) {
                    throw new IOException(controller.errorText());
                }
                byte[] bytes = AggregationClient.this.getBytesFromResponse(response.getFirstPart(0));
                ByteBuffer bb = ByteBuffer.allocate(8).put(bytes);
                bb.rewind();
                return bb.getLong();
            }
        }, rowNum);
        return rowNum.getRowNumCount();
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> S sum(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        try (Table table = this.connection.getTable(tableName);){
            S s = this.sum(table, ci, scan);
            return s;
        }
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> S sum(Table table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = AggregationHelper.validateArgAndGetPB(scan, ci, false);
        class SumCallBack
        implements Batch.Callback<S> {
            S sumVal = null;

            SumCallBack() {
            }

            public S getSumResult() {
                return this.sumVal;
            }

            @Override
            public synchronized void update(byte[] region, byte[] row, S result) {
                this.sumVal = ci.add(this.sumVal, result);
            }
        }
        SumCallBack sumCallBack = new SumCallBack();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan.getStartRow(), scan.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, S>(){

            @Override
            public S call(AggregateProtos.AggregateService instance) throws IOException {
                AggregationClientRpcController controller = new AggregationClientRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback<AggregateProtos.AggregateResponse> rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback<AggregateProtos.AggregateResponse>();
                instance.getSum(controller, requestArg, rpcCallback);
                AggregateProtos.AggregateResponse response = rpcCallback.get();
                if (controller.failed()) {
                    throw new IOException(controller.errorText());
                }
                if (response.getFirstPartCount() == 0) {
                    return null;
                }
                ByteString b = response.getFirstPart(0);
                Object t = AggregationHelper.getParsedGenericInstance(ci.getClass(), 4, b);
                Object s = ci.getPromotedValueFromProto(t);
                return s;
            }
        }, sumCallBack);
        return sumCallBack.getSumResult();
    }

    private <R, S, P extends Message, Q extends Message, T extends Message> Pair<S, Long> getAvgArgs(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        try (Table table = this.connection.getTable(tableName);){
            Pair<S, Long> pair = this.getAvgArgs(table, ci, scan);
            return pair;
        }
    }

    private <R, S, P extends Message, Q extends Message, T extends Message> Pair<S, Long> getAvgArgs(Table table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = AggregationHelper.validateArgAndGetPB(scan, ci, false);
        class AvgCallBack
        implements Batch.Callback<Pair<S, Long>> {
            S sum = null;
            Long rowCount = 0L;

            AvgCallBack() {
            }

            public synchronized Pair<S, Long> getAvgArgs() {
                return new Pair(this.sum, this.rowCount);
            }

            @Override
            public synchronized void update(byte[] region, byte[] row, Pair<S, Long> result) {
                this.sum = ci.add(this.sum, result.getFirst());
                this.rowCount = this.rowCount + result.getSecond();
            }
        }
        AvgCallBack avgCallBack = new AvgCallBack();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan.getStartRow(), scan.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, Pair<S, Long>>(){

            @Override
            public Pair<S, Long> call(AggregateProtos.AggregateService instance) throws IOException {
                AggregationClientRpcController controller = new AggregationClientRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback<AggregateProtos.AggregateResponse> rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback<AggregateProtos.AggregateResponse>();
                instance.getAvg(controller, requestArg, rpcCallback);
                AggregateProtos.AggregateResponse response = rpcCallback.get();
                if (controller.failed()) {
                    throw new IOException(controller.errorText());
                }
                Pair<Object, Long> pair = new Pair<Object, Long>(null, 0L);
                if (response.getFirstPartCount() == 0) {
                    return pair;
                }
                ByteString b = response.getFirstPart(0);
                Object t = AggregationHelper.getParsedGenericInstance(ci.getClass(), 4, b);
                Object s = ci.getPromotedValueFromProto(t);
                pair.setFirst(s);
                ByteBuffer bb = ByteBuffer.allocate(8).put(AggregationClient.this.getBytesFromResponse(response.getSecondPart()));
                bb.rewind();
                pair.setSecond(bb.getLong());
                return pair;
            }
        }, avgCallBack);
        return avgCallBack.getAvgArgs();
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> double avg(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        Pair<S, Long> p = this.getAvgArgs(tableName, ci, scan);
        return ci.divideForAvg(p.getFirst(), p.getSecond());
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> double avg(Table table, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        Pair<S, Long> p = this.getAvgArgs(table, ci, scan);
        return ci.divideForAvg(p.getFirst(), p.getSecond());
    }

    private <R, S, P extends Message, Q extends Message, T extends Message> Pair<List<S>, Long> getStdArgs(Table table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = AggregationHelper.validateArgAndGetPB(scan, ci, false);
        class StdCallback
        implements Batch.Callback<Pair<List<S>, Long>> {
            long rowCountVal = 0L;
            S sumVal = null;
            S sumSqVal = null;

            StdCallback() {
            }

            public synchronized Pair<List<S>, Long> getStdParams() {
                ArrayList l = new ArrayList(2);
                l.add(this.sumVal);
                l.add(this.sumSqVal);
                Pair p = new Pair(l, this.rowCountVal);
                return p;
            }

            @Override
            public synchronized void update(byte[] region, byte[] row, Pair<List<S>, Long> result) {
                if (result.getFirst().size() > 0) {
                    this.sumVal = ci.add(this.sumVal, result.getFirst().get(0));
                    this.sumSqVal = ci.add(this.sumSqVal, result.getFirst().get(1));
                    this.rowCountVal += result.getSecond().longValue();
                }
            }
        }
        StdCallback stdCallback = new StdCallback();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan.getStartRow(), scan.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, Pair<List<S>, Long>>(){

            @Override
            public Pair<List<S>, Long> call(AggregateProtos.AggregateService instance) throws IOException {
                AggregationClientRpcController controller = new AggregationClientRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback<AggregateProtos.AggregateResponse> rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback<AggregateProtos.AggregateResponse>();
                instance.getStd(controller, requestArg, rpcCallback);
                AggregateProtos.AggregateResponse response = rpcCallback.get();
                if (controller.failed()) {
                    throw new IOException(controller.errorText());
                }
                Pair pair = new Pair(new ArrayList(), 0L);
                if (response.getFirstPartCount() == 0) {
                    return pair;
                }
                ArrayList list = new ArrayList();
                for (int i = 0; i < response.getFirstPartCount(); ++i) {
                    ByteString b = response.getFirstPart(i);
                    Object t = AggregationHelper.getParsedGenericInstance(ci.getClass(), 4, b);
                    Object s = ci.getPromotedValueFromProto(t);
                    list.add(s);
                }
                pair.setFirst(list);
                ByteBuffer bb = ByteBuffer.allocate(8).put(AggregationClient.this.getBytesFromResponse(response.getSecondPart()));
                bb.rewind();
                pair.setSecond(bb.getLong());
                return pair;
            }
        }, stdCallback);
        return stdCallback.getStdParams();
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> double std(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        try (Table table = this.connection.getTable(tableName);){
            double d = this.std(table, ci, scan);
            return d;
        }
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> double std(Table table, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        Pair<List<S>, Long> p = this.getStdArgs(table, ci, scan);
        double res = 0.0;
        double avg = ci.divideForAvg(p.getFirst().get(0), p.getSecond());
        double avgOfSumSq = ci.divideForAvg(p.getFirst().get(1), p.getSecond());
        res = avgOfSumSq - avg * avg;
        res = Math.pow(res, 0.5);
        return res;
    }

    private <R, S, P extends Message, Q extends Message, T extends Message> Pair<NavigableMap<byte[], List<S>>, List<S>> getMedianArgs(Table table, final ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        final AggregateProtos.AggregateRequest requestArg = AggregationHelper.validateArgAndGetPB(scan, ci, false);
        final TreeMap map = new TreeMap(Bytes.BYTES_COMPARATOR);
        class StdCallback
        implements Batch.Callback<List<S>> {
            S sumVal = null;
            S sumWeights = null;

            StdCallback() {
            }

            public synchronized Pair<NavigableMap<byte[], List<S>>, List<S>> getMedianParams() {
                ArrayList l = new ArrayList(2);
                l.add(this.sumVal);
                l.add(this.sumWeights);
                Pair p = new Pair(map, l);
                return p;
            }

            @Override
            public synchronized void update(byte[] region, byte[] row, List<S> result) {
                map.put(row, result);
                this.sumVal = ci.add(this.sumVal, result.get(0));
                this.sumWeights = ci.add(this.sumWeights, result.get(1));
            }
        }
        StdCallback stdCallback = new StdCallback();
        table.coprocessorService(AggregateProtos.AggregateService.class, scan.getStartRow(), scan.getStopRow(), new Batch.Call<AggregateProtos.AggregateService, List<S>>(){

            @Override
            public List<S> call(AggregateProtos.AggregateService instance) throws IOException {
                AggregationClientRpcController controller = new AggregationClientRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback<AggregateProtos.AggregateResponse> rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback<AggregateProtos.AggregateResponse>();
                instance.getMedian(controller, requestArg, rpcCallback);
                AggregateProtos.AggregateResponse response = rpcCallback.get();
                if (controller.failed()) {
                    throw new IOException(controller.errorText());
                }
                ArrayList list = new ArrayList();
                for (int i = 0; i < response.getFirstPartCount(); ++i) {
                    ByteString b = response.getFirstPart(i);
                    Object t = AggregationHelper.getParsedGenericInstance(ci.getClass(), 4, b);
                    Object s = ci.getPromotedValueFromProto(t);
                    list.add(s);
                }
                return list;
            }
        }, stdCallback);
        return stdCallback.getMedianParams();
    }

    public <R, S, P extends Message, Q extends Message, T extends Message> R median(TableName tableName, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        try (Table table = this.connection.getTable(tableName);){
            R r = this.median(table, ci, scan);
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, S, P extends Message, Q extends Message, T extends Message> R median(Table table, ColumnInterpreter<R, S, P, Q, T> ci, Scan scan) throws Throwable {
        Pair<NavigableMap<byte[], List<S>>, List<S>> p = this.getMedianArgs(table, ci, scan);
        byte[] startRow = null;
        byte[] colFamily = scan.getFamilies()[0];
        NavigableSet<byte[]> quals = scan.getFamilyMap().get(colFamily);
        NavigableMap<byte[], List<S>> map = p.getFirst();
        S sumVal = p.getSecond().get(0);
        S sumWeights = p.getSecond().get(1);
        double halfSumVal = ci.divideForAvg(sumVal, 2L);
        double movingSumVal = 0.0;
        boolean weighted = false;
        if (quals.size() > 1) {
            weighted = true;
            halfSumVal = ci.divideForAvg(sumWeights, 2L);
        }
        for (Map.Entry entry : map.entrySet()) {
            Object s = weighted ? ((List)entry.getValue()).get(1) : ((List)entry.getValue()).get(0);
            double newSumVal = movingSumVal + ci.divideForAvg(s, 1L);
            if (newSumVal > halfSumVal) break;
            movingSumVal = newSumVal;
            startRow = (byte[])entry.getKey();
        }
        Scan scan2 = new Scan(scan);
        if (startRow != null) {
            scan2.setStartRow(startRow);
        }
        try (ResultScanner scanner = null;){
            int cacheSize = scan2.getCaching();
            if (!scan2.getCacheBlocks() || scan2.getCaching() < 2) {
                scan2.setCacheBlocks(true);
                cacheSize = 5;
                scan2.setCaching(cacheSize);
            }
            scanner = table.getScanner(scan2);
            Result[] results = null;
            byte[] qualifier = quals.pollFirst();
            byte[] weightQualifier = weighted ? quals.pollLast() : qualifier;
            R value = null;
            do {
                if ((results = scanner.next(cacheSize)) == null || results.length <= 0) continue;
                for (int i = 0; i < results.length; ++i) {
                    Result r = results[i];
                    Cell kv = r.getColumnLatestCell(colFamily, weightQualifier);
                    R newValue = ci.getValue(colFamily, weightQualifier, kv);
                    S s = ci.castToReturnType(newValue);
                    double newSumVal = movingSumVal + ci.divideForAvg(s, 1L);
                    if (newSumVal > halfSumVal) {
                        R r2 = value;
                        return r2;
                    }
                    movingSumVal = newSumVal;
                    kv = r.getColumnLatestCell(colFamily, qualifier);
                    value = ci.getValue(colFamily, qualifier, kv);
                }
            } while (results != null && results.length > 0);
        }
        return null;
    }

    byte[] getBytesFromResponse(ByteString response) {
        ByteBuffer bb = response.asReadOnlyByteBuffer();
        bb.rewind();
        byte[] bytes = bb.hasArray() ? bb.array() : response.toByteArray();
        return bytes;
    }

    static class AggregationClientRpcController
    implements RpcController {
        private String errorText;
        private boolean cancelled = false;
        private boolean failed = false;

        AggregationClientRpcController() {
        }

        @Override
        public String errorText() {
            return this.errorText;
        }

        @Override
        public boolean failed() {
            return this.failed;
        }

        @Override
        public boolean isCanceled() {
            return this.cancelled;
        }

        @Override
        public void notifyOnCancel(RpcCallback<Object> arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.errorText = null;
            this.cancelled = false;
            this.failed = false;
        }

        @Override
        public void setFailed(String errorText) {
            this.failed = true;
            this.errorText = errorText;
        }

        @Override
        public void startCancel() {
            this.cancelled = true;
        }
    }
}

