/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class MultiRowRangeFilter
extends FilterBase {
    private static final int ROW_BEFORE_FIRST_RANGE = -1;
    private final List<RowRange> rangeList;
    private final RangeIteration ranges;
    private boolean done = false;
    private int index;
    private BasicRowRange range;
    private Filter.ReturnCode currentReturnCode;

    public MultiRowRangeFilter(List<RowRange> list) {
        this.rangeList = Collections.unmodifiableList(MultiRowRangeFilter.sortAndMerge(list));
        this.ranges = new RangeIteration(this.rangeList);
    }

    public List<RowRange> getRowRanges() {
        return this.rangeList;
    }

    @Override
    public boolean filterAllRemaining() {
        return this.done;
    }

    @Override
    public boolean filterRowKey(Cell firstRowCell) {
        if (this.filterAllRemaining()) {
            return true;
        }
        if (!this.ranges.isInitialized()) {
            this.ranges.initialize(this.isReversed());
        }
        byte[] rowArr = firstRowCell.getRowArray();
        short length = firstRowCell.getRowLength();
        int offset = firstRowCell.getRowOffset();
        if (!this.ranges.hasFoundFirstRange() || !this.range.contains(rowArr, offset, length)) {
            byte[] rowkey = CellUtil.cloneRow(firstRowCell);
            this.index = this.ranges.getNextRangeIndex(rowkey);
            if (this.ranges.isIterationComplete(this.index)) {
                this.done = true;
                this.currentReturnCode = Filter.ReturnCode.NEXT_ROW;
                return false;
            }
            this.range = this.index != -1 ? this.ranges.get(this.index) : this.ranges.get(0);
            if (this.ranges.isExclusive()) {
                this.ranges.resetExclusive();
                this.currentReturnCode = Filter.ReturnCode.NEXT_ROW;
                return false;
            }
            if (!this.ranges.hasFoundFirstRange()) {
                this.currentReturnCode = this.index != -1 ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.SEEK_NEXT_USING_HINT;
                this.ranges.setFoundFirstRange();
            } else {
                this.currentReturnCode = this.range.contains(rowArr, offset, length) ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.SEEK_NEXT_USING_HINT;
            }
        } else {
            this.currentReturnCode = Filter.ReturnCode.INCLUDE;
        }
        return false;
    }

    @Override
    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell ignored) {
        return this.filterCell(ignored);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell ignored) {
        return this.currentReturnCode;
    }

    @Override
    public Cell getNextCellHint(Cell currentKV) {
        byte[] comparisonData = this.range.getComparisonData();
        return PrivateCellUtil.createFirstOnRow(comparisonData, 0, (short)comparisonData.length);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.MultiRowRangeFilter.Builder builder = FilterProtos.MultiRowRangeFilter.newBuilder();
        for (RowRange range : this.rangeList) {
            if (range == null) continue;
            FilterProtos.RowRange.Builder rangebuilder = FilterProtos.RowRange.newBuilder();
            if (range.startRow != null) {
                rangebuilder.setStartRow(UnsafeByteOperations.unsafeWrap(range.startRow));
            }
            rangebuilder.setStartRowInclusive(range.startRowInclusive);
            if (range.stopRow != null) {
                rangebuilder.setStopRow(UnsafeByteOperations.unsafeWrap(range.stopRow));
            }
            rangebuilder.setStopRowInclusive(range.stopRowInclusive);
            builder.addRowRangeList(rangebuilder.build());
        }
        return builder.build().toByteArray();
    }

    public static MultiRowRangeFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.MultiRowRangeFilter proto;
        try {
            proto = FilterProtos.MultiRowRangeFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        int length = proto.getRowRangeListCount();
        List<FilterProtos.RowRange> rangeProtos = proto.getRowRangeListList();
        ArrayList<RowRange> rangeList = new ArrayList<RowRange>(length);
        for (FilterProtos.RowRange rangeProto : rangeProtos) {
            RowRange range = new RowRange(rangeProto.hasStartRow() ? rangeProto.getStartRow().toByteArray() : null, rangeProto.getStartRowInclusive(), rangeProto.hasStopRow() ? rangeProto.getStopRow().toByteArray() : null, rangeProto.getStopRowInclusive());
            rangeList.add(range);
        }
        return new MultiRowRangeFilter(rangeList);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiRowRangeFilter)) {
            return false;
        }
        MultiRowRangeFilter other = (MultiRowRangeFilter)o;
        if (this.rangeList.size() != other.rangeList.size()) {
            return false;
        }
        for (int i = 0; i < this.rangeList.size(); ++i) {
            RowRange thisRange = this.rangeList.get(i);
            RowRange otherRange = other.rangeList.get(i);
            if (Bytes.equals(thisRange.startRow, otherRange.startRow) && Bytes.equals(thisRange.stopRow, otherRange.stopRow) && thisRange.startRowInclusive == otherRange.startRowInclusive && thisRange.stopRowInclusive == otherRange.stopRowInclusive) continue;
            return false;
        }
        return true;
    }

    public static List<RowRange> sortAndMerge(List<RowRange> ranges) {
        if (ranges.isEmpty()) {
            throw new IllegalArgumentException("No ranges found.");
        }
        ArrayList<RowRange> invalidRanges = new ArrayList<RowRange>();
        ArrayList<RowRange> newRanges = new ArrayList<RowRange>(ranges.size());
        Collections.sort(ranges);
        if (ranges.get(0).isValid()) {
            if (ranges.size() == 1) {
                newRanges.add(ranges.get(0));
            }
        } else {
            invalidRanges.add(ranges.get(0));
        }
        byte[] lastStartRow = ranges.get((int)0).startRow;
        boolean lastStartRowInclusive = ranges.get((int)0).startRowInclusive;
        byte[] lastStopRow = ranges.get((int)0).stopRow;
        boolean lastStopRowInclusive = ranges.get((int)0).stopRowInclusive;
        for (int i = 1; i < ranges.size(); ++i) {
            RowRange range = ranges.get(i);
            if (!range.isValid()) {
                invalidRanges.add(range);
            }
            if (Bytes.equals(lastStopRow, HConstants.EMPTY_BYTE_ARRAY)) {
                newRanges.add(new RowRange(lastStartRow, lastStartRowInclusive, lastStopRow, lastStopRowInclusive));
                break;
            }
            if (Bytes.compareTo(lastStopRow, range.startRow) > 0 || Bytes.compareTo(lastStopRow, range.startRow) == 0 && (lastStopRowInclusive || range.isStartRowInclusive())) {
                if (Bytes.equals(range.stopRow, HConstants.EMPTY_BYTE_ARRAY)) {
                    newRanges.add(new RowRange(lastStartRow, lastStartRowInclusive, range.stopRow, range.stopRowInclusive));
                    break;
                }
                if (Bytes.compareTo(lastStopRow, range.stopRow) >= 0) {
                    if (Bytes.compareTo(lastStopRow, range.stopRow) == 0 && (lastStopRowInclusive || range.stopRowInclusive)) {
                        lastStopRowInclusive = true;
                    }
                    if (i + 1 != ranges.size()) continue;
                    newRanges.add(new RowRange(lastStartRow, lastStartRowInclusive, lastStopRow, lastStopRowInclusive));
                    continue;
                }
                lastStopRow = range.stopRow;
                lastStopRowInclusive = range.stopRowInclusive;
                if (i + 1 < ranges.size()) {
                    if (!(range = ranges.get(++i)).isValid()) {
                        invalidRanges.add(range);
                    }
                } else {
                    newRanges.add(new RowRange(lastStartRow, lastStartRowInclusive, lastStopRow, lastStopRowInclusive));
                    break;
                }
                while ((Bytes.compareTo(lastStopRow, range.startRow) > 0 || Bytes.compareTo(lastStopRow, range.startRow) == 0 && (lastStopRowInclusive || range.startRowInclusive)) && !Bytes.equals(range.stopRow, HConstants.EMPTY_BYTE_ARRAY)) {
                    if (Bytes.compareTo(lastStopRow, range.stopRow) >= 0) {
                        if (lastStopRowInclusive || range.stopRowInclusive) {
                            lastStopRowInclusive = true;
                        }
                        if (++i >= ranges.size()) break;
                        range = ranges.get(i);
                        if (range.isValid()) continue;
                        invalidRanges.add(range);
                        continue;
                    }
                    lastStopRow = range.stopRow;
                    lastStopRowInclusive = range.stopRowInclusive;
                    if (++i >= ranges.size()) break;
                    range = ranges.get(i);
                    if (range.isValid()) continue;
                    invalidRanges.add(range);
                }
                if (Bytes.equals(range.stopRow, HConstants.EMPTY_BYTE_ARRAY)) {
                    if (Bytes.compareTo(lastStopRow, range.startRow) < 0 || Bytes.compareTo(lastStopRow, range.startRow) == 0 && !lastStopRowInclusive && !range.startRowInclusive) {
                        newRanges.add(new RowRange(lastStartRow, lastStartRowInclusive, lastStopRow, lastStopRowInclusive));
                        newRanges.add(range);
                    } else {
                        newRanges.add(new RowRange(lastStartRow, lastStartRowInclusive, range.stopRow, range.stopRowInclusive));
                        break;
                    }
                }
                newRanges.add(new RowRange(lastStartRow, lastStartRowInclusive, lastStopRow, lastStopRowInclusive));
                if (i + 1 == ranges.size()) {
                    newRanges.add(range);
                }
                lastStartRow = range.startRow;
                lastStartRowInclusive = range.startRowInclusive;
                lastStopRow = range.stopRow;
                lastStopRowInclusive = range.stopRowInclusive;
                continue;
            }
            newRanges.add(new RowRange(lastStartRow, lastStartRowInclusive, lastStopRow, lastStopRowInclusive));
            if (i + 1 == ranges.size()) {
                newRanges.add(range);
            }
            lastStartRow = range.startRow;
            lastStartRowInclusive = range.startRowInclusive;
            lastStopRow = range.stopRow;
            lastStopRowInclusive = range.stopRowInclusive;
        }
        for (int j = i; j < ranges.size(); ++j) {
            if (ranges.get(j).isValid()) continue;
            invalidRanges.add(ranges.get(j));
        }
        if (invalidRanges.size() != 0) {
            MultiRowRangeFilter.throwExceptionForInvalidRanges(invalidRanges, true);
        }
        if (newRanges.isEmpty()) {
            throw new IllegalArgumentException("No valid ranges found.");
        }
        return newRanges;
    }

    private static void throwExceptionForInvalidRanges(List<RowRange> invalidRanges, boolean details) {
        StringBuilder sb = new StringBuilder();
        sb.append(invalidRanges.size()).append(" invaild ranges.\n");
        if (details) {
            for (RowRange range : invalidRanges) {
                sb.append("Invalid range: start row => " + Bytes.toString(range.startRow) + ", stop row => " + Bytes.toString(range.stopRow)).append('\n');
            }
        }
        throw new IllegalArgumentException(sb.toString());
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    public int hashCode() {
        return Objects.hash(this.ranges);
    }

    @InterfaceAudience.Private
    private static class RangeIteration {
        private boolean exclusive = false;
        private boolean initialized = false;
        private boolean foundFirstRange = false;
        private boolean reversed = false;
        private final List<RowRange> sortedAndMergedRanges;
        private List<? extends BasicRowRange> ranges;

        public RangeIteration(List<RowRange> sortedAndMergedRanges) {
            this.sortedAndMergedRanges = sortedAndMergedRanges;
        }

        void initialize(boolean reversed) {
            assert (!this.initialized);
            this.reversed = reversed;
            this.ranges = reversed ? RangeIteration.flipAndReverseRanges(this.sortedAndMergedRanges) : this.sortedAndMergedRanges;
            this.initialized = true;
        }

        static List<ReversedRowRange> flipAndReverseRanges(List<RowRange> ranges) {
            ArrayList<ReversedRowRange> flippedRanges = new ArrayList<ReversedRowRange>(ranges.size());
            for (int i = ranges.size() - 1; i >= 0; --i) {
                RowRange origRange = ranges.get(i);
                ReversedRowRange newRowRange = new ReversedRowRange(origRange.startRow, origRange.startRowInclusive, origRange.stopRow, origRange.isStopRowInclusive());
                flippedRanges.add(newRowRange);
            }
            return flippedRanges;
        }

        public int getNextRangeIndex(byte[] rowKey) {
            BasicRowRange temp = this.reversed ? new ReversedRowRange(null, true, rowKey, true) : new RowRange(rowKey, true, null, true);
            int index = Collections.binarySearch(this.ranges, temp);
            if (index < 0) {
                int insertionPosition = -index - 1;
                if (insertionPosition != 0 && this.ranges.get(insertionPosition - 1).contains(rowKey)) {
                    return insertionPosition - 1;
                }
                if (insertionPosition == 0 && !this.ranges.get(insertionPosition).contains(rowKey)) {
                    return -1;
                }
                if (!this.foundFirstRange) {
                    this.foundFirstRange = true;
                }
                return insertionPosition;
            }
            if (!this.ranges.get(index).isSearchRowInclusive()) {
                this.exclusive = true;
            }
            return index;
        }

        public void setFoundFirstRange() {
            this.foundFirstRange = true;
        }

        public <T extends BasicRowRange> T get(int i) {
            return (T)this.ranges.get(i);
        }

        public boolean hasFoundFirstRange() {
            return this.foundFirstRange;
        }

        public boolean isExclusive() {
            return this.exclusive;
        }

        public void resetExclusive() {
            this.exclusive = false;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public boolean isIterationComplete(int index) {
            return index >= this.ranges.size();
        }
    }

    @InterfaceAudience.Public
    public static class RowRange
    extends BasicRowRange {
        public RowRange() {
        }

        public RowRange(String startRow, boolean startRowInclusive, String stopRow, boolean stopRowInclusive) {
            super(startRow, startRowInclusive, stopRow, stopRowInclusive);
        }

        public RowRange(byte[] startRow, boolean startRowInclusive, byte[] stopRow, boolean stopRowInclusive) {
            super(startRow, startRowInclusive, stopRow, stopRowInclusive);
        }

        @Override
        public byte[] getComparisonData() {
            return this.startRow;
        }

        @Override
        public boolean isSearchRowInclusive() {
            return this.startRowInclusive;
        }

        @Override
        public boolean isAscendingOrder() {
            return true;
        }
    }

    @InterfaceAudience.Private
    private static class ReversedRowRange
    extends BasicRowRange {
        public ReversedRowRange(byte[] startRow, boolean startRowInclusive, byte[] stopRow, boolean stopRowInclusive) {
            super(startRow, startRowInclusive, stopRow, stopRowInclusive);
        }

        @Override
        public byte[] getComparisonData() {
            return this.stopRow;
        }

        @Override
        public boolean isSearchRowInclusive() {
            return this.stopRowInclusive;
        }

        @Override
        public boolean isAscendingOrder() {
            return false;
        }
    }

    private static abstract class BasicRowRange
    implements Comparable<BasicRowRange> {
        protected byte[] startRow;
        protected boolean startRowInclusive = true;
        protected byte[] stopRow;
        protected boolean stopRowInclusive = false;

        public BasicRowRange() {
        }

        public BasicRowRange(String startRow, boolean startRowInclusive, String stopRow, boolean stopRowInclusive) {
            this(startRow == null || startRow.isEmpty() ? HConstants.EMPTY_BYTE_ARRAY : Bytes.toBytes(startRow), startRowInclusive, stopRow == null || stopRow.isEmpty() ? HConstants.EMPTY_BYTE_ARRAY : Bytes.toBytes(stopRow), stopRowInclusive);
        }

        public BasicRowRange(byte[] startRow, boolean startRowInclusive, byte[] stopRow, boolean stopRowInclusive) {
            this.startRow = startRow == null ? HConstants.EMPTY_BYTE_ARRAY : startRow;
            this.startRowInclusive = startRowInclusive;
            this.stopRow = stopRow == null ? HConstants.EMPTY_BYTE_ARRAY : stopRow;
            this.stopRowInclusive = stopRowInclusive;
        }

        public byte[] getStartRow() {
            return this.startRow;
        }

        public byte[] getStopRow() {
            return this.stopRow;
        }

        public boolean isStartRowInclusive() {
            return this.startRowInclusive;
        }

        public boolean isStopRowInclusive() {
            return this.stopRowInclusive;
        }

        public boolean contains(byte[] row) {
            return this.contains(row, 0, row.length);
        }

        public boolean contains(byte[] buffer, int offset, int length) {
            if (this.startRowInclusive) {
                if (this.stopRowInclusive) {
                    return Bytes.compareTo(buffer, offset, length, this.startRow, 0, this.startRow.length) >= 0 && (Bytes.equals(this.stopRow, HConstants.EMPTY_BYTE_ARRAY) || Bytes.compareTo(buffer, offset, length, this.stopRow, 0, this.stopRow.length) <= 0);
                }
                return Bytes.compareTo(buffer, offset, length, this.startRow, 0, this.startRow.length) >= 0 && (Bytes.equals(this.stopRow, HConstants.EMPTY_BYTE_ARRAY) || Bytes.compareTo(buffer, offset, length, this.stopRow, 0, this.stopRow.length) < 0);
            }
            if (this.stopRowInclusive) {
                return Bytes.compareTo(buffer, offset, length, this.startRow, 0, this.startRow.length) > 0 && (Bytes.equals(this.stopRow, HConstants.EMPTY_BYTE_ARRAY) || Bytes.compareTo(buffer, offset, length, this.stopRow, 0, this.stopRow.length) <= 0);
            }
            return Bytes.compareTo(buffer, offset, length, this.startRow, 0, this.startRow.length) > 0 && (Bytes.equals(this.stopRow, HConstants.EMPTY_BYTE_ARRAY) || Bytes.compareTo(buffer, offset, length, this.stopRow, 0, this.stopRow.length) < 0);
        }

        public boolean isValid() {
            return Bytes.equals(this.startRow, HConstants.EMPTY_BYTE_ARRAY) || Bytes.equals(this.stopRow, HConstants.EMPTY_BYTE_ARRAY) || Bytes.compareTo(this.startRow, this.stopRow) < 0 || Bytes.compareTo(this.startRow, this.stopRow) == 0 && this.stopRowInclusive;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BasicRowRange)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            BasicRowRange rr = (BasicRowRange)obj;
            return Bytes.equals(this.stopRow, rr.getStopRow()) && Bytes.equals(this.startRow, this.getStartRow()) && this.startRowInclusive == rr.isStartRowInclusive() && this.stopRowInclusive == rr.isStopRowInclusive();
        }

        public int hashCode() {
            return Objects.hash(Bytes.hashCode(this.stopRow), Bytes.hashCode(this.startRow), this.startRowInclusive, this.stopRowInclusive);
        }

        public abstract byte[] getComparisonData();

        public abstract boolean isSearchRowInclusive();

        @Override
        public int compareTo(BasicRowRange other) {
            byte[] right;
            byte[] left;
            if (this.isAscendingOrder()) {
                left = this.getComparisonData();
                right = other.getComparisonData();
            } else {
                left = other.getComparisonData();
                right = this.getComparisonData();
            }
            return Bytes.compareTo(left, right);
        }

        public abstract boolean isAscendingOrder();
    }
}

