/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.jets3t.service.model.cloudfront;

import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.cloudfront.Origin;

public class CustomOrigin
extends Origin {
    private OriginProtocolPolicy originProtocolPolicy = null;
    private int httpPort = 80;
    private int httpsPort = 443;

    public CustomOrigin(String dnsName, OriginProtocolPolicy originProtocolPolicy) {
        super(dnsName);
        this.originProtocolPolicy = originProtocolPolicy;
    }

    public CustomOrigin(String dnsName, OriginProtocolPolicy originProtocolPolicy, int httpPort, int httpsPort) {
        super(dnsName);
        this.originProtocolPolicy = originProtocolPolicy;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
    }

    public OriginProtocolPolicy getOriginProtocolPolicy() {
        return this.originProtocolPolicy;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public String toString() {
        return "CustomOrigin: dnsName=" + this.getDnsName() + ", originProtocolPolicy=" + (Object)((Object)this.getOriginProtocolPolicy()) + ", httpPort=" + this.getHttpPort() + ", httpsPort=" + this.getHttpsPort();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OriginProtocolPolicy {
        HTTP_ONLY("http-only"),
        MATCH_VIEWER("match-viewer");

        private final String textValue;

        private OriginProtocolPolicy(String textValue) {
            this.textValue = textValue;
        }

        public String toText() {
            return this.textValue;
        }

        public static OriginProtocolPolicy fromText(String text) {
            for (OriginProtocolPolicy e : OriginProtocolPolicy.values()) {
                if (!e.toText().equalsIgnoreCase(text)) continue;
                return e;
            }
            throw new IllegalArgumentException("Invalid OriginProtocolPolicy: " + text);
        }
    }
}

