/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.jets3t.service.security;

import java.io.IOException;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.security.OAuth2Tokens;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.security.ProviderCredentials;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.utils.oauth.OAuthScope;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.utils.oauth.OAuthUtils;

public class OAuth2Credentials
extends ProviderCredentials {
    private OAuth2Tokens oauth2Tokens;
    private OAuthUtils oauthUtils;

    public OAuth2Credentials(String clientId, String clientSecret) {
        this(clientId, clientSecret, null);
    }

    public OAuth2Credentials(String clientId, String clientSecret, String friendlyName) {
        this(clientId, clientSecret, friendlyName, null);
    }

    public OAuth2Credentials(String clientId, String clientSecret, String friendlyName, String refreshToken) {
        this(new OAuthUtils(OAuthUtils.OAuthImplementation.GOOGLE_STORAGE_OAUTH2_10, clientId, clientSecret), friendlyName, refreshToken);
    }

    public OAuth2Credentials(OAuthUtils oauth, String friendlyName) {
        this(oauth, friendlyName, null);
    }

    public OAuth2Credentials(OAuthUtils oauth, String friendlyName, String refreshToken) {
        super(oauth.getClientId(), oauth.getClientSecret(), friendlyName);
        this.oauthUtils = oauth;
        this.oauth2Tokens = refreshToken == null ? null : new OAuth2Tokens(null, refreshToken);
    }

    public void setOAuth2Tokens(OAuth2Tokens tokens) {
        this.oauth2Tokens = tokens;
    }

    public OAuth2Tokens getOAuth2Tokens() throws IOException {
        if (null == this.oauth2Tokens) {
            return null;
        }
        if (this.oauth2Tokens.isAccessTokenExpired()) {
            this.oauth2Tokens = this.refreshOAuth2Tokens();
        }
        return this.oauth2Tokens;
    }

    private OAuth2Tokens refreshOAuth2Tokens() throws IOException {
        log.debug((Object)("Refreshing OAuth2 access token using refresh token: " + this.oauth2Tokens.getRefreshToken()));
        OAuth2Tokens newTokens = this.oauthUtils.refreshOAuth2AccessToken(this.oauth2Tokens);
        this.setOAuth2Tokens(newTokens);
        log.debug((Object)("Refreshed OAuth2 access token to " + newTokens.getAccessToken() + " with expiry at " + newTokens.getExpiry()));
        return newTokens;
    }

    public String generateBrowserUrlToAuthorizeNativeApplication(OAuthScope scope) {
        return this.oauthUtils.generateBrowserUrlToAuthorizeNativeApplication(scope);
    }

    public void retrieveOAuth2TokensFromAuthorization(String authorizationCode) throws IOException {
        this.oauth2Tokens = this.oauthUtils.retrieveOAuth2TokensFromAuthorization(authorizationCode);
    }

    public String getClientId() {
        return this.getAccessKey();
    }

    public String getClientSecret() {
        return this.getSecretKey();
    }

    protected String getTypeName() {
        return "OAuth2Client";
    }

    public String getVersionPrefix() {
        return "jets3t OAuth2 Client Credentials, version: ";
    }
}

