/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionNormalizerProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionNormalizerTracker
extends ZKNodeTracker {
    private static final Logger LOG = LoggerFactory.getLogger(RegionNormalizerTracker.class);

    public RegionNormalizerTracker(ZKWatcher watcher, Abortable abortable) {
        super(watcher, watcher.znodePaths.regionNormalizerZNode, abortable);
    }

    public boolean isNormalizerOn() {
        byte[] upData = super.getData(false);
        try {
            return upData == null || this.parseFrom(upData).getNormalizerOn();
        }
        catch (DeserializationException dex) {
            LOG.error("ZK state for RegionNormalizer could not be parsed " + Bytes.toStringBinary(upData));
            return false;
        }
    }

    public void setNormalizerOn(boolean normalizerOn) throws KeeperException {
        byte[] upData = this.toByteArray(normalizerOn);
        try {
            ZKUtil.setData(this.watcher, this.watcher.znodePaths.regionNormalizerZNode, upData);
        }
        catch (KeeperException.NoNodeException nne) {
            ZKUtil.createAndWatch(this.watcher, this.watcher.znodePaths.regionNormalizerZNode, upData);
        }
        super.nodeDataChanged(this.watcher.znodePaths.regionNormalizerZNode);
    }

    private byte[] toByteArray(boolean isNormalizerOn) {
        RegionNormalizerProtos.RegionNormalizerState.Builder builder = RegionNormalizerProtos.RegionNormalizerState.newBuilder();
        builder.setNormalizerOn(isNormalizerOn);
        return ProtobufUtil.prependPBMagic(builder.build().toByteArray());
    }

    private RegionNormalizerProtos.RegionNormalizerState parseFrom(byte[] pbBytes) throws DeserializationException {
        ProtobufUtil.expectPBMagicPrefix(pbBytes);
        RegionNormalizerProtos.RegionNormalizerState.Builder builder = RegionNormalizerProtos.RegionNormalizerState.newBuilder();
        try {
            int magicLen = ProtobufUtil.lengthOfPBMagic();
            ProtobufUtil.mergeFrom(builder, pbBytes, magicLen, pbBytes.length - magicLen);
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
        return builder.build();
    }
}

