/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.auth;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.List;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.auth.UserAPI;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.auth.HugeAccess;
import org.apache.hugegraph.auth.HugePermission;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.define.Checkable;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/auth/accesses")
@Singleton
@Tag(name="AccessAPI")
public class AccessAPI
extends API {
    private static final Logger LOG = Log.logger(AccessAPI.class);

    @POST
    @Timed
    @StatusFilter.Status(value=201)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String create(@Context GraphManager manager, @PathParam(value="graph") String graph, JsonAccess jsonAccess) {
        LOG.debug("Graph [{}] create access: {}", (Object)graph, (Object)jsonAccess);
        AccessAPI.checkCreatingBody(jsonAccess);
        HugeGraph g = AccessAPI.graph(manager, graph);
        HugeAccess access = jsonAccess.build();
        access.id(manager.authManager().createAccess(access));
        return manager.serializer((Graph)g).writeAuthElement((SchemaDefine.AuthElement)access);
    }

    @PUT
    @Timed
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String update(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="id") String id, JsonAccess jsonAccess) {
        HugeAccess access;
        LOG.debug("Graph [{}] update access: {}", (Object)graph, (Object)jsonAccess);
        AccessAPI.checkUpdatingBody(jsonAccess);
        HugeGraph g = AccessAPI.graph(manager, graph);
        try {
            access = manager.authManager().getAccess(UserAPI.parseId(id));
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Invalid access id: " + id);
        }
        access = jsonAccess.build(access);
        manager.authManager().updateAccess(access);
        return manager.serializer((Graph)g).writeAuthElement((SchemaDefine.AuthElement)access);
    }

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String list(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="group") String group, @QueryParam(value="target") String target, @QueryParam(value="limit") @DefaultValue(value="100") long limit) {
        List belongs;
        LOG.debug("Graph [{}] list belongs by group {} or target {}", new Object[]{graph, group, target});
        E.checkArgument((group == null || target == null ? 1 : 0) != 0, (String)"Can't pass both group and target at the same time", (Object[])new Object[0]);
        HugeGraph g = AccessAPI.graph(manager, graph);
        if (group != null) {
            Id id = UserAPI.parseId(group);
            belongs = manager.authManager().listAccessByGroup(id, limit);
        } else if (target != null) {
            Id id = UserAPI.parseId(target);
            belongs = manager.authManager().listAccessByTarget(id, limit);
        } else {
            belongs = manager.authManager().listAllAccess(limit);
        }
        return manager.serializer((Graph)g).writeAuthElements("accesses", belongs);
    }

    @GET
    @Timed
    @Path(value="{id}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="id") String id) {
        LOG.debug("Graph [{}] get access: {}", (Object)graph, (Object)id);
        HugeGraph g = AccessAPI.graph(manager, graph);
        HugeAccess access = manager.authManager().getAccess(UserAPI.parseId(id));
        return manager.serializer((Graph)g).writeAuthElement((SchemaDefine.AuthElement)access);
    }

    @DELETE
    @Timed
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    public void delete(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="id") String id) {
        LOG.debug("Graph [{}] delete access: {}", (Object)graph, (Object)id);
        HugeGraph g = AccessAPI.graph(manager, graph);
        try {
            manager.authManager().deleteAccess(UserAPI.parseId(id));
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Invalid access id: " + id);
        }
    }

    @JsonIgnoreProperties(value={"id", "access_creator", "access_create", "access_update"})
    private static class JsonAccess
    implements Checkable {
        @JsonProperty(value="group")
        private String group;
        @JsonProperty(value="target")
        private String target;
        @JsonProperty(value="access_permission")
        private HugePermission permission;
        @JsonProperty(value="access_description")
        private String description;

        private JsonAccess() {
        }

        public HugeAccess build(HugeAccess access) {
            E.checkArgument((this.group == null || access.source().equals(UserAPI.parseId(this.group)) ? 1 : 0) != 0, (String)"The group of access can't be updated", (Object[])new Object[0]);
            E.checkArgument((this.target == null || access.target().equals(UserAPI.parseId(this.target)) ? 1 : 0) != 0, (String)"The target of access can't be updated", (Object[])new Object[0]);
            E.checkArgument((this.permission == null || access.permission().equals((Object)this.permission) ? 1 : 0) != 0, (String)"The permission of access can't be updated", (Object[])new Object[0]);
            if (this.description != null) {
                access.description(this.description);
            }
            return access;
        }

        public HugeAccess build() {
            HugeAccess access = new HugeAccess(UserAPI.parseId(this.group), UserAPI.parseId(this.target));
            access.permission(this.permission);
            access.description(this.description);
            return access;
        }

        @Override
        public void checkCreate(boolean isBatch) {
            E.checkArgumentNotNull((Object)this.group, (String)"The group of access can't be null", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)this.target, (String)"The target of access can't be null", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)this.permission, (String)"The permission of access can't be null", (Object[])new Object[0]);
        }

        @Override
        public void checkUpdate() {
            E.checkArgumentNotNull((Object)this.description, (String)"The description of access can't be null", (Object[])new Object[0]);
        }
    }
}

