/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.graph;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.filter.CompressInterceptor;
import org.apache.hugegraph.api.filter.DecompressInterceptor;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.api.graph.BatchAPI;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.SplicingIdGenerator;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.define.UpdateStrategy;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.optimize.Text;
import org.apache.hugegraph.traversal.optimize.TraversalUtil;
import org.apache.hugegraph.type.define.IdStrategy;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/graph/vertices")
@Singleton
@Tag(name="VertexAPI")
public class VertexAPI
extends BatchAPI {
    private static final Logger LOG = Log.logger(VertexAPI.class);

    @POST
    @Timed(name="single-create")
    @StatusFilter.Status(value=201)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=vertex_write"})
    public String create(@Context GraphManager manager, @PathParam(value="graph") String graph, JsonVertex jsonVertex) {
        LOG.debug("Graph [{}] create vertex: {}", (Object)graph, (Object)jsonVertex);
        VertexAPI.checkCreatingBody(jsonVertex);
        HugeGraph g = VertexAPI.graph(manager, graph);
        Vertex vertex = VertexAPI.commit(g, () -> g.addVertex(jsonVertex.properties()));
        return manager.serializer((Graph)g).writeVertex(vertex);
    }

    @POST
    @Timed(name="batch-create")
    @DecompressInterceptor.Decompress
    @Path(value="batch")
    @StatusFilter.Status(value=201)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=vertex_write"})
    public String create(@Context HugeConfig config, @Context GraphManager manager, @PathParam(value="graph") String graph, List<JsonVertex> jsonVertices) {
        LOG.debug("Graph [{}] create vertices: {}", (Object)graph, jsonVertices);
        VertexAPI.checkCreatingBody(jsonVertices);
        VertexAPI.checkBatchSize(config, jsonVertices);
        HugeGraph g = VertexAPI.graph(manager, graph);
        return this.commit(config, g, jsonVertices.size(), () -> {
            ArrayList<Id> ids = new ArrayList<Id>(jsonVertices.size());
            for (JsonVertex vertex : jsonVertices) {
                ids.add((Id)g.addVertex(vertex.properties()).id());
            }
            return manager.serializer((Graph)g).writeIds(ids);
        });
    }

    @PUT
    @Timed(name="batch-update")
    @DecompressInterceptor.Decompress
    @Path(value="batch")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=vertex_write"})
    public String update(@Context HugeConfig config, @Context GraphManager manager, @PathParam(value="graph") String graph, BatchVertexRequest req) {
        BatchVertexRequest.checkUpdate(req);
        LOG.debug("Graph [{}] update vertices: {}", (Object)graph, (Object)req);
        VertexAPI.checkUpdatingBody(req.jsonVertices);
        VertexAPI.checkBatchSize(config, req.jsonVertices);
        HugeGraph g = VertexAPI.graph(manager, graph);
        HashMap map = new HashMap(req.jsonVertices.size());
        return this.commit(config, g, 0, () -> {
            req.jsonVertices.forEach(newVertex -> {
                Id newVertexId = VertexAPI.getVertexId(g, newVertex);
                JsonVertex oldVertex = (JsonVertex)map.get(newVertexId);
                this.updateExistElement(oldVertex, (BatchAPI.JsonElement)newVertex, req.updateStrategies);
                map.put(newVertexId, newVertex);
            });
            Object[] ids = map.keySet().toArray();
            Iterator oldVertices = g.vertices(ids);
            oldVertices.forEachRemaining(oldVertex -> {
                JsonVertex newVertex = (JsonVertex)map.get(oldVertex.id());
                this.updateExistElement(g, (Element)oldVertex, newVertex, req.updateStrategies);
            });
            ArrayList vertices = new ArrayList(map.size());
            map.values().forEach(finalVertex -> vertices.add(g.addVertex(finalVertex.properties())));
            return manager.serializer((Graph)g).writeVertices(vertices.iterator(), false);
        });
    }

    @PUT
    @Timed(name="single-update")
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=vertex_write"})
    public String update(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="id") String idValue, @QueryParam(value="action") String action, JsonVertex jsonVertex) {
        LOG.debug("Graph [{}] update vertex: {}", (Object)graph, (Object)jsonVertex);
        VertexAPI.checkUpdatingBody(jsonVertex);
        Id id = VertexAPI.checkAndParseVertexId(idValue);
        boolean append = VertexAPI.checkAndParseAction(action);
        HugeGraph g = VertexAPI.graph(manager, graph);
        HugeVertex vertex = (HugeVertex)g.vertex((Object)id);
        VertexLabel vertexLabel = vertex.schemaLabel();
        for (String key : jsonVertex.properties.keySet()) {
            PropertyKey pkey = g.propertyKey(key);
            E.checkArgument((boolean)vertexLabel.properties().contains(pkey.id()), (String)"Can't update property for vertex '%s' because there is no property key '%s' in its vertex label", (Object[])new Object[]{id, key});
        }
        VertexAPI.commit(g, () -> VertexAPI.updateProperties((HugeElement)vertex, jsonVertex, append));
        return manager.serializer((Graph)g).writeVertex((Vertex)vertex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Timed
    @CompressInterceptor.Compress
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=vertex_read"})
    public String list(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="label") String label, @QueryParam(value="properties") String properties, @QueryParam(value="keep_start_p") @DefaultValue(value="false") boolean keepStartP, @QueryParam(value="offset") @DefaultValue(value="0") long offset, @QueryParam(value="page") String page, @QueryParam(value="limit") @DefaultValue(value="100") long limit) {
        LOG.debug("Graph [{}] query vertices by label: {}, properties: {}, offset: {}, page: {}, limit: {}", new Object[]{graph, label, properties, offset, page, limit});
        Map<String, Object> props = VertexAPI.parseProperties(properties);
        if (page != null) {
            E.checkArgument((offset == 0L ? 1 : 0) != 0, (String)"Not support querying vertices based on paging and offset together", (Object[])new Object[0]);
        }
        HugeGraph g = VertexAPI.graph(manager, graph);
        GraphTraversal traversal = g.traversal().V(new Object[0]);
        if (label != null) {
            traversal = traversal.hasLabel(label, new String[0]);
        }
        for (Map.Entry<String, Object> prop : props.entrySet()) {
            Object value = prop.getValue();
            if (keepStartP || !(value instanceof String) || !((String)value).startsWith("P.")) continue;
            prop.setValue(TraversalUtil.parsePredicate((String)((String)value)));
        }
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            traversal = traversal.has(entry.getKey(), entry.getValue());
        }
        traversal = page == null ? traversal.range(offset, offset + limit) : traversal.has("~page", (Object)page).limit(limit);
        try {
            String string = manager.serializer((Graph)g).writeVertices((Iterator<Vertex>)traversal, page != null);
            return string;
        }
        finally {
            if (g.tx().isOpen()) {
                g.tx().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Timed
    @Path(value="{id}")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=vertex_read"})
    public String get(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="id") String idValue) {
        LOG.debug("Graph [{}] get vertex by id '{}'", (Object)graph, (Object)idValue);
        Id id = VertexAPI.checkAndParseVertexId(idValue);
        HugeGraph g = VertexAPI.graph(manager, graph);
        try {
            Vertex vertex = g.vertex((Object)id);
            String string = manager.serializer((Graph)g).writeVertex(vertex);
            return string;
        }
        finally {
            if (g.tx().isOpen()) {
                g.tx().close();
            }
        }
    }

    @DELETE
    @Timed
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=vertex_delete"})
    public void delete(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="id") String idValue, @QueryParam(value="label") String label) {
        LOG.debug("Graph [{}] remove vertex by id '{}'", (Object)graph, (Object)idValue);
        Id id = VertexAPI.checkAndParseVertexId(idValue);
        HugeGraph g = VertexAPI.graph(manager, graph);
        VertexAPI.commit(g, () -> {
            try {
                g.removeVertex(label, (Object)id);
            }
            catch (NotFoundException e) {
                throw new IllegalArgumentException(String.format("No such vertex with id: '%s', %s", new Object[]{id, e}));
            }
            catch (NoSuchElementException e) {
                throw new IllegalArgumentException(String.format("No such vertex with id: '%s'", id));
            }
        });
    }

    public static Id checkAndParseVertexId(String idValue) {
        if (idValue == null) {
            return null;
        }
        boolean uuid = idValue.startsWith("U\"");
        if (uuid) {
            idValue = idValue.substring(1);
        }
        try {
            Object id = JsonUtil.fromJson((String)idValue, Object.class);
            return uuid ? Text.uuid((String)((String)id)) : HugeVertex.getIdValue((Object)id);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("The vertex id must be formatted as Number/String/UUID, but got '%s'", idValue));
        }
    }

    private static void checkBatchSize(HugeConfig config, List<JsonVertex> vertices) {
        int max = (Integer)config.get(ServerOptions.MAX_VERTICES_PER_BATCH);
        if (vertices.size() > max) {
            throw new IllegalArgumentException(String.format("Too many vertices for one time post, the maximum number is '%s'", max));
        }
        if (vertices.isEmpty()) {
            throw new IllegalArgumentException("The number of vertices can't be 0");
        }
    }

    private static Id getVertexId(HugeGraph g, JsonVertex vertex) {
        VertexLabel vertexLabel = g.vertexLabel(vertex.label);
        String labelId = vertexLabel.id().asString();
        IdStrategy idStrategy = vertexLabel.idStrategy();
        E.checkArgument((idStrategy != IdStrategy.AUTOMATIC ? 1 : 0) != 0, (String)"Automatic Id strategy is not supported now", (Object[])new Object[0]);
        if (idStrategy == IdStrategy.PRIMARY_KEY) {
            List pkIds = vertexLabel.primaryKeys();
            ArrayList pkValues = new ArrayList(pkIds.size());
            for (Id pkId : pkIds) {
                String propertyKey = g.propertyKey(pkId).name();
                Object propertyValue = vertex.properties.get(propertyKey);
                E.checkArgument((propertyValue != null ? 1 : 0) != 0, (String)"The value of primary key '%s' can't be null", (Object[])new Object[]{propertyKey});
                pkValues.add(propertyValue);
            }
            String value = ConditionQuery.concatValues(pkValues);
            return SplicingIdGenerator.splicing((String[])new String[]{labelId, value});
        }
        if (idStrategy == IdStrategy.CUSTOMIZE_UUID) {
            return Text.uuid((String)String.valueOf(vertex.id));
        }
        assert (idStrategy == IdStrategy.CUSTOMIZE_NUMBER || idStrategy == IdStrategy.CUSTOMIZE_STRING);
        return HugeVertex.getIdValue((Object)vertex.id);
    }

    private static class JsonVertex
    extends BatchAPI.JsonElement {
        private JsonVertex() {
        }

        @Override
        public void checkCreate(boolean isBatch) {
            this.checkUpdate();
        }

        @Override
        public void checkUpdate() {
            E.checkArgumentNotNull((Object)this.properties, (String)"The properties of vertex can't be null", (Object[])new Object[0]);
            for (Map.Entry e : this.properties.entrySet()) {
                String key = (String)e.getKey();
                Object value = e.getValue();
                E.checkArgumentNotNull(value, (String)"Not allowed to set value of property '%s' to null for vertex '%s'", (Object[])new Object[]{key, this.id});
            }
        }

        @Override
        public Object[] properties() {
            int newSize;
            Object[] props = API.properties(this.properties);
            int appendIndex = newSize = props.length;
            if (this.label != null) {
                newSize += 2;
            }
            if (this.id != null) {
                newSize += 2;
            }
            if (newSize == props.length) {
                return props;
            }
            Object[] newProps = Arrays.copyOf(props, newSize);
            if (this.label != null) {
                newProps[appendIndex++] = T.label;
                newProps[appendIndex++] = this.label;
            }
            if (this.id != null) {
                newProps[appendIndex++] = T.id;
                newProps[appendIndex++] = this.id;
            }
            return newProps;
        }

        public String toString() {
            return String.format("JsonVertex{label=%s, properties=%s}", this.label, this.properties);
        }
    }

    private static class BatchVertexRequest {
        @JsonProperty(value="vertices")
        public List<JsonVertex> jsonVertices;
        @JsonProperty(value="update_strategies")
        public Map<String, UpdateStrategy> updateStrategies;
        @JsonProperty(value="create_if_not_exist")
        public boolean createIfNotExist = true;

        private BatchVertexRequest() {
        }

        private static void checkUpdate(BatchVertexRequest req) {
            E.checkArgumentNotNull((Object)req, (String)"BatchVertexRequest can't be null", (Object[])new Object[0]);
            E.checkArgumentNotNull(req.jsonVertices, (String)"Parameter 'vertices' can't be null", (Object[])new Object[0]);
            E.checkArgument((req.updateStrategies != null && !req.updateStrategies.isEmpty() ? 1 : 0) != 0, (String)"Parameter 'update_strategies' can't be empty", (Object[])new Object[0]);
            E.checkArgument((boolean)req.createIfNotExist, (String)"Parameter 'create_if_not_exist' dose not support false now", (Object[])new Object[0]);
        }

        public String toString() {
            return String.format("BatchVertexRequest{jsonVertices=%s,updateStrategies=%s,createIfNotExist=%s}", this.jsonVertices, this.updateStrategies, this.createIfNotExist);
        }
    }
}

