/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.variables;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.Map;
import java.util.Optional;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/variables")
@Singleton
@Tag(name="VariablesAPI")
public class VariablesAPI
extends API {
    private static final Logger LOG = Log.logger(VariablesAPI.class);

    @PUT
    @Timed
    @Path(value="{key}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Map<String, Object> update(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="key") String key, JsonVariableValue value) {
        E.checkArgument((value != null && value.data != null ? 1 : 0) != 0, (String)"The variable value can't be empty", (Object[])new Object[0]);
        LOG.debug("Graph [{}] set variable for {}: {}", new Object[]{graph, key, value});
        HugeGraph g = VariablesAPI.graph(manager, graph);
        VariablesAPI.commit(g, () -> g.variables().set(key, value.data));
        return ImmutableMap.of((Object)key, (Object)value.data);
    }

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public Map<String, Object> list(@Context GraphManager manager, @PathParam(value="graph") String graph) {
        LOG.debug("Graph [{}] get variables", (Object)graph);
        HugeGraph g = VariablesAPI.graph(manager, graph);
        return g.variables().asMap();
    }

    @GET
    @Timed
    @Path(value="{key}")
    @Produces(value={"application/json;charset=UTF-8"})
    public Map<String, Object> get(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="key") String key) {
        LOG.debug("Graph [{}] get variable by key '{}'", (Object)graph, (Object)key);
        HugeGraph g = VariablesAPI.graph(manager, graph);
        Optional object = g.variables().get(key);
        if (!object.isPresent()) {
            throw new NotFoundException(String.format("Variable '%s' does not exist", key));
        }
        return ImmutableMap.of((Object)key, object.get());
    }

    @DELETE
    @Timed
    @Path(value="{key}")
    @Consumes(value={"application/json"})
    public void delete(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="key") String key) {
        LOG.debug("Graph [{}] remove variable by key '{}'", (Object)graph, (Object)key);
        HugeGraph g = VariablesAPI.graph(manager, graph);
        VariablesAPI.commit(g, () -> g.variables().remove(key));
    }

    private static class JsonVariableValue {
        public Object data;

        private JsonVariableValue() {
        }

        public String toString() {
            return String.format("JsonVariableValue{data=%s}", this.data);
        }
    }
}

