/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.algorithm.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.algorithm.generator.AbstractGenerator;
import org.apache.tinkerpop.gremlin.algorithm.generator.Distribution;
import org.apache.tinkerpop.gremlin.algorithm.generator.SizableIterable;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class CommunityGenerator
extends AbstractGenerator {
    public static final double DEFAULT_CROSS_COMMUNITY_PERCENTAGE = 0.1;
    public static final int DEFAULT_NUMBER_OF_COMMUNITIES = 2;
    private final Distribution communitySize;
    private final Distribution edgeDegree;
    private final double crossCommunityPercentage;
    private final Iterable<Vertex> vertices;
    private final int expectedNumCommunities;
    private final int expectedNumEdges;
    private final Random random;

    private CommunityGenerator(Graph g, String label, Optional<Consumer<Edge>> edgeProcessor, Optional<BiConsumer<Vertex, Map<String, Object>>> vertexProcessor, Supplier<Long> seedGenerator, Distribution communitySize, Distribution edgeDegree, double crossCommunityPercentage, Iterable<Vertex> vertices, int expectedNumCommunities, int expectedNumEdges) {
        super(g, label, edgeProcessor, vertexProcessor, seedGenerator);
        this.random = new Random((Long)this.seedSupplier.get());
        this.communitySize = communitySize;
        this.edgeDegree = edgeDegree;
        this.crossCommunityPercentage = crossCommunityPercentage;
        this.vertices = vertices;
        this.expectedNumCommunities = expectedNumCommunities;
        this.expectedNumEdges = expectedNumEdges;
    }

    @Override
    public int generate() {
        int numVertices = SizableIterable.sizeOf(this.vertices);
        Iterator<Vertex> iter = this.vertices.iterator();
        ArrayList communities = new ArrayList(this.expectedNumCommunities);
        Distribution communityDist = this.communitySize.initialize(this.expectedNumCommunities, numVertices);
        HashMap<String, Object> context = new HashMap<String, Object>();
        while (iter.hasNext()) {
            int nextSize = communityDist.nextValue(this.random);
            context.put("communityIndex", communities.size());
            ArrayList<Vertex> community = new ArrayList<Vertex>(nextSize);
            for (int i = 0; i < nextSize && iter.hasNext(); ++i) {
                community.add(this.processVertex(iter.next(), context));
            }
            if (community.isEmpty()) continue;
            communities.add(community);
        }
        double inCommunityPercentage = 1.0 - this.crossCommunityPercentage;
        Distribution degreeDist = this.edgeDegree.initialize(numVertices, this.expectedNumEdges);
        if (this.crossCommunityPercentage > 0.0 && communities.size() < 2) {
            throw new IllegalArgumentException("Cannot have cross links with only one community");
        }
        int addedEdges = 0;
        for (ArrayList arrayList : communities) {
            for (Vertex v : arrayList) {
                int randomDegree = degreeDist.nextValue(this.random);
                int degree = Math.min(randomDegree, (int)Math.ceil((double)(arrayList.size() - 1) / inCommunityPercentage) - 1);
                HashSet<Vertex> inlinks = new HashSet<Vertex>();
                HashSet<Vertex> outlinks = new HashSet<Vertex>();
                for (int i = 0; i < degree; ++i) {
                    int tries;
                    Vertex selected = null;
                    if (this.random.nextDouble() < this.crossCommunityPercentage || arrayList.size() - 1 <= inlinks.size()) {
                        ArrayList othercomm = null;
                        for (tries = 0; null == selected && tries < 100; ++tries) {
                            while (null == othercomm) {
                                othercomm = (ArrayList)communities.get(this.random.nextInt(communities.size()));
                                if (!othercomm.equals(arrayList)) continue;
                                othercomm = null;
                            }
                            selected = (Vertex)othercomm.get(this.random.nextInt(othercomm.size()));
                            if (!outlinks.contains(selected)) continue;
                            selected = null;
                        }
                        if (selected != null) {
                            outlinks.add(selected);
                        }
                    } else {
                        for (tries = 0; selected == null && tries < 100; ++tries) {
                            selected = (Vertex)arrayList.get(this.random.nextInt(arrayList.size()));
                            if (!v.equals(selected) && !inlinks.contains(selected)) continue;
                            selected = null;
                        }
                        if (selected != null) {
                            inlinks.add(selected);
                        }
                    }
                    if (selected == null) continue;
                    this.addEdge(v, selected);
                    ++addedEdges;
                }
            }
        }
        return addedEdges;
    }

    public static Builder build(Graph g) {
        return new Builder(g);
    }

    public static final class Builder
    extends AbstractGenerator.AbstractGeneratorBuilder<Builder> {
        private final Graph g;
        private Distribution communitySize = null;
        private Distribution edgeDegree = null;
        private double crossCommunityPercentage = 0.1;
        private Iterable<Vertex> vertices;
        private int expectedNumCommunities = 2;
        private int expectedNumEdges;

        private Builder(Graph g) {
            super(Builder.class);
            List allVertices;
            this.g = g;
            this.vertices = allVertices = IteratorUtils.list((Iterator)g.vertices(new Object[0]));
            this.expectedNumEdges = allVertices.size() * 2;
        }

        public Builder verticesToGenerateEdgesFor(Iterable<Vertex> vertices) {
            this.vertices = vertices;
            return this;
        }

        public Builder expectedNumCommunities(int expectedNumCommunities) {
            this.expectedNumCommunities = expectedNumCommunities;
            return this;
        }

        public Builder expectedNumEdges(int expectedNumEdges) {
            this.expectedNumEdges = expectedNumEdges;
            return this;
        }

        public Builder communityDistribution(Distribution community) {
            this.communitySize = community;
            return this;
        }

        public Builder degreeDistribution(Distribution degree) {
            this.edgeDegree = degree;
            return this;
        }

        public Builder crossCommunityPercentage(double percentage) {
            if (percentage < 0.0 || percentage > 1.0) {
                throw new IllegalArgumentException("Percentage must be between 0 and 1");
            }
            this.crossCommunityPercentage = percentage;
            return this;
        }

        public CommunityGenerator create() {
            if (null == this.communitySize) {
                throw new IllegalStateException("Need to initialize community size distribution");
            }
            if (null == this.edgeDegree) {
                throw new IllegalStateException("Need to initialize degree distribution");
            }
            return new CommunityGenerator(this.g, this.label, this.edgeProcessor, this.vertexProcessor, this.seedSupplier, this.communitySize, this.edgeDegree, this.crossCommunityPercentage, this.vertices, this.expectedNumCommunities, this.expectedNumEdges);
        }
    }
}

