/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.algorithm.generator;

import java.util.Collection;
import java.util.Iterator;

public class SizableIterable<T>
implements Iterable<T> {
    private final Iterable<T> iterable;
    private final int size;

    public SizableIterable(Iterable<T> iterable, int size) {
        if (iterable == null) {
            throw new NullPointerException();
        }
        if (size < 0) {
            throw new IllegalArgumentException("Size must be positive");
        }
        this.iterable = iterable;
        this.size = size;
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterable.iterator();
    }

    public static <T> int sizeOf(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        if (iterable instanceof SizableIterable) {
            return ((SizableIterable)iterable).size();
        }
        int size = 0;
        Iterator<T> iter = iterable.iterator();
        while (iter.hasNext()) {
            ++size;
            iter.next();
        }
        return size;
    }
}

