/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.ser.AbstractMessageSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoMapper;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoVersion;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;

@Deprecated
public abstract class AbstractGryoMessageSerializerV3d0
extends AbstractMessageSerializer<Kryo> {
    private GryoMapper gryoMapper;
    private ThreadLocal<Kryo> kryoThreadLocal = new ThreadLocal<Kryo>(){

        @Override
        protected Kryo initialValue() {
            return AbstractGryoMessageSerializerV3d0.this.gryoMapper.createMapper();
        }
    };
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String TOKEN_CUSTOM = "custom";
    public static final String TOKEN_SERIALIZE_RESULT_TO_STRING = "serializeResultToString";
    public static final String TOKEN_BUFFER_SIZE = "bufferSize";
    public static final String TOKEN_CLASS_RESOLVER_SUPPLIER = "classResolverSupplier";
    protected boolean serializeToString = false;
    private int bufferSize = 4096;

    public AbstractGryoMessageSerializerV3d0(GryoMapper kryo) {
        this.gryoMapper = kryo;
    }

    @Override
    public Kryo getMapper() {
        return this.kryoThreadLocal.get();
    }

    GryoMapper.Builder configureBuilder(GryoMapper.Builder builder, Map<String, Object> config, Map<String, Graph> graphs) {
        return builder;
    }

    @Override
    public final void configure(Map<String, Object> config, Map<String, Graph> graphs) {
        GryoMapper.Builder builder = GryoMapper.build().version(GryoVersion.V3_0);
        this.addIoRegistries(config, (Mapper.Builder)builder);
        this.addClassResolverSupplier(config, builder);
        this.addCustomClasses(config, builder);
        this.serializeToString = Boolean.parseBoolean(config.getOrDefault(TOKEN_SERIALIZE_RESULT_TO_STRING, "false").toString());
        this.bufferSize = Integer.parseInt(config.getOrDefault(TOKEN_BUFFER_SIZE, "4096").toString());
        this.gryoMapper = this.configureBuilder(builder, config, graphs).create();
    }

    private void addClassResolverSupplier(Map<String, Object> config, GryoMapper.Builder builder) {
        String className = config.getOrDefault(TOKEN_CLASS_RESOLVER_SUPPLIER, null);
        if (className != null && !className.isEmpty()) {
            try {
                Class<?> clazz = Class.forName(className);
                try {
                    Method instanceMethod = this.tryInstanceMethod(clazz);
                    builder.classResolver((Supplier)instanceMethod.invoke(null, new Object[0]));
                }
                catch (Exception methodex) {
                    builder.classResolver((Supplier)clazz.newInstance());
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private void addCustomClasses(Map<String, Object> config, GryoMapper.Builder builder) {
        List<String> classNameList = this.getListStringFromConfig(TOKEN_CUSTOM, config);
        classNameList.stream().forEach(serializerDefinition -> {
            Optional<Object> serializerName;
            String className;
            if (serializerDefinition.contains(";")) {
                String[] split = serializerDefinition.split(";");
                if (split.length != 2) {
                    throw new IllegalStateException(String.format("Invalid format for serializer definition [%s] - expected <class>;<serializer-class>", serializerDefinition));
                }
                className = split[0];
                serializerName = Optional.of(split[1]);
            } else {
                serializerName = Optional.empty();
                className = serializerDefinition;
            }
            try {
                Class<?> clazz = Class.forName(className);
                if (serializerName.isPresent()) {
                    Class<?> serializerClazz = Class.forName((String)serializerName.get());
                    Serializer serializer = (Serializer)serializerClazz.newInstance();
                    builder.addCustom(clazz, kryo -> serializer);
                } else {
                    builder.addCustom(new Class[]{clazz});
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException("Class could not be found", ex);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResponseMessage deserializeResponse(ByteBuf msg) throws SerializationException {
        try {
            Kryo kryo = this.kryoThreadLocal.get();
            byte[] payload = new byte[msg.capacity()];
            msg.readBytes(payload);
            try (Input input = new Input(payload);){
                ResponseMessage responseMessage = (ResponseMessage)kryo.readObject(input, ResponseMessage.class);
                return responseMessage;
            }
        }
        catch (Exception ex) {
            logger.warn(String.format("Response [%s] could not be deserialized by %s.", msg, AbstractGryoMessageSerializerV3d0.class.getName()), (Throwable)ex);
            throw new SerializationException(ex);
        }
    }

    @Override
    public ByteBuf serializeResponseAsBinary(ResponseMessage responseMessage, ByteBufAllocator allocator) throws SerializationException {
        ByteBuf encodedMessage = null;
        try {
            Kryo kryo = this.kryoThreadLocal.get();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                Output output = new Output((OutputStream)baos, this.bufferSize);
                ResponseMessage msgToWrite = !this.serializeToString ? responseMessage : ResponseMessage.build(responseMessage.getRequestId()).code(responseMessage.getStatus().getCode()).statusAttributes(responseMessage.getStatus().getAttributes()).responseMetaData(responseMessage.getResult().getMeta()).result(this.serializeResultToString(responseMessage)).statusMessage(responseMessage.getStatus().getMessage()).create();
                kryo.writeObject(output, (Object)msgToWrite);
                long size = output.total();
                if (size > Integer.MAX_VALUE) {
                    throw new SerializationException(String.format("Message size of %s exceeds allocatable space", size));
                }
                output.flush();
                encodedMessage = allocator.buffer((int)size);
                encodedMessage.writeBytes(baos.toByteArray());
            }
            return encodedMessage;
        }
        catch (Exception ex) {
            if (encodedMessage != null) {
                ReferenceCountUtil.release(encodedMessage);
            }
            logger.warn(String.format("Response [%s] could not be serialized by %s.", responseMessage, AbstractGryoMessageSerializerV3d0.class.getName()), (Throwable)ex);
            throw new SerializationException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RequestMessage deserializeRequest(ByteBuf msg) throws SerializationException {
        try {
            Kryo kryo = this.kryoThreadLocal.get();
            byte[] payload = new byte[msg.readableBytes()];
            msg.readBytes(payload);
            try (Input input = new Input(payload);){
                RequestMessage requestMessage = (RequestMessage)kryo.readObject(input, RequestMessage.class);
                return requestMessage;
            }
        }
        catch (Exception ex) {
            logger.warn(String.format("Request [%s] could not be deserialized by %s.", msg, AbstractGryoMessageSerializerV3d0.class.getName()), (Throwable)ex);
            throw new SerializationException(ex);
        }
    }

    @Override
    public ByteBuf serializeRequestAsBinary(RequestMessage requestMessage, ByteBufAllocator allocator) throws SerializationException {
        ByteBuf encodedMessage = null;
        try {
            Kryo kryo = this.kryoThreadLocal.get();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                Output output = new Output((OutputStream)baos, this.bufferSize);
                String mimeType = this.mimeTypesSupported()[0];
                output.writeByte(mimeType.length());
                output.write(mimeType.getBytes(UTF8));
                kryo.writeObject(output, (Object)requestMessage);
                long size = output.total();
                if (size > Integer.MAX_VALUE) {
                    throw new SerializationException(String.format("Message size of %s exceeds allocatable space", size));
                }
                output.flush();
                encodedMessage = allocator.buffer((int)size);
                encodedMessage.writeBytes(baos.toByteArray());
            }
            return encodedMessage;
        }
        catch (Exception ex) {
            if (encodedMessage != null) {
                ReferenceCountUtil.release(encodedMessage);
            }
            logger.warn(String.format("Request [%s] could not be serialized by %s.", requestMessage, AbstractGryoMessageSerializerV3d0.class.getName()), (Throwable)ex);
            throw new SerializationException(ex);
        }
    }

    private Object serializeResultToString(ResponseMessage msg) {
        if (msg.getResult() == null) {
            return "null";
        }
        if (msg.getResult().getData() == null) {
            return "null";
        }
        Object o = msg.getResult().getData();
        if (o instanceof Collection) {
            return ((Collection)o).stream().map(d -> null == d ? "null" : d.toString()).collect(Collectors.toList());
        }
        return o.toString();
    }
}

