/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.cassandra.exceptions.SyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyDefinitions {
    private static final Pattern POSITIVE_PATTERN = Pattern.compile("(1|true|yes)");
    private static final Pattern NEGATIVE_PATTERN = Pattern.compile("(0|false|no)");
    protected static final Logger logger = LoggerFactory.getLogger(PropertyDefinitions.class);
    protected final Map<String, Object> properties = new HashMap<String, Object>();

    public void addProperty(String name, String value) throws SyntaxException {
        if (this.properties.put(name, value) != null) {
            throw new SyntaxException(String.format("Multiple definition for property '%s'", name));
        }
    }

    public void addProperty(String name, Map<String, String> value) throws SyntaxException {
        if (this.properties.put(name, value) != null) {
            throw new SyntaxException(String.format("Multiple definition for property '%s'", name));
        }
    }

    public void validate(Set<String> keywords, Set<String> obsolete) throws SyntaxException {
        for (String name : this.properties.keySet()) {
            if (keywords.contains(name)) continue;
            if (obsolete.contains(name)) {
                logger.warn("Ignoring obsolete property {}", (Object)name);
                continue;
            }
            throw new SyntaxException(String.format("Unknown property '%s'", name));
        }
    }

    protected String getSimple(String name) throws SyntaxException {
        Object val = this.properties.get(name);
        if (val == null) {
            return null;
        }
        if (!(val instanceof String)) {
            throw new SyntaxException(String.format("Invalid value for property '%s'. It should be a string", name));
        }
        return (String)val;
    }

    protected Map<String, String> getMap(String name) throws SyntaxException {
        Object val = this.properties.get(name);
        if (val == null) {
            return null;
        }
        if (!(val instanceof Map)) {
            throw new SyntaxException(String.format("Invalid value for property '%s'. It should be a map.", name));
        }
        return (Map)val;
    }

    public Boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public static boolean parseBoolean(String key, String value) throws SyntaxException {
        if (null == value) {
            throw new IllegalArgumentException("value argument can't be null");
        }
        String lowerCasedValue = value.toLowerCase();
        if (POSITIVE_PATTERN.matcher(lowerCasedValue).matches()) {
            return true;
        }
        if (NEGATIVE_PATTERN.matcher(lowerCasedValue).matches()) {
            return false;
        }
        throw new SyntaxException(String.format("Invalid boolean value %s for '%s'. Positive values can be '1', 'true' or 'yes'. Negative values can be '0', 'false' or 'no'.", value, key));
    }

    public Boolean getBoolean(String key, Boolean defaultValue) throws SyntaxException {
        String value = this.getSimple(key);
        return value == null ? defaultValue : PropertyDefinitions.parseBoolean(key, value);
    }

    public double getDouble(String key, double defaultValue) throws SyntaxException {
        String value = this.getSimple(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new SyntaxException(String.format("Invalid double value %s for '%s'", value, key));
        }
    }

    public Integer getInt(String key, Integer defaultValue) throws SyntaxException {
        String value = this.getSimple(key);
        return PropertyDefinitions.toInt(key, value, defaultValue);
    }

    public static Integer toInt(String key, String value, Integer defaultValue) throws SyntaxException {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new SyntaxException(String.format("Invalid integer value %s for '%s'", value, key));
        }
    }
}

