/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.util;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class Base58Encoder {
    public static final char[] CHAR_SET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
    private static final int[] CHAR_INDEXES = new int[128];

    public static String convertToBase58(byte[] byteArray) {
        int leadingZeroCount;
        if (byteArray.length == 0) {
            return "";
        }
        byteArray = Base58Encoder.getSubArray(byteArray, 0, byteArray.length);
        for (leadingZeroCount = 0; leadingZeroCount < byteArray.length && byteArray[leadingZeroCount] == 0; ++leadingZeroCount) {
        }
        byte[] intermediate = new byte[byteArray.length * 2];
        int index = intermediate.length;
        int position = leadingZeroCount;
        while (position < byteArray.length) {
            byte remainder = Base58Encoder.divideAndModulo58(byteArray, position);
            if (byteArray[position] == 0) {
                ++position;
            }
            intermediate[--index] = (byte)CHAR_SET[remainder];
        }
        while (index < intermediate.length && intermediate[index] == CHAR_SET[0]) {
            ++index;
        }
        while (--leadingZeroCount >= 0) {
            intermediate[--index] = (byte)CHAR_SET[0];
        }
        byte[] result = Base58Encoder.getSubArray(intermediate, index, intermediate.length);
        return new String(result, StandardCharsets.US_ASCII);
    }

    public static byte[] convertFromBase58(String encodedStr) throws IllegalArgumentException {
        int leadingZeroCount;
        if (encodedStr.isEmpty()) {
            return new byte[0];
        }
        byte[] encodedBytes = new byte[encodedStr.length()];
        for (int i = 0; i < encodedStr.length(); ++i) {
            char character = encodedStr.charAt(i);
            int value58 = -1;
            if (character < '\u0080') {
                value58 = CHAR_INDEXES[character];
            }
            if (value58 < 0) {
                throw new IllegalArgumentException("Invalid character " + character + " at " + i);
            }
            encodedBytes[i] = (byte)value58;
        }
        for (leadingZeroCount = 0; leadingZeroCount < encodedBytes.length && encodedBytes[leadingZeroCount] == 0; ++leadingZeroCount) {
        }
        byte[] intermediate = new byte[encodedStr.length()];
        int index = intermediate.length;
        int position = leadingZeroCount;
        while (position < encodedBytes.length) {
            byte remainder = Base58Encoder.divideAndModulo256(encodedBytes, position);
            if (encodedBytes[position] == 0) {
                ++position;
            }
            intermediate[--index] = remainder;
        }
        while (index < intermediate.length && intermediate[index] == 0) {
            ++index;
        }
        return Base58Encoder.getSubArray(intermediate, index - leadingZeroCount, intermediate.length);
    }

    public static BigInteger convertToBigInt(String encodedStr) throws IllegalArgumentException {
        return new BigInteger(1, Base58Encoder.convertFromBase58(encodedStr));
    }

    private static byte divideAndModulo58(byte[] number, int startIndex) {
        int remainder = 0;
        for (int i = startIndex; i < number.length; ++i) {
            int byteValue = number[i] & 0xFF;
            int temp = remainder * 256 + byteValue;
            number[i] = (byte)(temp / 58);
            remainder = temp % 58;
        }
        return (byte)remainder;
    }

    private static byte divideAndModulo256(byte[] number58, int startIndex) {
        int remainder = 0;
        for (int i = startIndex; i < number58.length; ++i) {
            int byteValue58 = number58[i] & 0xFF;
            int temp = remainder * 58 + byteValue58;
            number58[i] = (byte)(temp / 256);
            remainder = temp % 256;
        }
        return (byte)remainder;
    }

    private static byte[] getSubArray(byte[] sourceArray, int start, int end) {
        byte[] resultArray = new byte[end - start];
        System.arraycopy(sourceArray, start, resultArray, 0, resultArray.length);
        return resultArray;
    }

    static {
        Arrays.fill(CHAR_INDEXES, -1);
        for (int i = 0; i < CHAR_SET.length; ++i) {
            Base58Encoder.CHAR_INDEXES[Base58Encoder.CHAR_SET[i]] = i;
        }
    }
}

