/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.mysql;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.page.PageState;
import org.apache.hugegraph.backend.query.Aggregate;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.IdQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.serializer.TableBackendEntry;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendTable;
import org.apache.hugegraph.backend.store.Shard;
import org.apache.hugegraph.backend.store.TableDefine;
import org.apache.hugegraph.backend.store.mysql.MysqlEntryIterator;
import org.apache.hugegraph.backend.store.mysql.MysqlOptions;
import org.apache.hugegraph.backend.store.mysql.MysqlSessions;
import org.apache.hugegraph.backend.store.mysql.ResultSetWrapper;
import org.apache.hugegraph.backend.store.mysql.WhereBuilder;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.iterator.ExtendableIterator;
import org.apache.hugegraph.iterator.WrappedIterator;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.slf4j.Logger;

public abstract class MysqlTable
extends BackendTable<MysqlSessions.Session, TableBackendEntry.Row> {
    private static final Logger LOG = Log.logger(MysqlTable.class);
    private static final String DECIMAL = "DECIMAL";
    private String insertTemplate = null;
    private String insertTemplateTtl = null;
    private String deleteTemplate = null;
    private String updateIfPresentTemplate = null;
    private String updateIfAbsentTemplate = null;
    private final MysqlShardSplitter shardSplitter = new MysqlShardSplitter(this.table());

    public MysqlTable(String table) {
        super(table);
    }

    protected void registerMetaHandlers() {
        this.registerMetaHandler("splits", (session, meta, args) -> {
            E.checkArgument((args.length == 1 ? 1 : 0) != 0, (String)"The args count of %s must be 1", (Object[])new Object[]{meta});
            long splitSize = (Long)args[0];
            return this.shardSplitter.getSplits((MysqlSessions.Session)session, splitSize);
        });
    }

    public abstract TableDefine tableDefine();

    public void init(MysqlSessions.Session session) {
        this.createTable(session, this.tableDefine());
    }

    public void clear(MysqlSessions.Session session) {
        this.dropTable(session);
    }

    public void truncate(MysqlSessions.Session session) {
        this.truncateTable(session);
    }

    protected void createTable(MysqlSessions.Session session, TableDefine tableDefine) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE IF NOT EXISTS ");
        sql.append(this.table()).append(" (");
        for (Map.Entry entry : tableDefine.columns().entrySet()) {
            sql.append(MysqlTable.formatKey((HugeKeys)entry.getKey()));
            sql.append(" ");
            sql.append((String)entry.getValue());
            sql.append(", ");
        }
        sql.append(" PRIMARY KEY (");
        int i = 0;
        int size = tableDefine.keys().size();
        for (HugeKeys key : tableDefine.keys()) {
            sql.append(MysqlTable.formatKey(key));
            if (++i == size) continue;
            sql.append(", ");
        }
        sql.append("))");
        sql.append(this.engine(session));
        sql.append(";");
        LOG.debug("Create table: {}", (Object)sql);
        try {
            session.execute(sql.toString());
        }
        catch (SQLException e) {
            throw new BackendException("Failed to create table with '%s'", (Throwable)e, new Object[]{sql});
        }
    }

    protected String engine(MysqlSessions.Session session) {
        String engine = (String)session.config().get(MysqlOptions.JDBC_STORAGE_ENGINE);
        return " ENGINE=" + engine;
    }

    protected void dropTable(MysqlSessions.Session session) {
        LOG.debug("Drop table: {}", (Object)this.table());
        String sql = this.buildDropTemplate();
        try {
            session.execute(sql);
        }
        catch (SQLException e) {
            throw new BackendException("Failed to drop table with '%s'", (Throwable)e, new Object[]{sql});
        }
    }

    protected void truncateTable(MysqlSessions.Session session) {
        LOG.debug("Truncate table: {}", (Object)this.table());
        String sql = this.buildTruncateTemplate();
        try {
            session.execute(sql);
        }
        catch (SQLException e) {
            throw new BackendException("Failed to truncate table with '%s'", (Throwable)e, new Object[]{sql});
        }
    }

    protected List<HugeKeys> idColumnName() {
        return this.tableDefine().keys();
    }

    protected List<Long> idColumnValue(TableBackendEntry.Row entry) {
        return ImmutableList.of((Object)entry.id().asLong());
    }

    protected List<Object> idColumnValue(Id id) {
        return ImmutableList.of((Object)id.asObject());
    }

    protected void insertOrUpdate(MysqlSessions.Session session, String template, List<?> params) {
        PreparedStatement insertStmt;
        try {
            insertStmt = session.prepareStatement(template);
            int i = 1;
            for (Object param : params) {
                insertStmt.setObject(i++, param);
            }
        }
        catch (SQLException e) {
            throw new BackendException("Failed to prepare statement '%s' with params: %s", new Object[]{template, params});
        }
        session.add(insertStmt);
    }

    protected final String buildUpdateTemplate(TableBackendEntry.Row entry) {
        if (entry.ttl() != 0L) {
            if (this.insertTemplateTtl != null) {
                return this.insertTemplateTtl;
            }
            this.insertTemplateTtl = this.buildUpdateForcedTemplate(entry);
            return this.insertTemplateTtl;
        }
        if (this.insertTemplate != null) {
            return this.insertTemplate;
        }
        this.insertTemplate = this.buildUpdateForcedTemplate(entry);
        return this.insertTemplate;
    }

    protected String buildUpdateForcedTemplate(TableBackendEntry.Row entry) {
        StringBuilder insert = new StringBuilder();
        insert.append("REPLACE INTO ").append(this.table());
        return this.buildInsertKeys(insert, entry);
    }

    protected String buildUpdateIfAbsentTemplate(TableBackendEntry.Row entry) {
        StringBuilder insert = new StringBuilder();
        insert.append("INSERT IGNORE INTO ").append(this.table());
        return this.buildInsertKeys(insert, entry);
    }

    protected String buildInsertKeys(StringBuilder insert, TableBackendEntry.Row entry) {
        insert.append(" (");
        int i = 0;
        int size = entry.columns().size();
        for (HugeKeys key : entry.columns().keySet()) {
            insert.append(MysqlTable.formatKey(key));
            if (++i == size) continue;
            insert.append(", ");
        }
        insert.append(") VALUES (");
        for (i = 0; i < size; ++i) {
            insert.append("?");
            if (i == size - 1) continue;
            insert.append(", ");
        }
        insert.append(")");
        return insert.toString();
    }

    protected List<?> buildUpdateForcedParams(TableBackendEntry.Row entry) {
        return this.buildColumnsParams(entry);
    }

    protected List<?> buildUpdateIfAbsentParams(TableBackendEntry.Row entry) {
        return this.buildColumnsParams(entry);
    }

    protected List<Object> buildColumnsParams(TableBackendEntry.Row entry) {
        return this.buildColumnsParams(entry, null);
    }

    protected List<Object> buildColumnsParams(TableBackendEntry.Row entry, List<HugeKeys> skipKeys) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Map.Entry e : entry.columns().entrySet()) {
            HugeKeys key = (HugeKeys)e.getKey();
            Object value = e.getValue();
            if (skipKeys != null && skipKeys.contains(key)) continue;
            String type = (String)this.tableDefine().columns().get(key);
            if (type.startsWith(DECIMAL)) {
                value = new BigDecimal(value.toString());
            }
            objects.add(value);
        }
        return objects;
    }

    protected String buildUpdateIfPresentTemplate(TableBackendEntry.Row entry) {
        StringBuilder update = new StringBuilder();
        update.append("UPDATE ").append(this.table());
        update.append(" SET ");
        List<HugeKeys> idNames = this.idColumnName();
        int i = 0;
        for (HugeKeys key : entry.columns().keySet()) {
            if (idNames.contains(key)) continue;
            if (i++ > 0) {
                update.append(", ");
            }
            update.append(MysqlTable.formatKey(key));
            update.append("=?");
        }
        WhereBuilder where = this.newWhereBuilder();
        where.and(MysqlTable.formatKeys(idNames), "=");
        update.append((CharSequence)where.build());
        return update.toString();
    }

    protected List<?> buildUpdateIfPresentParams(TableBackendEntry.Row entry) {
        List<HugeKeys> idNames = this.idColumnName();
        List<Object> params = this.buildColumnsParams(entry, idNames);
        List<Long> idValues = this.idColumnValue(entry);
        params.addAll(idValues);
        return params;
    }

    protected String buildDeleteTemplate(List<HugeKeys> idNames) {
        StringBuilder delete = new StringBuilder();
        delete.append("DELETE FROM ").append(this.table());
        this.appendPartition(delete);
        WhereBuilder where = this.newWhereBuilder();
        where.and(MysqlTable.formatKeys(idNames), "=");
        delete.append((CharSequence)where.build());
        return delete.toString();
    }

    protected String buildDropTemplate() {
        return String.format("DROP TABLE IF EXISTS %s;", this.table());
    }

    protected String buildTruncateTemplate() {
        return String.format("TRUNCATE TABLE %s;", this.table());
    }

    protected void appendPartition(StringBuilder sb) {
    }

    public void insert(MysqlSessions.Session session, TableBackendEntry.Row entry) {
        String template = this.buildUpdateTemplate(entry);
        List<?> params = this.buildUpdateForcedParams(entry);
        this.insertOrUpdate(session, template, params);
    }

    public void delete(MysqlSessions.Session session, TableBackendEntry.Row entry) {
        PreparedStatement deleteStmt;
        List<HugeKeys> idNames = this.idColumnName();
        String template = this.deleteTemplate;
        if (template == null) {
            this.deleteTemplate = template = this.buildDeleteTemplate(idNames);
        }
        try {
            deleteStmt = session.prepareStatement(template);
            if (entry.columns().isEmpty()) {
                List<Long> idValues = this.idColumnValue(entry);
                assert (idNames.size() == idValues.size());
                int n = idNames.size();
                for (int i = 0; i < n; ++i) {
                    deleteStmt.setObject(i + 1, idValues.get(i));
                }
            } else {
                int n = idNames.size();
                for (int i = 0; i < n; ++i) {
                    HugeKeys key = idNames.get(i);
                    Object value = entry.column(key);
                    deleteStmt.setObject(i + 1, value);
                }
            }
        }
        catch (SQLException e) {
            throw new BackendException("Failed to prepare statement '%s'with entry columns %s", new Object[]{template, entry.columns().values()});
        }
        session.add(deleteStmt);
    }

    public void append(MysqlSessions.Session session, TableBackendEntry.Row entry) {
        this.insert(session, entry);
    }

    public void eliminate(MysqlSessions.Session session, TableBackendEntry.Row entry) {
        this.delete(session, entry);
    }

    public void updateIfPresent(MysqlSessions.Session session, TableBackendEntry.Row entry) {
        String template = this.updateIfPresentTemplate;
        if (template == null) {
            this.updateIfPresentTemplate = template = this.buildUpdateIfPresentTemplate(entry);
        }
        List<?> params = this.buildUpdateIfPresentParams(entry);
        this.insertOrUpdate(session, template, params);
    }

    public void updateIfAbsent(MysqlSessions.Session session, TableBackendEntry.Row entry) {
        String template = this.updateIfAbsentTemplate;
        if (template == null) {
            this.updateIfAbsentTemplate = template = this.buildUpdateIfAbsentTemplate(entry);
        }
        List<?> params = this.buildUpdateIfAbsentParams(entry);
        this.insertOrUpdate(session, template, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryExist(MysqlSessions.Session session, TableBackendEntry.Row entry) {
        IdQuery.OneIdQuery query = new IdQuery.OneIdQuery(HugeType.UNKNOWN, entry.id());
        Iterator<BackendEntry> iter = this.query(session, (Query)query);
        try {
            boolean bl = iter.hasNext();
            return bl;
        }
        finally {
            WrappedIterator.close(iter);
        }
    }

    public Number queryNumber(MysqlSessions.Session session, Query query) {
        Aggregate aggregate = query.aggregateNotNull();
        Iterator results = this.query(session, query, (q, rs) -> {
            try {
                if (!rs.resultSet().next()) {
                    Iterator iterator = IteratorUtils.of((Object)aggregate.defaultValue());
                    return iterator;
                }
                Iterator iterator = IteratorUtils.of((Object)rs.resultSet().getLong(1));
                return iterator;
            }
            catch (SQLException e) {
                throw new BackendException((Throwable)e);
            }
            finally {
                rs.close();
            }
        });
        return aggregate.reduce(results);
    }

    public Iterator<BackendEntry> query(MysqlSessions.Session session, Query query) {
        return this.query(session, query, this::results2Entries);
    }

    protected <R> Iterator<R> query(MysqlSessions.Session session, Query query, BiFunction<Query, ResultSetWrapper, Iterator<R>> parser) {
        ExtendableIterator rs = new ExtendableIterator();
        if (query.limit() == 0L && !query.noLimit()) {
            LOG.debug("Return empty result(limit=0) for query {}", (Object)query);
            return rs;
        }
        List<StringBuilder> selections = this.query2Select(this.table(), query);
        try {
            for (StringBuilder selection : selections) {
                ResultSetWrapper results = session.select(selection.toString());
                rs.extend(parser.apply(query, results));
            }
        }
        catch (SQLException e) {
            try {
                rs.close();
            }
            catch (Exception e2) {
                LOG.error("Got error {} when closing iterator for query {}", (Object)e2, (Object)query);
            }
            throw new BackendException("Failed to query [%s]", (Throwable)e, new Object[]{query});
        }
        LOG.debug("Return {} for query {}", (Object)rs, (Object)query);
        return rs;
    }

    protected List<StringBuilder> query2Select(String table, Query query) {
        List<StringBuilder> selections;
        StringBuilder select = new StringBuilder(64);
        select.append("SELECT ");
        Aggregate aggregate = query.aggregate();
        if (aggregate != null) {
            select.append(aggregate);
        } else {
            select.append("*");
        }
        select.append(" FROM ").append(table);
        List<StringBuilder> ids = this.queryId2Select(query, select);
        if (query.conditionsSize() == 0) {
            LOG.debug("Query only by id(s): {}", ids);
            selections = ids;
        } else {
            ConditionQuery condQuery = (ConditionQuery)query;
            if (condQuery.containsScanRelation()) {
                assert (ids.size() == 1);
                return ImmutableList.of((Object)this.queryByRange(condQuery, ids.get(0)));
            }
            selections = new ArrayList<StringBuilder>(ids.size());
            for (StringBuilder selection : ids) {
                selections.addAll(this.queryCondition2Select(query, selection));
            }
            LOG.debug("Query by conditions: {}", selections);
        }
        for (StringBuilder selection : selections) {
            boolean hasOrder;
            boolean bl = hasOrder = !query.orders().isEmpty();
            if (hasOrder) {
                this.wrapOrderBy(selection, query);
            }
            if (query.paging()) {
                this.wrapPage(selection, query, false);
                this.wrapLimit(selection, query);
                continue;
            }
            if (aggregate == null && !hasOrder) {
                select.append(this.orderByKeys());
            }
            if (query.noLimit() && query.offset() <= 0L) continue;
            this.wrapOffset(selection, query);
        }
        return selections;
    }

    protected StringBuilder queryByRange(ConditionQuery query, StringBuilder select) {
        E.checkArgument((query.relations().size() == 1 ? 1 : 0) != 0, (String)"Invalid scan with multi conditions: %s", (Object[])new Object[]{query});
        Condition.Relation scan = (Condition.Relation)query.relations().iterator().next();
        Shard shard = (Shard)scan.value();
        String page = query.page();
        if ("".equals(shard.start()) && "".equals(shard.end()) && (page == null || page.isEmpty())) {
            this.wrapLimit(select, (Query)query);
            return select;
        }
        HugeKeys partitionKey = this.idColumnName().get(0);
        if (page != null && !page.isEmpty()) {
            this.wrapPage(select, (Query)query, true);
            WhereBuilder where = this.newWhereBuilder(false);
            if (!"".equals(shard.end())) {
                where.and();
                where.lt(MysqlTable.formatKey(partitionKey), shard.end());
            }
            select.append((CharSequence)where.build());
        } else {
            WhereBuilder where = this.newWhereBuilder();
            boolean hasStart = false;
            if (!"".equals(shard.start())) {
                where.gte(MysqlTable.formatKey(partitionKey), shard.start());
                hasStart = true;
            }
            if (!"".equals(shard.end())) {
                if (hasStart) {
                    where.and();
                }
                where.lt(MysqlTable.formatKey(partitionKey), shard.end());
            }
            select.append((CharSequence)where.build());
        }
        this.wrapLimit(select, (Query)query);
        return select;
    }

    protected List<StringBuilder> queryId2Select(Query query, StringBuilder select) {
        if (query.idsSize() == 0) {
            return ImmutableList.of((Object)select);
        }
        List<HugeKeys> nameParts = this.idColumnName();
        ArrayList<List<Object>> ids = new ArrayList<List<Object>>(query.idsSize());
        for (Object id : query.ids()) {
            List<Object> list = this.idColumnValue((Id)id);
            if (nameParts.size() != list.size()) {
                throw new NotFoundException("Unsupported ID format: '%s' (should contain %s)", new Object[]{id, nameParts});
            }
            ids.add(list);
        }
        if (nameParts.size() == 1) {
            ArrayList<Object> values = new ArrayList<Object>(ids.size());
            for (List list : ids) {
                assert (list.size() == 1);
                values.add(list.get(0));
            }
            WhereBuilder where = this.newWhereBuilder();
            where.in(MysqlTable.formatKey(nameParts.get(0)), values);
            select.append((CharSequence)where.build());
            return ImmutableList.of((Object)select);
        }
        ArrayList<StringBuilder> selections = new ArrayList<StringBuilder>(ids.size());
        for (List list : ids) {
            assert (nameParts.size() == list.size());
            StringBuilder idSelection = new StringBuilder(select);
            WhereBuilder where = this.newWhereBuilder();
            where.and(MysqlTable.formatKeys(nameParts), list);
            idSelection.append((CharSequence)where.build());
            selections.add(idSelection);
        }
        return selections;
    }

    protected List<StringBuilder> queryCondition2Select(Query query, StringBuilder select) {
        Collection conditions = query.conditions();
        ArrayList<StringBuilder> clauses = new ArrayList<StringBuilder>(conditions.size());
        for (Condition condition : conditions) {
            clauses.add(this.condition2Sql(condition));
        }
        WhereBuilder where = this.newWhereBuilder();
        where.and(clauses);
        select.append((CharSequence)where.build());
        return ImmutableList.of((Object)select);
    }

    protected StringBuilder condition2Sql(Condition condition) {
        switch (condition.type()) {
            case AND: {
                Condition.And and = (Condition.And)condition;
                StringBuilder left = this.condition2Sql(and.left());
                StringBuilder right = this.condition2Sql(and.right());
                int size = left.length() + right.length() + " AND ".length();
                StringBuilder sql = new StringBuilder(size);
                sql.append((CharSequence)left).append(" AND ").append((CharSequence)right);
                return sql;
            }
            case OR: {
                throw new BackendException("Not support OR currently");
            }
            case RELATION: {
                Condition.Relation r = (Condition.Relation)condition;
                return this.relation2Sql(r);
            }
        }
        String msg = "Unsupported condition: " + condition;
        throw new AssertionError((Object)msg);
    }

    protected StringBuilder relation2Sql(Condition.Relation relation) {
        String key = relation.serialKey().toString();
        Object value = relation.serialValue();
        WhereBuilder sql = this.newWhereBuilder(false);
        sql.relation(key, relation.relation(), value);
        return sql.build();
    }

    protected WhereBuilder newWhereBuilder() {
        return this.newWhereBuilder(true);
    }

    protected WhereBuilder newWhereBuilder(boolean startWithWhere) {
        return new WhereBuilder(startWithWhere);
    }

    protected void wrapOrderBy(StringBuilder select, Query query) {
        int size = query.orders().size();
        assert (size > 0);
        int i = 0;
        select.append(" ORDER BY ");
        for (Map.Entry order : query.orders().entrySet()) {
            String key = MysqlTable.formatKey((HugeKeys)order.getKey());
            Query.Order value = (Query.Order)order.getValue();
            select.append(key).append(" ");
            if (value == Query.Order.ASC) {
                select.append("ASC");
            } else {
                assert (value == Query.Order.DESC);
                select.append("DESC");
            }
            if (++i == size) continue;
            select.append(", ");
        }
    }

    protected void wrapPage(StringBuilder select, Query query, boolean scan) {
        String page = query.page();
        if (!page.isEmpty()) {
            byte[] position = PageState.fromString((String)page).position();
            Map<HugeKeys, Object> columns = MysqlEntryIterator.PagePosition.fromBytes(position).columns();
            List<HugeKeys> idColumnNames = this.idColumnName();
            ArrayList<Object> values = new ArrayList<Object>(idColumnNames.size());
            for (HugeKeys key : idColumnNames) {
                values.add(columns.get(key));
            }
            boolean expectWhere = scan || query.conditionsSize() == 0;
            WhereBuilder where = this.newWhereBuilder(expectWhere);
            if (!expectWhere) {
                where.and();
            }
            where.gte(MysqlTable.formatKeys(idColumnNames), values);
            select.append((CharSequence)where.build());
        }
    }

    private void wrapLimit(StringBuilder select, Query query) {
        select.append(this.orderByKeys());
        if (!query.noLimit()) {
            select.append(" limit ");
            select.append(query.limit() + 1L);
        }
        select.append(";");
    }

    protected String orderByKeys() {
        return "";
    }

    protected void wrapOffset(StringBuilder select, Query query) {
        assert (query.limit() >= 0L);
        assert (query.offset() >= 0L);
        select.append(" limit ");
        select.append(query.limit());
        select.append(" offset ");
        select.append(query.offset());
        select.append(";");
        query.goOffset(query.offset());
    }

    protected Iterator<BackendEntry> results2Entries(Query query, ResultSetWrapper results) {
        return new MysqlEntryIterator(results, query, this::mergeEntries);
    }

    protected BackendEntry mergeEntries(BackendEntry e1, BackendEntry e2) {
        return e2;
    }

    public static String formatKey(HugeKeys key) {
        return key.name();
    }

    public static HugeKeys parseKey(String name) {
        return HugeKeys.valueOf((String)name.toUpperCase());
    }

    public static List<String> formatKeys(List<HugeKeys> keys) {
        ArrayList<String> names = new ArrayList<String>(keys.size());
        for (HugeKeys key : keys) {
            names.add(MysqlTable.formatKey(key));
        }
        return names;
    }

    private static class MysqlShardSplitter
    extends BackendTable.ShardSplitter<MysqlSessions.Session> {
        private static final String BASE64 = "0123456789=?ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        private static final int COUNT = 64;

        public MysqlShardSplitter(String table) {
            super(table);
        }

        public List<Shard> getSplits(MysqlSessions.Session session, long splitSize) {
            E.checkArgument((splitSize >= 0x100000L ? 1 : 0) != 0, (String)"The split-size must be >= %s bytes, but got %s", (Object[])new Object[]{0x100000, splitSize});
            ArrayList<Shard> splits = new ArrayList<Shard>(64);
            splits.add(new Shard("", BASE64.substring(0, 1), 0L));
            for (int i = 0; i < 63; ++i) {
                splits.add(new Shard(BASE64.substring(i, i + 1), BASE64.substring(i + 1, i + 2), 0L));
            }
            splits.add(new Shard(BASE64.substring(63, 64), "", 0L));
            return splits;
        }

        protected long estimateDataSize(MysqlSessions.Session session) {
            return 0L;
        }

        protected long estimateNumKeys(MysqlSessions.Session session) {
            return 0L;
        }
    }
}

