/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.mysql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hugegraph.backend.BackendException;

public class ResultSetWrapper
implements AutoCloseable {
    private final ResultSet resultSet;
    private final Statement statement;

    public ResultSetWrapper(ResultSet resultSet, Statement statement) {
        this.resultSet = resultSet;
        this.statement = statement;
    }

    public boolean next() throws SQLException {
        return !this.resultSet.isClosed() && this.resultSet.next();
    }

    @Override
    public void close() {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (SQLException e) {
            throw new BackendException("Failed to close ResultSet", (Throwable)e);
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {
                throw new BackendException("Failed to close Statement", (Throwable)e);
            }
        }
    }

    public ResultSet resultSet() {
        return this.resultSet;
    }
}

