/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.rocksdb;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendSession;
import org.apache.hugegraph.backend.store.BackendSessionPool;
import org.apache.hugegraph.config.HugeConfig;
import org.rocksdb.RocksDBException;

public abstract class RocksDBSessions
extends BackendSessionPool {
    public RocksDBSessions(HugeConfig config, String database, String store) {
        super(config, database + "/" + store);
    }

    public abstract Set<String> openedTables();

    public abstract void createTable(String ... var1) throws RocksDBException;

    public abstract void dropTable(String ... var1) throws RocksDBException;

    public abstract boolean existsTable(String var1);

    public abstract List<String> property(String var1);

    public abstract void compactRange();

    public abstract RocksDBSessions copy(HugeConfig var1, String var2, String var3);

    public abstract void createSnapshot(String var1);

    public abstract void resumeSnapshot(String var1);

    public abstract String buildSnapshotPath(String var1);

    public abstract String hardLinkSnapshot(String var1) throws RocksDBException;

    public abstract void reloadRocksDB() throws RocksDBException;

    public abstract void forceCloseRocksDB();

    public abstract Session session();

    public static interface Countable {
        public long count();
    }

    public static abstract class Session
    extends BackendSession.AbstractBackendSession {
        public static final int SCAN_ANY = 128;
        public static final int SCAN_PREFIX_BEGIN = 1;
        public static final int SCAN_PREFIX_END = 2;
        public static final int SCAN_GT_BEGIN = 4;
        public static final int SCAN_GTE_BEGIN = 12;
        public static final int SCAN_LT_END = 16;
        public static final int SCAN_LTE_END = 48;

        public abstract String dataPath();

        public abstract String walPath();

        public abstract String property(String var1, String var2);

        public abstract Pair<byte[], byte[]> keyRange(String var1);

        public abstract void compactRange(String var1);

        public abstract void put(String var1, byte[] var2, byte[] var3);

        public abstract void merge(String var1, byte[] var2, byte[] var3);

        public abstract void increase(String var1, byte[] var2, byte[] var3);

        public abstract void delete(String var1, byte[] var2);

        public abstract void deleteSingle(String var1, byte[] var2);

        public abstract void deletePrefix(String var1, byte[] var2);

        public abstract void deleteRange(String var1, byte[] var2, byte[] var3);

        public abstract byte[] get(String var1, byte[] var2);

        public abstract BackendEntry.BackendColumnIterator get(String var1, List<byte[]> var2);

        public abstract BackendEntry.BackendColumnIterator scan(String var1);

        public abstract BackendEntry.BackendColumnIterator scan(String var1, byte[] var2);

        public abstract BackendEntry.BackendColumnIterator scan(String var1, byte[] var2, byte[] var3, int var4);

        public BackendEntry.BackendColumnIterator scan(String table, byte[] keyFrom, byte[] keyTo) {
            return this.scan(table, keyFrom, keyTo, 16);
        }

        public static boolean matchScanType(int expected, int actual) {
            return (expected & actual) == expected;
        }
    }
}

