/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.rocksdb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.List;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.serializer.BinarySerializer;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBSessions;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBTable;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.StringEncoding;

public class RocksDBTables {

    public static class OlapRangeDoubleIndex
    extends RangeDoubleIndex {
        public static final String TABLE = HugeType.OLAP.string();

        public OlapRangeDoubleIndex(String store) {
            this(store, TABLE);
        }

        protected OlapRangeDoubleIndex(String store, String table) {
            super(OlapRangeDoubleIndex.joinTableName((String)store, (String)table));
        }
    }

    public static class OlapRangeFloatIndex
    extends RangeFloatIndex {
        public static final String TABLE = HugeType.OLAP.string();

        public OlapRangeFloatIndex(String store) {
            this(store, TABLE);
        }

        protected OlapRangeFloatIndex(String store, String table) {
            super(OlapRangeFloatIndex.joinTableName((String)store, (String)table));
        }
    }

    public static class OlapRangeLongIndex
    extends RangeLongIndex {
        public static final String TABLE = HugeType.OLAP.string();

        public OlapRangeLongIndex(String store) {
            this(store, TABLE);
        }

        protected OlapRangeLongIndex(String store, String table) {
            super(OlapRangeLongIndex.joinTableName((String)store, (String)table));
        }
    }

    public static class OlapRangeIntIndex
    extends RangeIntIndex {
        public static final String TABLE = HugeType.OLAP.string();

        public OlapRangeIntIndex(String store) {
            this(store, TABLE);
        }

        protected OlapRangeIntIndex(String store, String table) {
            super(OlapRangeIntIndex.joinTableName((String)store, (String)table));
        }
    }

    public static class OlapSecondaryIndex
    extends SecondaryIndex {
        public static final String TABLE = HugeType.OLAP.string();

        public OlapSecondaryIndex(String store) {
            this(store, TABLE);
        }

        protected OlapSecondaryIndex(String store, String table) {
            super(OlapSecondaryIndex.joinTableName((String)store, (String)table));
        }
    }

    public static class OlapTable
    extends RocksDBTable {
        public static final String TABLE = HugeType.OLAP.string();

        public OlapTable(String database, Id id) {
            super(database, OlapTable.joinTableName((String)TABLE, (String)id.asString()));
        }

        @Override
        protected BackendEntry.BackendColumnIterator queryById(RocksDBSessions.Session session, Id id) {
            return this.getById(session, id);
        }

        @Override
        public boolean isOlap() {
            return true;
        }
    }

    public static class ShardIndex
    extends RangeIndex {
        public static final String TABLE = HugeType.SHARD_INDEX.string();

        public ShardIndex(String database) {
            super(database, TABLE);
        }
    }

    public static class RangeDoubleIndex
    extends RangeIndex {
        public static final String TABLE = HugeType.RANGE_DOUBLE_INDEX.string();

        public RangeDoubleIndex(String store) {
            super(store, TABLE);
        }
    }

    public static class RangeLongIndex
    extends RangeIndex {
        public static final String TABLE = HugeType.RANGE_LONG_INDEX.string();

        public RangeLongIndex(String store) {
            super(store, TABLE);
        }
    }

    public static class RangeFloatIndex
    extends RangeIndex {
        public static final String TABLE = HugeType.RANGE_FLOAT_INDEX.string();

        public RangeFloatIndex(String store) {
            super(store, TABLE);
        }
    }

    public static class RangeIntIndex
    extends RangeIndex {
        public static final String TABLE = HugeType.RANGE_INT_INDEX.string();

        public RangeIntIndex(String store) {
            super(store, TABLE);
        }
    }

    public static class RangeIndex
    extends IndexTable {
        public RangeIndex(String database, String table) {
            super(database, table);
        }

        @Override
        protected BackendEntry.BackendColumnIterator queryByCond(RocksDBSessions.Session session, ConditionQuery query) {
            assert (query.conditionsSize() > 0);
            List conds = query.syspropConditions(HugeKeys.ID);
            E.checkArgument((!conds.isEmpty() ? 1 : 0) != 0, (String)"Please specify the index conditions", (Object[])new Object[0]);
            Id prefix = null;
            Id min = null;
            boolean minEq = false;
            Id max = null;
            boolean maxEq = false;
            block7: for (Condition c : conds) {
                Condition.Relation r = (Condition.Relation)c;
                switch (r.relation()) {
                    case PREFIX: {
                        prefix = (Id)r.value();
                        continue block7;
                    }
                    case GTE: {
                        minEq = true;
                        min = (Id)r.value();
                        continue block7;
                    }
                    case GT: {
                        min = (Id)r.value();
                        continue block7;
                    }
                    case LTE: {
                        maxEq = true;
                        max = (Id)r.value();
                        continue block7;
                    }
                    case LT: {
                        max = (Id)r.value();
                        continue block7;
                    }
                }
                E.checkArgument((boolean)false, (String)"Unsupported relation '%s'", (Object[])new Object[]{r.relation()});
            }
            E.checkArgumentNotNull(min, (String)"Range index begin key is missing", (Object[])new Object[0]);
            byte[] begin = min.asBytes();
            if (!minEq) {
                BinarySerializer.increaseOne((byte[])begin);
            }
            if (max == null) {
                E.checkArgumentNotNull((Object)prefix, (String)"Range index prefix is missing", (Object[])new Object[0]);
                return session.scan(this.table(), begin, prefix.asBytes(), 2);
            }
            byte[] end = max.asBytes();
            int type = maxEq ? 48 : 16;
            return session.scan(this.table(), begin, end, type);
        }
    }

    public static class UniqueIndex
    extends IndexTable {
        public static final String TABLE = HugeType.UNIQUE_INDEX.string();

        public UniqueIndex(String database) {
            super(database, TABLE);
        }
    }

    public static class SearchIndex
    extends IndexTable {
        public static final String TABLE = HugeType.SEARCH_INDEX.string();

        public SearchIndex(String database) {
            super(database, TABLE);
        }
    }

    public static class EdgeLabelIndex
    extends IndexTable {
        public static final String TABLE = HugeType.EDGE_LABEL_INDEX.string();

        public EdgeLabelIndex(String database) {
            super(database, TABLE);
        }
    }

    public static class VertexLabelIndex
    extends IndexTable {
        public static final String TABLE = HugeType.VERTEX_LABEL_INDEX.string();

        public VertexLabelIndex(String database) {
            super(database, TABLE);
        }
    }

    public static class SecondaryIndex
    extends IndexTable {
        public static final String TABLE = HugeType.SECONDARY_INDEX.string();

        public SecondaryIndex(String database) {
            super(database, TABLE);
        }
    }

    public static class IndexTable
    extends RocksDBTable {
        public IndexTable(String database, String table) {
            super(database, table);
        }

        @Override
        public void eliminate(RocksDBSessions.Session session, BackendEntry entry) {
            assert (entry.columns().size() == 1);
            super.delete(session, entry);
        }

        @Override
        public void delete(RocksDBSessions.Session session, BackendEntry entry) {
            for (BackendEntry.BackendColumn column : entry.columns()) {
                session.deletePrefix(this.table(), column.name);
            }
        }
    }

    public static class Edge
    extends RocksDBTable {
        public static final String TABLE_SUFFIX = HugeType.EDGE.string();

        public Edge(boolean out, String database) {
            super(database, (out ? (char)'o' : 'i') + TABLE_SUFFIX);
        }

        public static Edge out(String database) {
            return new Edge(true, database);
        }

        public static Edge in(String database) {
            return new Edge(false, database);
        }

        @Override
        protected BackendEntry.BackendColumnIterator queryById(RocksDBSessions.Session session, Id id) {
            return this.getById(session, id);
        }
    }

    public static class Vertex
    extends RocksDBTable {
        public static final String TABLE = HugeType.VERTEX.string();

        public Vertex(String database) {
            super(database, TABLE);
        }

        @Override
        protected BackendEntry.BackendColumnIterator queryById(RocksDBSessions.Session session, Id id) {
            return this.getById(session, id);
        }

        @Override
        protected BackendEntry.BackendColumnIterator queryByIds(RocksDBSessions.Session session, Collection<Id> ids) {
            return super.queryByIds(session, ids);
        }
    }

    public static class IndexLabel
    extends SchemaTable {
        public static final String TABLE = HugeType.INDEX_LABEL.string();

        public IndexLabel(String database) {
            super(database, TABLE);
        }
    }

    public static class PropertyKey
    extends SchemaTable {
        public static final String TABLE = HugeType.PROPERTY_KEY.string();

        public PropertyKey(String database) {
            super(database, TABLE);
        }
    }

    public static class EdgeLabel
    extends SchemaTable {
        public static final String TABLE = HugeType.EDGE_LABEL.string();

        public EdgeLabel(String database) {
            super(database, TABLE);
        }
    }

    public static class VertexLabel
    extends SchemaTable {
        public static final String TABLE = HugeType.VERTEX_LABEL.string();

        public VertexLabel(String database) {
            super(database, TABLE);
        }
    }

    public static class SchemaTable
    extends RocksDBTable {
        public SchemaTable(String database, String table) {
            super(database, table);
        }

        @Override
        public void delete(RocksDBSessions.Session session, BackendEntry entry) {
            assert (entry.columns().isEmpty());
            byte[] prefix = entry.id().asBytes();
            try (BackendEntry.BackendColumnIterator results = session.scan(this.table(), prefix);){
                while (results.hasNext()) {
                    byte[] column = ((BackendEntry.BackendColumn)results.next()).name;
                    session.delete(this.table(), column);
                }
                session.commit();
            }
        }
    }

    public static class Counters
    extends RocksDBTable {
        private static final String TABLE = HugeType.COUNTER.string();

        public Counters(String database) {
            super(database, TABLE);
        }

        public long getCounter(RocksDBSessions.Session session, HugeType type) {
            byte[] key = new byte[]{type.code()};
            byte[] value = session.get(this.table(), key);
            if (value != null) {
                return Counters.toLong(value);
            }
            return 0L;
        }

        public void increaseCounter(RocksDBSessions.Session session, HugeType type, long increment) {
            byte[] key = new byte[]{type.code()};
            session.increase(this.table(), key, Counters.toBytes(increment));
        }

        private static byte[] toBytes(long value) {
            return ByteBuffer.allocate(8).order(ByteOrder.nativeOrder()).putLong(value).array();
        }

        private static long toLong(byte[] bytes) {
            assert (bytes.length == 8);
            return ByteBuffer.wrap(bytes).order(ByteOrder.nativeOrder()).getLong();
        }
    }

    public static class Meta
    extends RocksDBTable {
        private static final String TABLE = HugeType.META.string();

        public Meta(String database) {
            super(database, TABLE);
        }

        public void writeVersion(RocksDBSessions.Session session, String version) {
            byte[] key = new byte[]{HugeKeys.VERSION.code()};
            byte[] value = StringEncoding.encode((String)version);
            session.put(this.table(), key, value);
            try {
                session.commit();
            }
            catch (Exception e) {
                session.rollback();
                throw e;
            }
        }

        public String readVersion(RocksDBSessions.Session session) {
            byte[] key = new byte[]{HugeKeys.VERSION.code()};
            byte[] value = session.get(this.table(), key);
            if (value == null) {
                return null;
            }
            return StringEncoding.decode((byte[])value);
        }
    }
}

