/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics.flame;

import java.util.Comparator;
import org.gridkit.jvmtool.stacktrace.GenericStackElement;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.analytics.WeigthCalculator;
import org.gridkit.jvmtool.stacktrace.analytics.flame.GenericFlameGraphGenerator;

public class FlameGraphGenerator
extends GenericFlameGraphGenerator {
    private static final FrameComparator FRAME_COMPARATOR = new FrameComparator();

    public FlameGraphGenerator() {
    }

    public FlameGraphGenerator(WeigthCalculator calculator) {
        super(calculator);
    }

    @Override
    protected Comparator<GenericStackElement> comparator() {
        return FRAME_COMPARATOR;
    }

    @Override
    protected String describe(GenericFlameGraphGenerator.Node node) {
        StackFrame frame = (StackFrame)node.path[node.path.length - 1];
        String line = frame.getClassName() + "." + frame.getMethodName();
        line = line.replace("<", "&lt;");
        line = line.replace(">", "&gt;");
        return line;
    }

    private static class FrameComparator
    implements Comparator<StackFrame> {
        private FrameComparator() {
        }

        @Override
        public int compare(StackFrame o1, StackFrame o2) {
            int n = this.compare(o1.getClassName(), o2.getClassName());
            if (n != 0) {
                return n;
            }
            n = this.compare(o1.getLineNumber(), o2.getLineNumber());
            if (n != 0) {
                return n;
            }
            n = this.compare(o1.getMethodName(), o2.getMethodName());
            if (n != 0) {
                return n;
            }
            n = this.compare(o1.getSourceFile(), o2.getSourceFile());
            return 0;
        }

        @Override
        private int compare(int n1, int n2) {
            return Long.signum((long)n1 - (long)n2);
        }

        @Override
        private int compare(String str1, String str2) {
            if (str1 == str2) {
                return 0;
            }
            if (str1 == null) {
                return -1;
            }
            if (str2 == null) {
                return 1;
            }
            return str1.compareTo(str2);
        }
    }
}

