/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.viterbi;

import java.util.LinkedList;
import java.util.List;
import org.nlpcn.commons.lang.viterbi.Node;
import org.nlpcn.commons.lang.viterbi.function.Score;
import org.nlpcn.commons.lang.viterbi.function.Values;

public class Viterbi<T> {
    private static final Node[] EMPTY = new Node[0];
    private Node[][] graph;

    public Viterbi(T[][] objGraph, Values<T> fun) {
        this.graph = new Node[objGraph.length][];
        for (int i = 0; i < objGraph.length; ++i) {
            T[] arr = objGraph[i];
            if (arr == null) continue;
            this.graph[i] = new Node[arr.length];
            for (int j = 0; j < arr.length; ++j) {
                if (arr[j] == null) continue;
                this.graph[i][j] = new Node<T>(i, arr[j], fun);
                if (i != 0) continue;
                this.graph[i][j].setScore(this.graph[i][j].getSelfScore());
            }
        }
    }

    public Viterbi(List<T>[] objGraph, Values<T> fun) {
        this.graph = new Node[objGraph.length][];
        for (int i = 0; i < objGraph.length; ++i) {
            List<T> list = objGraph[i];
            this.graph[i] = new Node[list.size()];
            for (int j = 0; j < list.size(); ++j) {
                this.graph[i][j] = new Node<T>(i, list.get(j), fun);
                if (i != 0) continue;
                this.graph[i][j].setScore(this.graph[i][j].getSelfScore());
            }
        }
    }

    public List<T> compute(Score score) {
        Node[] arr = null;
        Node[] toArr = null;
        Node from = null;
        Node to = null;
        Double newScore = null;
        for (int i = 0; i < this.graph.length - 1; ++i) {
            arr = this.graph[i];
            for (int j = 0; j < arr.length; ++j) {
                from = arr[j];
                if (from == null || from.getToIndex() >= this.graph.length) continue;
                toArr = this.graph[from.getToIndex()];
                for (int k = 0; k < toArr.length; ++k) {
                    to = toArr[k];
                    if (to == null || (newScore = score.score(from, to)) == null || to.getScore() != null && newScore > to.getScore() != score.sort()) continue;
                    to.setScore(newScore);
                    to.setFrom(from);
                }
            }
        }
        LinkedList result = new LinkedList();
        Node[] nodes = this.graph[this.graph.length - 1];
        int maxIndex = 0;
        double maxScore = score.sort() ? -1.7976931348623157E308 : Double.MAX_VALUE;
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] == null || nodes[i].getScore() == null || nodes[i].getScore() > maxScore != score.sort()) continue;
            maxScore = nodes[i].getScore();
            maxIndex = i;
        }
        Node node = this.graph[this.graph.length - 1][maxIndex];
        result.add(node.getObj());
        while ((node = node.getFrom()) != null) {
            result.addFirst(node.getObj());
        }
        return result;
    }

    public Viterbi<T> printScore() {
        for (Node[] nodes : this.graph) {
            if (nodes == null) continue;
            for (Node node : nodes) {
                if (node == null) {
                    System.out.print("null");
                } else {
                    System.out.print(node.getScore());
                }
                System.out.print("\t");
            }
            System.out.println();
        }
        return this;
    }

    public void print() {
        for (Node[] nodes : this.graph) {
            if (nodes == null) continue;
            for (Node node : nodes) {
                if (node == null) {
                    System.out.print("null");
                } else {
                    System.out.print(node.getObj());
                }
                System.out.print("\t");
            }
            System.out.println();
        }
    }

    public Viterbi<T> rmLittlePath() {
        for (int i = 0; i < this.graph.length; ++i) {
            int j;
            Node[] nodes = this.graph[i];
            int maxIndex = -1;
            Node maxNode = null;
            for (int j2 = 0; j2 < nodes.length; ++j2) {
                if (maxIndex >= nodes[j2].getToIndex()) continue;
                maxNode = nodes[j2];
                maxIndex = Math.min(maxNode.getToIndex(), this.graph.length - 1);
            }
            boolean flag = true;
            block2: for (j = i + 1; j < maxIndex; ++j) {
                Node[] tempNodes;
                for (Node node : tempNodes = this.graph[j]) {
                    if (node.getToIndex() <= maxIndex) continue;
                    flag = false;
                    break block2;
                }
            }
            if (flag) {
                for (j = i + 1; j < maxIndex; ++j) {
                    this.graph[j] = EMPTY;
                }
            }
            i = Math.max(i, maxIndex);
        }
        return this;
    }

    public void printSelfScore() {
        for (Node[] nodes : this.graph) {
            if (nodes == null) continue;
            for (Node node : nodes) {
                if (node == null) {
                    System.out.print("null");
                } else {
                    System.out.print(node.getSelfScore());
                }
                System.out.print("\t");
            }
            System.out.println();
        }
    }
}

