/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.api;

import com.alipay.lookout.api.Clock;
import com.alipay.lookout.api.DefaultId;
import com.alipay.lookout.api.Id;
import com.alipay.lookout.api.Registry;
import com.alipay.lookout.api.Tag;
import com.alipay.lookout.api.TagSet;
import java.util.Map;

public abstract class MetricRegistry
implements Registry {
    private boolean propagateWarnings = true;
    private final Clock clock;

    public MetricRegistry(Clock clock) {
        this.clock = clock;
    }

    public abstract void registerExtendedMetrics();

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public final Id createId(String name) {
        return new DefaultId(name);
    }

    @Override
    public final Id createId(String name, Iterable<Tag> tags) {
        return new DefaultId(name, TagSet.create(tags));
    }

    @Override
    public final Id createId(String name, Map<String, String> tags) {
        return this.createId(name).withTags(tags);
    }

    @Override
    public void propagate(String msg, Throwable t) {
        if (this.propagateWarnings) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    protected void propagate(Throwable t) {
        this.propagate(t.getMessage(), t);
    }
}

