/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.service.PDService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PDMetrics {
    private static final Logger log = LoggerFactory.getLogger(PDMetrics.class);
    public static final String PREFIX = "hg";
    private static final AtomicLong GRAPHS = new AtomicLong(0L);
    private MeterRegistry registry;
    @Autowired
    private PDService pdService;

    public synchronized void init(MeterRegistry meterRegistry) {
        if (this.registry == null) {
            this.registry = meterRegistry;
            this.registerMeters();
        }
    }

    private void registerMeters() {
        Gauge.builder((String)"hg.up", () -> 1).register(this.registry);
        Gauge.builder((String)"hg.graphs", () -> this.updateGraphs()).description("Number of graphs registered in PD").register(this.registry);
        Gauge.builder((String)"hg.stores", () -> this.updateStores()).description("Number of stores registered in PD").register(this.registry);
    }

    private long updateGraphs() {
        long buf = this.getGraphs();
        if (buf != GRAPHS.get()) {
            GRAPHS.set(buf);
            this.registerGraphMetrics();
        }
        return buf;
    }

    private long updateStores() {
        return this.getStores();
    }

    private long getGraphs() {
        return this.getGraphMetas().size();
    }

    private long getStores() {
        try {
            return this.pdService.getStoreNodeService().getStores(null).size();
        }
        catch (PDException e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return 0L;
        }
    }

    private List<Metapb.Graph> getGraphMetas() {
        try {
            return this.pdService.getPartitionService().getGraphs();
        }
        catch (PDException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    private void registerGraphMetrics() {
        this.getGraphMetas().forEach(meta -> Gauge.builder((String)"hg.partitions", (Object)this.pdService.getPartitionService(), e -> e.getPartitions(meta.getGraphName()).size()).description("Number of partitions assigned to a graph").tag("graph", meta.getGraphName()).register(this.registry));
    }
}

