/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.rest;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.apache.hugegraph.pd.model.RestApiResponse;
import org.apache.hugegraph.pd.model.StoreRestRequest;
import org.apache.hugegraph.pd.model.TimeRangeRequest;
import org.apache.hugegraph.pd.rest.API;
import org.apache.hugegraph.pd.rest.StoreAPI;
import org.apache.hugegraph.pd.service.PDRestService;
import org.apache.hugegraph.pd.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1"})
public class StoreAPI
extends API {
    private static final Logger log = LoggerFactory.getLogger(StoreAPI.class);
    @Autowired
    PDRestService pdRestService;

    @GetMapping(value={"/stores"}, produces={"application/json"})
    @ResponseBody
    public RestApiResponse getStores() {
        ArrayList<StoreStatistics> storeStatsList = new ArrayList<StoreStatistics>();
        try {
            HashMap<String, Serializable> dataMap = new HashMap<String, Serializable>();
            HashMap<String, Integer> stateCountMap = new HashMap<String, Integer>();
            for (Metapb.Store store : this.pdRestService.getStores("")) {
                String stateKey = store.getState().name();
                stateCountMap.put(stateKey, stateCountMap.getOrDefault(stateKey, 0) + 1);
                storeStatsList.add(new StoreStatistics(this, store));
            }
            storeStatsList.sort((o1, o2) -> o1.address.compareTo(o2.address));
            dataMap.put("stores", storeStatsList);
            dataMap.put("numOfService", Integer.valueOf(storeStatsList.size()));
            dataMap.put("numOfNormalService", stateCountMap.getOrDefault(Metapb.StoreState.Up.name(), 0));
            dataMap.put("stateCountMap", stateCountMap);
            return new RestApiResponse(dataMap, Pdpb.ErrorType.OK, Pdpb.ErrorType.OK.name());
        }
        catch (PDException e) {
            log.error("PDException", (Throwable)e);
            return new RestApiResponse(null, e.getErrorCode(), e.getMessage());
        }
    }

    @PostMapping(value={"/store/{storeId}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public String setStore(@PathVariable long storeId, @RequestBody StoreRestRequest request) {
        try {
            Metapb.Store lastStore = this.pdRestService.getStore(storeId);
            if (lastStore != null) {
                Metapb.Store.Builder builder = Metapb.Store.newBuilder((Metapb.Store)lastStore);
                Metapb.StoreState storeState = Metapb.StoreState.valueOf((String)request.getStoreState());
                builder.setState(storeState);
                Metapb.Store newStore = this.pdRestService.updateStore(builder.build());
                return this.toJSON((MessageOrBuilder)newStore, "store");
            }
            return this.toJSON(new PDException(103, "error"));
        }
        catch (PDException e) {
            return this.toJSON(e);
        }
    }

    @GetMapping(value={"/shardGroups"}, produces={"application/json"})
    @ResponseBody
    public String getShardGroups() {
        try {
            return this.toJSON(this.pdRestService.getShardGroups(), "shardGroups");
        }
        catch (PDException e) {
            return this.toJSON(e);
        }
    }

    @GetMapping(value={"/shardLeaders"})
    public Map<String, List<Integer>> shardLeaders() throws PDException {
        HashMap<String, List<Integer>> leaders = new HashMap<String, List<Integer>>();
        List groups = this.pdRestService.getShardGroups();
        groups.forEach(group -> group.getShardsList().forEach(shard -> {
            if (shard.getRole() == Metapb.ShardRole.Leader) {
                try {
                    String ip = this.pdRestService.getStore(shard.getStoreId()).getRaftAddress();
                    if (!leaders.containsKey(ip)) {
                        leaders.put(ip, new ArrayList());
                    }
                    ((List)leaders.get(ip)).add(group.getId());
                }
                catch (PDException e) {
                    throw new RuntimeException(e);
                }
            }
        }));
        return leaders;
    }

    @GetMapping(value={"/balanceLeaders"})
    public Map<Integer, Long> balanceLeaders() throws PDException {
        return this.pdRestService.balancePartitionLeader();
    }

    @DeleteMapping(value={"/store/{storeId}"})
    public String removeStore(@PathVariable(value="storeId") Long storeId) {
        try {
            this.pdRestService.removeStore(storeId);
        }
        catch (PDException e) {
            return e.getStackTrace().toString();
        }
        return "OK";
    }

    @PostMapping(value={"/store/log"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public String getStoreLog(@RequestBody TimeRangeRequest request) {
        try {
            Date dateStart = DateUtil.getDate((String)request.getStartTime());
            Date dateEnd = DateUtil.getDate((String)request.getEndTime());
            List changedStore = this.pdRestService.getStoreStatusLog(Long.valueOf(dateStart.getTime()), Long.valueOf(dateEnd.getTime()));
            if (changedStore != null) {
                JsonFormat.TypeRegistry registry = JsonFormat.TypeRegistry.newBuilder().add(Metapb.Store.getDescriptor()).build();
                return this.toJSON(changedStore, registry);
            }
            return this.toJSON(new PDException(103, "error"));
        }
        catch (PDException e) {
            return this.toJSON(e);
        }
    }

    @GetMapping(value={"store/{storeId}"}, produces={"application/json"})
    @ResponseBody
    public RestApiResponse getStore(@PathVariable long storeId) {
        Metapb.Store store = null;
        try {
            store = this.pdRestService.getStore(storeId);
        }
        catch (PDException e) {
            return new RestApiResponse(null, e.getErrorCode(), e.getMessage());
        }
        if (store != null) {
            StoreStatistics resultStoreStats = new StoreStatistics(this, store);
            return new RestApiResponse((Object)resultStoreStats, Pdpb.ErrorType.OK, Pdpb.ErrorType.OK.name());
        }
        return new RestApiResponse(null, Pdpb.ErrorType.STORE_ID_NOT_EXIST, Pdpb.ErrorType.STORE_ID_NOT_EXIST.name());
    }

    @GetMapping(value={"storesAndStats"}, produces={"application/json"})
    @ResponseBody
    public String getStoresAndStats() {
        try {
            List stores = this.pdRestService.getStores("");
            return this.toJSON(stores, "stores");
        }
        catch (PDException e) {
            log.error("PD exception:" + e);
            return this.toJSON(e);
        }
    }

    @GetMapping(value={"store_monitor/json/{storeId}"}, produces={"application/json"})
    @ResponseBody
    public RestApiResponse getStoreMonitorData(@PathVariable long storeId) {
        try {
            List result = this.pdRestService.getMonitorData(storeId);
            return new RestApiResponse((Object)result, Pdpb.ErrorType.OK, Pdpb.ErrorType.OK.name());
        }
        catch (PDException e) {
            return new RestApiResponse(null, e.getErrorCode(), e.getMessage());
        }
    }

    @GetMapping(value={"store_monitor/{storeId}"})
    @ResponseBody
    public String getStoreMonitorDataText(@PathVariable long storeId) {
        try {
            return this.pdRestService.getMonitorDataText(storeId);
        }
        catch (PDException e) {
            return "error:" + e.getErrorCode() + e.getMessage();
        }
    }
}

