/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.upgrade.scripts;

import java.util.HashSet;
import java.util.List;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.config.PDConfig;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.meta.MetadataKeyHelper;
import org.apache.hugegraph.pd.meta.MetadataRocksDBStore;
import org.apache.hugegraph.pd.upgrade.VersionUpgradeScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionMetaUpgrade
implements VersionUpgradeScript {
    private static final Logger log = LoggerFactory.getLogger(PartitionMetaUpgrade.class);

    public String getHighVersion() {
        return "3.6.2";
    }

    public String getLowVersion() {
        return "UNLIMITED_VERSION";
    }

    public void runInstruction(PDConfig config) {
        log.info("run PartitionMetaUpgrade script");
        MetadataRocksDBStore dbStore = new MetadataRocksDBStore(config);
        try {
            HashSet<Integer> partSet = new HashSet<Integer>();
            for (Metapb.Graph graph : dbStore.scanPrefix(Metapb.Graph.parser(), MetadataKeyHelper.getGraphPrefix())) {
                byte[] graphPrefix = MetadataKeyHelper.getPartitionPrefix((String)graph.getGraphName());
                for (Metapb.PartitionV36 partition : dbStore.scanPrefix(Metapb.PartitionV36.parser(), graphPrefix)) {
                    Metapb.Partition newPartition = this.trans(partition);
                    int partId = partition.getId();
                    log.info("trans partition structure: from {} to {}", (Object)partition, (Object)newPartition);
                    byte[] key36 = MetadataKeyHelper.getPartitionV36Key((String)graph.getGraphName(), (int)partId);
                    dbStore.put(key36, partition.toByteArray());
                    byte[] key = MetadataKeyHelper.getPartitionKey((String)graph.getGraphName(), (int)partId);
                    dbStore.put(key, newPartition.toByteArray());
                    if (partSet.contains(partId)) continue;
                    byte[] shardGroupKey = MetadataKeyHelper.getShardGroupKey((long)partId);
                    Metapb.ShardGroup shardGroup = (Metapb.ShardGroup)dbStore.getOne(Metapb.ShardGroup.parser(), shardGroupKey);
                    if (shardGroup == null) {
                        List shardList = partition.getShardsList();
                        if (shardList.size() > 0) {
                            shardGroup = Metapb.ShardGroup.newBuilder().setId(partId).setVersion(partition.getVersion()).setConfVer(0L).setState(partition.getState()).addAllShards((Iterable)shardList).build();
                            dbStore.put(shardGroupKey, shardGroup.toByteArray());
                            log.info("extract shard group from partition, {}", (Object)shardGroup);
                        } else {
                            throw new PDException(1000, "trans partition failed, no shard list");
                        }
                    }
                    partSet.add(partId);
                }
            }
        }
        catch (Exception e) {
            log.error("script: {}, run error : {}", (Object)this.getClass().getName(), (Object)e.getMessage());
        }
    }

    public boolean isRunOnce() {
        return true;
    }

    public boolean isRunWithoutDataVersion() {
        return true;
    }

    private Metapb.Partition trans(Metapb.PartitionV36 partition) {
        return Metapb.Partition.newBuilder().setId(partition.getId()).setGraphName(partition.getGraphName()).setStartKey(partition.getStartKey()).setEndKey(partition.getEndKey()).setVersion(partition.getVersion()).setState(partition.getState()).setMessage(partition.getMessage()).build();
    }
}

