/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.watch;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hugegraph.pd.grpc.watch.WatchResponse;
import org.apache.hugegraph.pd.grpc.watch.WatchType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
abstract class AbstractWatchSubject {
    private static final Logger log = LoggerFactory.getLogger(AbstractWatchSubject.class);
    private final Map<Long, StreamObserver<WatchResponse>> watcherHolder = new HashMap(1024);
    private final byte[] lock = new byte[0];
    private final WatchResponse.Builder builder = WatchResponse.newBuilder();
    private final WatchType watchType;

    protected AbstractWatchSubject(WatchType watchType) {
        this.watchType = watchType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addObserver(Long watcherId, StreamObserver<WatchResponse> responseObserver) {
        Map map = this.watcherHolder;
        synchronized (map) {
            if (this.watcherHolder.containsKey(watcherId)) {
                responseObserver.onError((Throwable)new Exception("The watcher-id[" + watcherId + "] of " + this.watchType.name() + " subject has been existing, please unwatch it first"));
                return;
            }
            log.info("Adding a " + this.watchType + "'s watcher, watcher-id is [" + watcherId + "].");
            this.watcherHolder.put(watcherId, responseObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeObserver(Long watcherId, StreamObserver<WatchResponse> responseObserver) {
        Map map = this.watcherHolder;
        synchronized (map) {
            log.info("Removing a " + this.watchType + "'s watcher, watcher-id is [" + watcherId + "].");
            this.watcherHolder.remove(watcherId);
        }
        responseObserver.onCompleted();
    }

    abstract String toNoticeString(WatchResponse var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyError(int code, String message) {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            for (Map.Entry entry : this.watcherHolder.entrySet()) {
                Long watcherId = (Long)entry.getKey();
                WatchResponse res = this.builder.setWatcherId(watcherId.longValue()).build();
                try {
                    ((StreamObserver)entry.getValue()).onError((Throwable)Status.fromCodeValue((int)code).withDescription(message).asRuntimeException());
                }
                catch (Throwable throwable) {}
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void notifyWatcher(WatchResponse.Builder response) {
        Iterator iter = this.watcherHolder.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Long watcherId = (Long)entry.getKey();
            WatchResponse res = response.setWatcherId(watcherId.longValue()).build();
            try {
                byte[] byArray = this.lock;
                // MONITORENTER : this.lock
                ((StreamObserver)entry.getValue()).onNext((Object)res);
                // MONITOREXIT : byArray
            }
            catch (Throwable e) {
                try {
                    String msg = JsonFormat.printer().print((MessageOrBuilder)res);
                    log.error("failed to send to watcher [{}] with notice {} for ", new Object[]{msg, this.toNoticeString(res), watcherId, e});
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyWatcher(Consumer<WatchResponse.Builder> c) {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            if (c == null) {
                log.error(this.watchType.name() + "'s notice was abandoned, caused by: notifyWatcher(null)");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            try {
                c.accept(this.builder.clear());
            }
            catch (Throwable t) {
                log.error(this.watchType.name() + "'s notice was abandoned, caused by:", t);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Iterator iter = this.watcherHolder.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Long watcherId = (Long)entry.getKey();
                WatchResponse res = this.builder.setWatcherId(watcherId.longValue()).build();
                try {
                    ((StreamObserver)entry.getValue()).onNext((Object)res);
                }
                catch (Throwable e) {
                    log.error("Failed to send " + this.watchType.name() + "'s notice[" + this.toNoticeString(res) + "] to watcher[" + watcherId + "].", e);
                    iter.remove();
                    log.error("Removed a " + this.watchType.name() + "'s watcher[" + entry.getKey() + "], because of once failure of sending.", e);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

