/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.analyzer;

import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.analyzer.Analyzer;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cn.smart.SmartChineseAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class SmartCNAnalyzer
implements Analyzer {
    private static final SmartChineseAnalyzer ANALYZER = new SmartChineseAnalyzer();

    public SmartCNAnalyzer(String mode) {
    }

    @Override
    public Set<String> segment(String text) {
        Set result = InsertionOrderUtil.newSet();
        StringReader reader = new StringReader(text);
        try (TokenStream tokenStream = ANALYZER.tokenStream("text", (Reader)reader);){
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                CharTermAttribute term = (CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class);
                result.add(term.toString());
            }
        }
        catch (Exception e) {
            throw new HugeException("SmartCN segment text '%s' failed", (Throwable)e, text);
        }
        return result;
    }
}

