/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.backend.tx.GraphTransaction;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.iterator.MapperIterator;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class EntityManager<T extends SchemaDefine.Entity> {
    private final HugeGraphParams graph;
    private final String label;
    private final Function<Vertex, T> deser;
    private final ThreadLocal<Boolean> autoCommit = new ThreadLocal();
    private static final long NO_LIMIT = -1L;

    public EntityManager(HugeGraphParams graph, String label, Function<Vertex, T> deser) {
        E.checkNotNull((Object)graph, (String)"graph");
        this.graph = graph;
        this.label = label;
        this.deser = deser;
    }

    private GraphTransaction tx() {
        return this.graph.systemTransaction();
    }

    private HugeGraph graph() {
        return this.graph.graph();
    }

    private String unhideLabel() {
        return Graph.Hidden.unHide((String)this.label);
    }

    public Id add(T entity) {
        E.checkArgumentNotNull(entity, (String)"Entity can't be null", (Object[])new Object[0]);
        return this.save(entity, false);
    }

    public Id update(T entity) {
        E.checkArgumentNotNull(entity, (String)"Entity can't be null", (Object[])new Object[0]);
        ((SchemaDefine.AuthElement)entity).onUpdate();
        return this.save(entity, true);
    }

    public T delete(Id id) {
        SchemaDefine.Entity entity = null;
        Iterator<Vertex> vertices = this.tx().queryVertices(id);
        if (vertices.hasNext()) {
            HugeVertex vertex = (HugeVertex)vertices.next();
            entity = (SchemaDefine.Entity)this.deser.apply(vertex);
            this.tx().removeVertex(vertex);
            this.commitOrRollback();
            assert (!vertices.hasNext());
        }
        return (T)entity;
    }

    public T get(Id id) {
        SchemaDefine.Entity entity = null;
        Iterator<Vertex> vertices = this.tx().queryVertices(id);
        if (vertices.hasNext()) {
            entity = (SchemaDefine.Entity)this.deser.apply(vertices.next());
            assert (!vertices.hasNext());
        }
        if (entity == null) {
            throw new NotFoundException("Can't find %s with id '%s'", this.unhideLabel(), id);
        }
        return (T)entity;
    }

    public boolean exists(Id id) {
        Iterator<Vertex> vertices = this.tx().queryVertices(id);
        if (vertices.hasNext()) {
            Vertex vertex = vertices.next();
            return this.label.equals(vertex.label());
        }
        return false;
    }

    public List<T> list(List<Id> ids) {
        return this.toList(this.queryById(ids));
    }

    public List<T> list(long limit) {
        return this.toList(this.queryEntity(this.label, (Map<String, Object>)ImmutableMap.of(), limit));
    }

    protected List<T> query(String key, Object value, long limit) {
        ImmutableMap conditions = ImmutableMap.of((Object)key, (Object)value);
        return this.toList(this.queryEntity(this.label, (Map<String, Object>)conditions, limit));
    }

    protected List<T> toList(Iterator<Vertex> vertices) {
        MapperIterator iter = new MapperIterator(vertices, this.deser);
        return (List)QueryResults.toList(iter).list();
    }

    private Iterator<Vertex> queryById(List<Id> ids) {
        Object[] idArray = ids.toArray(new Id[0]);
        return this.tx().queryVertices(idArray);
    }

    private Iterator<Vertex> queryEntity(String label, Map<String, Object> conditions, long limit) {
        ConditionQuery query = new ConditionQuery(HugeType.VERTEX);
        VertexLabel vl = this.graph().vertexLabel(label);
        query.eq(HugeKeys.LABEL, vl.id());
        for (Map.Entry<String, Object> entry : conditions.entrySet()) {
            PropertyKey pkey = this.graph().propertyKey(entry.getKey());
            query.query(Condition.eq(pkey.id(), entry.getValue()));
        }
        query.showHidden(true);
        if (limit != -1L) {
            query.limit(limit);
        }
        return this.tx().queryVertices(query);
    }

    private Id save(T entity, boolean expectExists) {
        HugeVertex vertex = this.constructVertex((SchemaDefine.Entity)entity);
        E.checkArgument((this.exists(vertex.id()) == expectExists ? 1 : 0) != 0, (String)"Can't save %s '%s' that %s exists", (Object[])new Object[]{this.unhideLabel(), vertex.id(), expectExists ? "not" : "already"});
        vertex = this.tx().addVertex(vertex);
        this.commitOrRollback();
        return vertex.id();
    }

    private HugeVertex constructVertex(SchemaDefine.Entity entity) {
        if (!this.graph().existsVertexLabel(entity.label())) {
            throw new HugeException("Schema is missing for %s '%s'", entity.label(), entity.id());
        }
        return this.tx().constructVertex(false, entity.asArray());
    }

    private void commitOrRollback() {
        Boolean autoCommit = this.autoCommit.get();
        if (autoCommit != null && !autoCommit.booleanValue()) {
            return;
        }
        this.tx().commitOrRollback();
    }

    public void autoCommit(boolean value) {
        this.autoCommit.set(value);
    }
}

