/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.cache;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.cache.AbstractCache;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.serializer.AbstractSerializer;
import org.apache.hugegraph.backend.serializer.BinaryBackendEntry;
import org.apache.hugegraph.backend.serializer.BinarySerializer;
import org.apache.hugegraph.backend.serializer.BytesBuffer;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.DataType;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.caffinitas.ohc.CacheSerializer;
import org.caffinitas.ohc.CloseableIterator;
import org.caffinitas.ohc.Eviction;
import org.caffinitas.ohc.OHCache;
import org.caffinitas.ohc.OHCacheBuilder;

public class OffheapCache
extends AbstractCache<Id, Object> {
    private static final long VALUE_SIZE_TO_SKIP = 102400L;
    private final OHCache<Id, Value> cache;
    private final HugeGraph graph;
    private final AbstractSerializer serializer;

    public OffheapCache(HugeGraph graph, long capacity, long avgEntryBytes) {
        this(graph, capacity, avgEntryBytes, Runtime.getRuntime().availableProcessors() * 2);
    }

    public OffheapCache(HugeGraph graph, long capacity, long avgEntryBytes, int segments) {
        super(capacity);
        long capacityInBytes = Math.max(capacity, (long)segments) * (avgEntryBytes + 64L);
        if (capacityInBytes <= 0L) {
            capacityInBytes = 1L;
        }
        this.graph = graph;
        this.cache = this.builder().capacity(capacityInBytes).segmentCount(segments).build();
        this.serializer = new BinarySerializer();
    }

    private HugeGraph graph() {
        return this.graph;
    }

    private AbstractSerializer serializer() {
        return this.serializer;
    }

    @Override
    public void traverse(Consumer<Object> consumer) {
        CloseableIterator iter = this.cache.keyIterator();
        while (iter.hasNext()) {
            Id key = (Id)iter.next();
            Value value = (Value)this.cache.get((Object)key);
            consumer.accept(value.value());
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    @Override
    public boolean containsKey(Id id) {
        return this.cache.containsKey((Object)id);
    }

    @Override
    protected Object access(Id id) {
        Value value = (Value)this.cache.get((Object)id);
        return value == null ? null : value.value();
    }

    @Override
    protected boolean write(Id id, Object value, long timeOffset) {
        int serializedSize;
        Value serializedValue = new Value(value);
        try {
            serializedSize = serializedValue.serializedSize();
        }
        catch (Throwable e) {
            LOG.warn("Can't cache '{}' due to {}", (Object)id, (Object)e.toString());
            return false;
        }
        if ((long)serializedSize > 102400L) {
            LOG.info("Skip to cache '{}' due to value size {} > limit {}", new Object[]{id, serializedSize, 102400L});
            return false;
        }
        long expireTime = this.expire();
        boolean success = expireTime <= 0L ? this.cache.put((Object)id, (Object)serializedValue) : this.cache.put((Object)id, (Object)serializedValue, expireTime += OffheapCache.now() + timeOffset);
        assert (success);
        return success;
    }

    @Override
    protected void remove(Id id) {
        this.cache.remove((Object)id);
    }

    @Override
    protected Iterator<AbstractCache.CacheNode<Id, Object>> nodes() {
        return Collections.emptyIterator();
    }

    private OHCacheBuilder<Id, Value> builder() {
        return OHCacheBuilder.newBuilder().keySerializer((CacheSerializer)new IdSerializer()).valueSerializer((CacheSerializer)new ValueSerializer()).eviction(Eviction.LRU).throwOOME(true).timeouts(true);
    }

    private static enum ValueType {
        UNKNOWN,
        LIST,
        VERTEX,
        EDGE,
        BOOLEAN(DataType.BOOLEAN),
        BYTE(DataType.BYTE),
        BLOB(DataType.BLOB),
        STRING(DataType.TEXT),
        INT(DataType.INT),
        LONG(DataType.LONG),
        FLOAT(DataType.FLOAT),
        DOUBLE(DataType.DOUBLE),
        DATE(DataType.DATE),
        UUID(DataType.UUID);

        private final DataType dataType;

        private ValueType() {
            this(DataType.UNKNOWN);
        }

        private ValueType(DataType dataType) {
            this.dataType = dataType;
        }

        public int code() {
            return this.ordinal();
        }

        public DataType dataType() {
            return this.dataType;
        }

        public static ValueType valueOf(int index) {
            ValueType[] values = ValueType.values();
            E.checkArgument((0 <= index && index < values.length ? 1 : 0) != 0, (String)"Invalid ValueType index %s", (Object[])new Object[]{index});
            return values[index];
        }

        public static ValueType valueOf(Object object) {
            E.checkNotNull((Object)object, (String)"object");
            Class<?> clazz = object.getClass();
            if (Collection.class.isAssignableFrom(clazz)) {
                return LIST;
            }
            if (HugeVertex.class.isAssignableFrom(clazz)) {
                return VERTEX;
            }
            if (HugeEdge.class.isAssignableFrom(clazz)) {
                return EDGE;
            }
            for (ValueType type : ValueType.values()) {
                if (clazz != type.dataType().clazz()) continue;
                return type;
            }
            return UNKNOWN;
        }
    }

    private class Value {
        private final Object value;
        private BytesBuffer svalue = null;
        private int serializedSize = 0;

        public Value(Object value) {
            E.checkNotNull((Object)value, (String)"value");
            this.value = value;
        }

        public Value(ByteBuffer input) {
            this.value = this.deserialize(BytesBuffer.wrap(input));
        }

        public Object value() {
            return this.value;
        }

        public int serializedSize() {
            this.asBuffer();
            return this.serializedSize;
        }

        public ByteBuffer asBuffer() {
            if (this.svalue == null) {
                int listSize = 1;
                if (this.value instanceof List) {
                    listSize = ((List)this.value).size();
                }
                BytesBuffer buffer = BytesBuffer.allocate(64 * listSize);
                this.serialize(this.value, buffer);
                this.serializedSize = buffer.position();
                buffer.forReadWritten();
                this.svalue = buffer;
            }
            return this.svalue.asByteBuffer();
        }

        private void serialize(Object element, BytesBuffer buffer) {
            ValueType type = ValueType.valueOf(element);
            buffer.write(type.code());
            switch (type) {
                case LIST: {
                    Collection list = (Collection)element;
                    this.serializeList(buffer, list);
                    break;
                }
                case VERTEX: 
                case EDGE: {
                    this.serializeElement(buffer, type, element);
                    break;
                }
                case UNKNOWN: {
                    throw this.unsupported(this.value);
                }
                default: {
                    buffer.writeProperty(type.dataType(), element);
                }
            }
        }

        private Object deserialize(BytesBuffer buffer) {
            ValueType type = ValueType.valueOf(buffer.read());
            switch (type) {
                case LIST: {
                    return this.deserializeList(buffer);
                }
                case VERTEX: 
                case EDGE: {
                    return this.deserializeElement(type, buffer);
                }
                case UNKNOWN: {
                    throw this.unsupported(type);
                }
            }
            return buffer.readProperty(type.dataType());
        }

        private void serializeList(BytesBuffer buffer, Collection<Object> list) {
            buffer.writeVInt(list.size());
            for (Object i : list) {
                this.serialize(i, buffer);
            }
        }

        private List<Object> deserializeList(BytesBuffer buffer) {
            int length = buffer.readVInt();
            List list = InsertionOrderUtil.newList();
            for (int i = 0; i < length; ++i) {
                list.add(this.deserialize(buffer));
            }
            return list;
        }

        private void serializeElement(BytesBuffer buffer, ValueType type, Object value) {
            BackendEntry entry;
            E.checkNotNull((Object)value, (String)"serialize value");
            if (type == ValueType.VERTEX) {
                entry = OffheapCache.this.serializer().writeVertex((HugeVertex)value);
            } else if (type == ValueType.EDGE) {
                entry = OffheapCache.this.serializer().writeEdge((HugeEdge)value);
            } else {
                throw this.unsupported(type);
            }
            assert (entry.columnsSize() == 1);
            BackendEntry.BackendColumn column = entry.columns().iterator().next();
            buffer.writeBytes(column.name);
            buffer.writeBigBytes(column.value);
        }

        private Object deserializeElement(ValueType type, BytesBuffer buffer) {
            byte[] key = buffer.readBytes();
            byte[] value = buffer.readBigBytes();
            if (type == ValueType.VERTEX) {
                BinaryBackendEntry entry = new BinaryBackendEntry(HugeType.VERTEX, key);
                entry.column(key, value);
                return OffheapCache.this.serializer().readVertex(OffheapCache.this.graph(), entry);
            }
            if (type == ValueType.EDGE) {
                BinaryBackendEntry entry = new BinaryBackendEntry(HugeType.EDGE, key);
                entry.column(key, value);
                return OffheapCache.this.serializer().readEdge(OffheapCache.this.graph(), entry);
            }
            throw this.unsupported(type);
        }

        private HugeException unsupported(ValueType type) {
            throw new HugeException("Unsupported deserialize type: %s", new Object[]{type});
        }

        private HugeException unsupported(Object value) {
            throw new HugeException("Unsupported type of serialize value: '%s'(%s)", value, value.getClass());
        }
    }

    private class ValueSerializer
    implements CacheSerializer<Value> {
        private ValueSerializer() {
        }

        public Value deserialize(ByteBuffer input) {
            return new Value(input);
        }

        public void serialize(Value value, ByteBuffer output) {
            output.put(value.asBuffer());
        }

        public int serializedSize(Value value) {
            return value.serializedSize();
        }
    }

    private class IdSerializer
    implements CacheSerializer<Id> {
        private IdSerializer() {
        }

        public Id deserialize(ByteBuffer input) {
            return BytesBuffer.wrap(input).readId();
        }

        public void serialize(Id id, ByteBuffer output) {
            BytesBuffer.wrap(output).writeId(id);
        }

        public int serializedSize(Id id) {
            return BytesBuffer.allocate(id.length() + 2).writeId(id).position();
        }
    }
}

