/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.serializer;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import org.apache.hugegraph.backend.id.EdgeId;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.serializer.BinaryBackendEntry;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Cardinality;
import org.apache.hugegraph.type.define.DataType;
import org.apache.hugegraph.util.Blob;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.KryoUtil;
import org.apache.hugegraph.util.StringEncoding;

public final class BytesBuffer
extends OutputStream {
    public static final int BYTE_LEN = 1;
    public static final int SHORT_LEN = 2;
    public static final int INT_LEN = 4;
    public static final int LONG_LEN = 8;
    public static final int CHAR_LEN = 2;
    public static final int FLOAT_LEN = 4;
    public static final int DOUBLE_LEN = 8;
    public static final int BYTES_LEN = 4;
    public static final int BLOB_LEN = 5;
    public static final int UINT8_MAX = 255;
    public static final int UINT16_MAX = 65535;
    public static final long UINT32_MAX = 0xFFFFFFFFL;
    public static final int ID_LEN_MAX = 16384;
    public static final int EID_LEN_MAX = 65536;
    public static final byte STRING_ENDING_BYTE = 0;
    public static final byte STRING_ENDING_BYTE_FF = -1;
    public static final long BYTES_LEN_MAX = 0xA00000L;
    public static final long BLOB_LEN_MAX = 0x40000000L;
    public static final int MAX_PROPERTIES = 65535;
    public static final int INDEX_HASH_ID_THRESHOLD = 32;
    public static final int DEFAULT_CAPACITY = 64;
    public static final int MAX_BUFFER_CAPACITY = 0x8000000;
    public static final int BUF_EDGE_ID = 128;
    public static final int BUF_PROPERTY = 64;
    public static final byte[] BYTES_EMPTY = new byte[0];
    private ByteBuffer buffer;
    private final boolean resize;

    public BytesBuffer() {
        this(64);
    }

    public BytesBuffer(int capacity) {
        E.checkArgument((capacity <= 0x8000000 ? 1 : 0) != 0, (String)"Capacity exceeds max buffer capacity: %s", (Object[])new Object[]{0x8000000});
        this.buffer = ByteBuffer.allocate(capacity);
        this.resize = true;
    }

    public BytesBuffer(ByteBuffer buffer) {
        E.checkNotNull((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.resize = false;
    }

    public static BytesBuffer allocate(int capacity) {
        return new BytesBuffer(capacity);
    }

    public static BytesBuffer wrap(ByteBuffer buffer) {
        return new BytesBuffer(buffer);
    }

    public static BytesBuffer wrap(byte[] array) {
        return new BytesBuffer(ByteBuffer.wrap(array));
    }

    public static BytesBuffer wrap(byte[] array, int offset, int length) {
        return new BytesBuffer(ByteBuffer.wrap(array, offset, length));
    }

    public ByteBuffer asByteBuffer() {
        return this.buffer;
    }

    public BytesBuffer forReadWritten() {
        this.buffer.flip();
        return this;
    }

    public BytesBuffer forReadAll() {
        this.buffer.position(this.buffer.limit());
        return this;
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public byte[] bytes() {
        byte[] bytes = this.buffer.array();
        int position = this.buffer.position();
        if (position == bytes.length) {
            return bytes;
        }
        return Arrays.copyOf(bytes, position);
    }

    public int position() {
        return this.buffer.position();
    }

    public BytesBuffer copyFrom(BytesBuffer other) {
        this.write(other.bytes());
        return this;
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    private void require(int size) {
        if (this.buffer.limit() - this.buffer.position() >= size) {
            return;
        }
        E.checkState((boolean)this.resize, (String)"Can't resize for wrapped buffer", (Object[])new Object[0]);
        int newCapacity = size + this.buffer.limit() + 64;
        E.checkArgument((newCapacity <= 0x8000000 ? 1 : 0) != 0, (String)"Capacity exceeds max buffer capacity: %s", (Object[])new Object[]{0x8000000});
        ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
        this.buffer.flip();
        newBuffer.put(this.buffer);
        this.buffer = newBuffer;
    }

    public BytesBuffer write(byte val) {
        this.require(1);
        this.buffer.put(val);
        return this;
    }

    @Override
    public void write(int val) {
        assert (val <= 255);
        this.require(1);
        this.buffer.put((byte)val);
    }

    @Override
    public void write(byte[] val) {
        this.require(1 * val.length);
        this.buffer.put(val);
    }

    @Override
    public void write(byte[] val, int offset, int length) {
        this.require(1 * length);
        this.buffer.put(val, offset, length);
    }

    public BytesBuffer writeBoolean(boolean val) {
        this.write(val ? 1 : 0);
        return this;
    }

    public BytesBuffer writeChar(char val) {
        this.require(2);
        this.buffer.putChar(val);
        return this;
    }

    public BytesBuffer writeShort(short val) {
        this.require(2);
        this.buffer.putShort(val);
        return this;
    }

    public BytesBuffer writeInt(int val) {
        this.require(4);
        this.buffer.putInt(val);
        return this;
    }

    public BytesBuffer writeLong(long val) {
        this.require(8);
        this.buffer.putLong(val);
        return this;
    }

    public BytesBuffer writeFloat(float val) {
        this.require(4);
        this.buffer.putFloat(val);
        return this;
    }

    public BytesBuffer writeDouble(double val) {
        this.require(8);
        this.buffer.putDouble(val);
        return this;
    }

    public byte peek() {
        return this.buffer.get(this.buffer.position());
    }

    public byte peekLast() {
        return this.buffer.get(this.buffer.capacity() - 1);
    }

    public byte read() {
        return this.buffer.get();
    }

    public byte[] read(int length) {
        byte[] bytes = new byte[length];
        this.buffer.get(bytes);
        return bytes;
    }

    public boolean readBoolean() {
        return this.buffer.get() != 0;
    }

    public char readChar() {
        return this.buffer.getChar();
    }

    public short readShort() {
        return this.buffer.getShort();
    }

    public int readInt() {
        return this.buffer.getInt();
    }

    public long readLong() {
        return this.buffer.getLong();
    }

    public float readFloat() {
        return this.buffer.getFloat();
    }

    public double readDouble() {
        return this.buffer.getDouble();
    }

    public BytesBuffer writeBytes(byte[] bytes) {
        E.checkArgument(((long)bytes.length <= 0xA00000L ? 1 : 0) != 0, (String)"The max length of bytes is %s, but got %s", (Object[])new Object[]{0xA00000L, bytes.length});
        this.require(4 + bytes.length);
        this.writeVInt(bytes.length);
        this.write(bytes);
        return this;
    }

    public byte[] readBytes() {
        int length = this.readVInt();
        assert (length >= 0);
        return this.read(length);
    }

    public BytesBuffer writeBigBytes(byte[] bytes) {
        E.checkArgument(((long)bytes.length <= 0x40000000L ? 1 : 0) != 0, (String)"The max length of bytes is %s, but got %s", (Object[])new Object[]{0x40000000L, bytes.length});
        this.require(5 + bytes.length);
        this.writeVInt(bytes.length);
        this.write(bytes);
        return this;
    }

    public byte[] readBigBytes() {
        int length = this.readVInt();
        assert (length >= 0);
        return this.read(length);
    }

    public BytesBuffer writeStringRaw(String val) {
        this.write(StringEncoding.encode(val));
        return this;
    }

    public BytesBuffer writeString(String val) {
        byte[] bytes = StringEncoding.encode(val);
        this.writeBytes(bytes);
        return this;
    }

    public String readString() {
        return StringEncoding.decode(this.readBytes());
    }

    public BytesBuffer writeStringWithEnding(String value) {
        if (!value.isEmpty()) {
            byte[] bytes = StringEncoding.encode(value);
            assert (!Bytes.contains((byte[])bytes, (byte)-1)) : "Invalid UTF8 bytes: " + value;
            if (Bytes.contains((byte[])bytes, (byte)0)) {
                E.checkArgument((boolean)false, (String)"Can't contains byte '0x00' in string: '%s'", (Object[])new Object[]{value});
            }
            this.write(bytes);
        }
        this.write((byte)0);
        return this;
    }

    public String readStringWithEnding() {
        return StringEncoding.decode(this.readBytesWithEnding());
    }

    public BytesBuffer writeStringToRemaining(String value) {
        byte[] bytes = StringEncoding.encode(value);
        this.write(bytes);
        return this;
    }

    public String readStringFromRemaining() {
        byte[] bytes = new byte[this.buffer.remaining()];
        this.buffer.get(bytes);
        return StringEncoding.decode(bytes);
    }

    public BytesBuffer writeUInt8(int val) {
        assert (val <= 255);
        this.write(val);
        return this;
    }

    public int readUInt8() {
        return this.read() & 0xFF;
    }

    public BytesBuffer writeUInt16(int val) {
        assert (val <= 65535);
        this.writeShort((short)val);
        return this;
    }

    public int readUInt16() {
        return this.readShort() & 0xFFFF;
    }

    public BytesBuffer writeUInt32(long val) {
        assert (val <= 0xFFFFFFFFL);
        this.writeInt((int)val);
        return this;
    }

    public long readUInt32() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public BytesBuffer writeVInt(int value) {
        if (value > 0xFFFFFFF || value < 0) {
            this.write(0x80 | value >>> 28 & 0x7F);
        }
        if (value > 0x1FFFFF || value < 0) {
            this.write(0x80 | value >>> 21 & 0x7F);
        }
        if (value > 16383 || value < 0) {
            this.write(0x80 | value >>> 14 & 0x7F);
        }
        if (value > 127 || value < 0) {
            this.write(0x80 | value >>> 7 & 0x7F);
        }
        this.write(value & 0x7F);
        return this;
    }

    public int readVInt() {
        int i;
        byte leading = this.read();
        E.checkArgument((leading != 128 ? 1 : 0) != 0, (String)"Unexpected varint with leading byte '0x%s'", (Object[])new Object[]{Bytes.toHex((byte)leading)});
        int value = leading & 0x7F;
        if (leading >= 0) {
            assert ((leading & 0x80) == 0);
            return value;
        }
        for (i = 1; i < 5; ++i) {
            byte b = this.read();
            if (b >= 0) {
                value = b | value << 7;
                break;
            }
            value = b & 0x7F | value << 7;
        }
        E.checkArgument((i < 5 ? 1 : 0) != 0, (String)"Unexpected varint %s with too many bytes(%s)", (Object[])new Object[]{value, i + 1});
        E.checkArgument((i < 4 || (leading & 0x70) == 0 ? 1 : 0) != 0, (String)"Unexpected varint %s with leading byte '0x%s'", (Object[])new Object[]{value, Bytes.toHex((byte)leading)});
        return value;
    }

    public BytesBuffer writeVLong(long value) {
        if (value < 0L) {
            this.write((byte)-127);
        }
        if (value > 0xFFFFFFFFFFFFFFL || value < 0L) {
            this.write(0x80 | (int)(value >>> 56) & 0x7F);
        }
        if (value > 0x1FFFFFFFFFFFFL || value < 0L) {
            this.write(0x80 | (int)(value >>> 49) & 0x7F);
        }
        if (value > 0x3FFFFFFFFFFL || value < 0L) {
            this.write(0x80 | (int)(value >>> 42) & 0x7F);
        }
        if (value > 0x7FFFFFFFFL || value < 0L) {
            this.write(0x80 | (int)(value >>> 35) & 0x7F);
        }
        if (value > 0xFFFFFFFL || value < 0L) {
            this.write(0x80 | (int)(value >>> 28) & 0x7F);
        }
        if (value > 0x1FFFFFL || value < 0L) {
            this.write(0x80 | (int)(value >>> 21) & 0x7F);
        }
        if (value > 16383L || value < 0L) {
            this.write(0x80 | (int)(value >>> 14) & 0x7F);
        }
        if (value > 127L || value < 0L) {
            this.write(0x80 | (int)(value >>> 7) & 0x7F);
        }
        this.write((int)value & 0x7F);
        return this;
    }

    public long readVLong() {
        int i;
        byte leading = this.read();
        E.checkArgument((leading != 128 ? 1 : 0) != 0, (String)"Unexpected varlong with leading byte '0x%s'", (Object[])new Object[]{Bytes.toHex((byte)leading)});
        long value = (long)leading & 0x7FL;
        if (leading >= 0) {
            assert ((leading & 0x80) == 0);
            return value;
        }
        for (i = 1; i < 10; ++i) {
            byte b = this.read();
            if (b >= 0) {
                value = (long)b | value << 7;
                break;
            }
            value = (long)(b & 0x7F) | value << 7;
        }
        E.checkArgument((i < 10 ? 1 : 0) != 0, (String)"Unexpected varlong %s with too many bytes(%s)", (Object[])new Object[]{value, i + 1});
        E.checkArgument((i < 9 || (leading & 0x7E) == 0 ? 1 : 0) != 0, (String)"Unexpected varlong %s with leading byte '0x%s'", (Object[])new Object[]{value, Bytes.toHex((byte)leading)});
        return value;
    }

    public BytesBuffer writeProperty(PropertyKey pkey, Object value) {
        if (pkey.cardinality() == Cardinality.SINGLE) {
            this.writeProperty(pkey.dataType(), value);
            return this;
        }
        assert (pkey.cardinality() == Cardinality.LIST || pkey.cardinality() == Cardinality.SET);
        Collection values = (Collection)value;
        this.writeVInt(values.size());
        for (Object o : values) {
            this.writeProperty(pkey.dataType(), o);
        }
        return this;
    }

    public Object readProperty(PropertyKey pkey) {
        if (pkey.cardinality() == Cardinality.SINGLE) {
            return this.readProperty(pkey.dataType());
        }
        assert (pkey.cardinality() == Cardinality.LIST || pkey.cardinality() == Cardinality.SET);
        int size = this.readVInt();
        Collection values = (Collection)pkey.newValue();
        for (int i = 0; i < size; ++i) {
            values.add(this.readProperty(pkey.dataType()));
        }
        return values;
    }

    public void writeProperty(DataType dataType, Object value) {
        switch (dataType) {
            case BOOLEAN: {
                this.writeVInt((Boolean)value != false ? 1 : 0);
                break;
            }
            case BYTE: {
                this.writeVInt(((Byte)value).byteValue());
                break;
            }
            case INT: {
                this.writeVInt((Integer)value);
                break;
            }
            case FLOAT: {
                this.writeFloat(((Float)value).floatValue());
                break;
            }
            case LONG: {
                this.writeVLong((Long)value);
                break;
            }
            case DATE: {
                this.writeVLong(((Date)value).getTime());
                break;
            }
            case DOUBLE: {
                this.writeDouble((Double)value);
                break;
            }
            case TEXT: {
                this.writeString((String)value);
                break;
            }
            case BLOB: {
                byte[] bytes = value instanceof byte[] ? (byte[])value : ((Blob)value).bytes();
                this.writeBigBytes(bytes);
                break;
            }
            case UUID: {
                UUID uuid = (UUID)value;
                this.writeLong(uuid.getMostSignificantBits());
                this.writeLong(uuid.getLeastSignificantBits());
                break;
            }
            default: {
                this.writeBytes(KryoUtil.toKryoWithType(value));
            }
        }
    }

    public static byte getType(int value) {
        return (byte)(value & 0x3F);
    }

    public Object readProperty(DataType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return this.readVInt() == 1;
            }
            case BYTE: {
                return (byte)this.readVInt();
            }
            case INT: {
                return this.readVInt();
            }
            case FLOAT: {
                return Float.valueOf(this.readFloat());
            }
            case LONG: {
                return this.readVLong();
            }
            case DATE: {
                return new Date(this.readVLong());
            }
            case DOUBLE: {
                return this.readDouble();
            }
            case TEXT: {
                return this.readString();
            }
            case BLOB: {
                return Blob.wrap(this.readBigBytes());
            }
            case UUID: {
                return new UUID(this.readLong(), this.readLong());
            }
        }
        return KryoUtil.fromKryoWithType(this.readBytes());
    }

    public BytesBuffer writeId(Id id) {
        switch (id.type()) {
            case LONG: {
                long value = id.asLong();
                this.writeNumber(value);
                break;
            }
            case UUID: {
                byte[] bytes = id.asBytes();
                assert (bytes.length == 16);
                this.writeUInt8(127);
                this.write(bytes);
                break;
            }
            case EDGE: {
                this.writeUInt8(126);
                this.writeEdgeId(id);
                break;
            }
            default: {
                byte[] bytes = id.asBytes();
                int len = bytes.length;
                E.checkArgument((len > 0 ? 1 : 0) != 0, (String)"Can't write empty id", (Object[])new Object[0]);
                E.checkArgument((len <= 16384 ? 1 : 0) != 0, (String)"Big id max length is %s, but got %s {%s}", (Object[])new Object[]{16384, len, id});
                if (--len <= 63) {
                    this.writeUInt8(len | 0x80);
                } else {
                    int high = len >> 8;
                    int low = len & 0xFF;
                    this.writeUInt8(high | 0xC0);
                    this.writeUInt8(low);
                }
                this.write(bytes);
            }
        }
        return this;
    }

    public Id readId() {
        boolean number;
        byte b = this.read();
        boolean bl = number = (b & 0x80) == 0;
        if (number) {
            if (b == 127) {
                return IdGenerator.of(this.read(16), Id.IdType.UUID);
            }
            if (b == 126) {
                return this.readEdgeId();
            }
            return IdGenerator.of(this.readNumber(b));
        }
        int len = b & 0x3F;
        if ((b & 0x40) != 0) {
            int high = len << 8;
            int low = this.readUInt8();
            len = high + low;
        }
        byte[] id = this.read(++len);
        return IdGenerator.of(id, Id.IdType.STRING);
    }

    public BytesBuffer writeEdgeId(Id id) {
        EdgeId edge = (EdgeId)id;
        this.writeId(edge.ownerVertexId());
        this.write(edge.directionCode());
        this.writeId(edge.edgeLabelId());
        this.writeId(edge.subLabelId());
        this.writeStringWithEnding(edge.sortValues());
        this.writeId(edge.otherVertexId());
        return this;
    }

    public Id readEdgeId() {
        return new EdgeId(this.readId(), EdgeId.directionFromCode(this.read()), this.readId(), this.readId(), this.readStringWithEnding(), this.readId());
    }

    public BytesBuffer writeIndexId(Id id, HugeType type) {
        return this.writeIndexId(id, type, true);
    }

    public BytesBuffer writeIndexId(Id id, HugeType type, boolean withEnding) {
        byte[] bytes = id.asBytes();
        int len = bytes.length;
        E.checkArgument((len > 0 ? 1 : 0) != 0, (String)"Can't write empty id", (Object[])new Object[0]);
        this.write(bytes);
        if (type.isStringIndex()) {
            if (Bytes.contains((byte[])bytes, (byte)0)) {
                E.checkArgument((boolean)false, (String)"The %s type index id can't contains byte '0x%s', but got: 0x%s", (Object[])new Object[]{type, Bytes.toHex((byte)0), Bytes.toHex((byte[])bytes)});
            }
            if (withEnding) {
                this.writeStringWithEnding("");
            }
        }
        return this;
    }

    public BinaryBackendEntry.BinaryId readIndexId(HugeType type) {
        byte[] id;
        if (type.isRange4Index()) {
            id = this.read(9);
        } else if (type.isRange8Index()) {
            id = this.read(13);
        } else {
            assert (type.isStringIndex());
            id = this.readBytesWithEnding();
        }
        return new BinaryBackendEntry.BinaryId(id, IdGenerator.of(id, Id.IdType.STRING));
    }

    public BinaryBackendEntry.BinaryId asId() {
        return new BinaryBackendEntry.BinaryId(this.bytes(), null);
    }

    public BinaryBackendEntry.BinaryId parseId(HugeType type, boolean enablePartition) {
        if (type.isIndex()) {
            return this.readIndexId(type);
        }
        if ((type.isVertex() || type.isEdge()) && enablePartition) {
            this.readShort();
        }
        int start = this.buffer.position();
        Id id = this.readId();
        int end = this.buffer.position();
        int len = end - start;
        byte[] bytes = new byte[len];
        System.arraycopy(this.array(), start, bytes, 0, len);
        return new BinaryBackendEntry.BinaryId(bytes, id);
    }

    public BinaryBackendEntry.BinaryId parseOlapId(HugeType type, boolean isOlap) {
        if (type.isIndex()) {
            return this.readIndexId(type);
        }
        int start = this.buffer.position();
        if (isOlap) {
            Id id = this.readId();
        }
        Id id = this.readId();
        int end = this.buffer.position();
        int len = end - start;
        byte[] bytes = new byte[len];
        System.arraycopy(this.array(), start, bytes, 0, len);
        return new BinaryBackendEntry.BinaryId(bytes, id);
    }

    private void writeNumber(long val) {
        int positive;
        int n = positive = val >= 0L ? 8 : 0;
        if (-2048L <= val && val <= 2047L) {
            int high3bits = (int)(val >> 8) & 7;
            this.writeUInt8(0 | positive | high3bits);
            this.writeUInt8((byte)val);
        } else if (-524288L <= val && val <= 524287L) {
            int high3bits = (int)(val >> 16) & 7;
            this.writeUInt8(0x10 | positive | high3bits);
            this.writeShort((short)val);
        } else if (-134217728L <= val && val <= 0x7FFFFFFL) {
            int high3bits = (int)(val >> 24 & 7L);
            this.writeUInt8(0x20 | positive | high3bits);
            this.write((byte)(val >> 16));
            this.writeShort((short)val);
        } else if (-34359738368L <= val && val <= 0x7FFFFFFFFL) {
            int high3bits = (int)(val >> 32) & 7;
            this.writeUInt8(0x30 | positive | high3bits);
            this.writeInt((int)val);
        } else if (-8796093022208L <= val && val <= 0x7FFFFFFFFFFL) {
            int high3bits = (int)(val >> 40) & 7;
            this.writeUInt8(0x40 | positive | high3bits);
            this.write((byte)(val >> 32));
            this.writeInt((int)val);
        } else if (-2251799813685248L <= val && val <= 0x7FFFFFFFFFFFFL) {
            int high3bits = (int)(val >> 48) & 7;
            this.writeUInt8(0x50 | positive | high3bits);
            this.writeShort((short)(val >> 32));
            this.writeInt((int)val);
        } else if (-576460752303423488L <= val && val <= 0x7FFFFFFFFFFFFFFL) {
            int high3bits = (int)(val >> 56) & 7;
            this.writeUInt8(0x60 | positive | high3bits);
            this.write((byte)(val >> 48));
            this.writeShort((short)(val >> 32));
            this.writeInt((int)val);
        } else {
            this.writeUInt8(0x70 | positive);
            this.writeLong(val);
        }
    }

    private long readNumber(byte b) {
        E.checkArgument(((b & 0x80) == 0 ? 1 : 0) != 0, (String)"Not a number type with prefix byte '0x%s'", (Object[])new Object[]{Bytes.toHex((byte)b)});
        int kind = b >>> 4;
        boolean positive = (b & 8) > 0;
        long high3bits = b & 7;
        long value = high3bits << (kind + 1) * 8;
        switch (kind) {
            case 0: {
                value |= (long)this.readUInt8();
                break;
            }
            case 1: {
                value |= (long)this.readUInt16();
                break;
            }
            case 2: {
                value |= (long)this.readUInt8() << 16 | (long)this.readUInt16();
                break;
            }
            case 3: {
                value |= this.readUInt32();
                break;
            }
            case 4: {
                value |= (long)this.readUInt8() << 32 | this.readUInt32();
                break;
            }
            case 5: {
                value |= (long)this.readUInt16() << 32 | this.readUInt32();
                break;
            }
            case 6: {
                value |= (long)this.readUInt8() << 48 | (long)this.readUInt16() << 32 | this.readUInt32();
                break;
            }
            case 7: {
                assert (high3bits == 0L);
                value |= this.readLong();
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid length of number: " + kind));
            }
        }
        if (!positive && kind < 7) {
            long mask = Long.MIN_VALUE >> 52 - kind * 8;
            value |= mask;
        }
        return value;
    }

    private byte[] readBytesWithEnding() {
        int start = this.buffer.position();
        boolean foundEnding = false;
        int remaining = this.remaining();
        for (int i = 0; i < remaining; ++i) {
            byte current = this.read();
            if (current != 0) continue;
            foundEnding = true;
            break;
        }
        E.checkArgument((boolean)foundEnding, (String)"Not found ending '0x%s'", (Object[])new Object[]{Bytes.toHex((byte)0)});
        int end = this.buffer.position() - 1;
        int len = end - start;
        if (len <= 0) {
            return BYTES_EMPTY;
        }
        byte[] bytes = new byte[len];
        System.arraycopy(this.array(), start, bytes, 0, len);
        return bytes;
    }
}

