/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.tx;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.analyzer.Analyzer;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.page.IdHolder;
import org.apache.hugegraph.backend.page.IdHolderList;
import org.apache.hugegraph.backend.page.PageIds;
import org.apache.hugegraph.backend.page.PageInfo;
import org.apache.hugegraph.backend.page.PageState;
import org.apache.hugegraph.backend.page.SortByCountIdHolderList;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.ConditionQueryFlatten;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.backend.serializer.AbstractSerializer;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.backend.tx.AbstractTransaction;
import org.apache.hugegraph.backend.tx.ISchemaTransaction;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.exception.NoIndexException;
import org.apache.hugegraph.exception.NotAllowException;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.iterator.Metadatable;
import org.apache.hugegraph.job.EphemeralJob;
import org.apache.hugegraph.job.system.DeleteExpiredJob;
import org.apache.hugegraph.perf.PerfUtil;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.schema.SchemaLabel;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeIndex;
import org.apache.hugegraph.structure.HugeProperty;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.task.EphemeralJobQueue;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Action;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.type.define.IndexType;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.LockUtil;
import org.apache.hugegraph.util.LongEncoding;
import org.apache.hugegraph.util.NumericUtil;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;

public class GraphIndexTransaction
extends AbstractTransaction {
    public static final String START_SYMBOL = "(";
    public static final String END_SYMBOL = ")";
    public static final String WORD_DELIMITER = "|";
    private final Analyzer textAnalyzer;
    private final int indexIntersectThresh;

    public GraphIndexTransaction(HugeGraphParams graph, BackendStore store) {
        super(graph, store);
        this.textAnalyzer = graph.analyzer();
        assert (this.textAnalyzer != null);
        HugeConfig conf = graph.configuration();
        this.indexIntersectThresh = (Integer)conf.get(CoreOptions.QUERY_INDEX_INTERSECT_THRESHOLD);
    }

    protected void asyncRemoveIndexLeft(ConditionQuery query, HugeElement element) {
        LOG.info("Remove left index: {}, query: {}", (Object)element, (Object)query);
        RemoveLeftIndexJob job = new RemoveLeftIndexJob(query, element);
        this.params().submitEphemeralJob(job);
    }

    @PerfUtil.Watched(prefix="index")
    public void updateLabelIndex(HugeElement element, boolean removed) {
        if (element instanceof HugeVertex && ((HugeVertex)element).olap()) {
            return;
        }
        if (!this.needIndexForLabel()) {
            return;
        }
        SchemaLabel label = element.schemaLabel();
        if (!label.enableLabelIndex()) {
            return;
        }
        HugeIndex index = new HugeIndex(this.graph(), IndexLabel.label(element.type()));
        index.fieldValues(element.schemaLabel().id());
        index.elementIds(element.id(), element.expiredTime());
        if (removed) {
            this.doEliminate(this.serializer.writeIndex(index));
        } else {
            this.doAppend(this.serializer.writeIndex(index));
        }
        if (element instanceof HugeEdge && ((EdgeLabel)label).hasFather()) {
            HugeIndex fatherIndex = new HugeIndex(this.graph(), IndexLabel.label(element.type()));
            fatherIndex.fieldValues(((EdgeLabel)label).fatherId());
            fatherIndex.elementIds(element.id(), element.expiredTime());
            if (removed) {
                this.doEliminate(this.serializer.writeIndex(fatherIndex));
            } else {
                this.doAppend(this.serializer.writeIndex(fatherIndex));
            }
        }
    }

    @PerfUtil.Watched(prefix="index")
    public void updateVertexIndex(HugeVertex vertex, boolean removed) {
        if (vertex.olap()) {
            this.updateVertexOlapIndex(vertex, removed);
            return;
        }
        for (Id id : vertex.schemaLabel().indexLabels()) {
            this.updateIndex(id, vertex, removed);
        }
    }

    @PerfUtil.Watched(prefix="index")
    public void updateEdgeIndex(HugeEdge edge, boolean removed) {
        for (Id id : edge.schemaLabel().indexLabels()) {
            this.updateIndex(id, edge, removed);
        }
        EdgeLabel label = edge.schemaLabel();
        if (label.hasFather()) {
            for (Id id : this.graph().edgeLabel(label.fatherId()).indexLabels()) {
                this.updateIndex(id, edge, removed);
            }
        }
    }

    private void updateVertexOlapIndex(HugeVertex vertex, boolean removed) {
        Set<Id> propKeys = vertex.getPropertyKeys();
        E.checkArgument((propKeys.size() == 1 ? 1 : 0) != 0, (String)"Expect only 1 property for olap vertex, but got %s", (Object[])new Object[]{propKeys.size()});
        Id pkId = propKeys.iterator().next();
        List<IndexLabel> indexLabels = this.params().schemaTransaction().getIndexLabels();
        for (IndexLabel il : indexLabels) {
            if (!il.indexFields().contains(pkId)) continue;
            this.updateIndex(il.id(), vertex, removed);
        }
    }

    protected void updateIndex(Id ilId, HugeElement element, boolean removed) {
        int fieldsNum;
        ISchemaTransaction schema = this.params().schemaTransaction();
        IndexLabel indexLabel = schema.getIndexLabel(ilId);
        E.checkArgument((indexLabel != null ? 1 : 0) != 0, (String)"Not exist index label with id '%s'", (Object[])new Object[]{ilId});
        ArrayList<String> allPropValues = new ArrayList<String>();
        int firstNullField = fieldsNum = indexLabel.indexFields().size();
        for (Id fieldId : indexLabel.indexFields()) {
            HugeProperty property = element.getProperty(fieldId);
            if (property == null) {
                E.checkState((boolean)GraphIndexTransaction.hasNullableProp(element, fieldId), (String)"Non-null property '%s' is null for '%s'", (Object[])new Object[]{this.graph().propertyKey(fieldId), element});
                if (firstNullField == fieldsNum) {
                    firstNullField = allPropValues.size();
                }
                allPropValues.add("<null>");
                continue;
            }
            allPropValues.add((String)property.value());
        }
        if (firstNullField == 0 && !indexLabel.indexType().isUnique()) {
            return;
        }
        List<Object> nnPropValues = allPropValues.subList(0, firstNullField);
        long expiredTime = element.expiredTime();
        switch (indexLabel.indexType()) {
            case RANGE_INT: 
            case RANGE_FLOAT: 
            case RANGE_LONG: 
            case RANGE_DOUBLE: {
                E.checkState((nnPropValues.size() == 1 ? 1 : 0) != 0, (String)"Expect only one property in range index", (Object[])new Object[0]);
                Number value = NumericUtil.convertToNumber((Object)nnPropValues.get(0));
                this.updateIndex(indexLabel, value, element.id(), expiredTime, removed);
                break;
            }
            case SEARCH: {
                E.checkState((nnPropValues.size() == 1 ? 1 : 0) != 0, (String)"Expect only one property in search index", (Object[])new Object[0]);
                Object value = nnPropValues.get(0);
                Set<String> words = this.segmentWords(GraphIndexTransaction.propertyValueToString(value));
                for (String word : words) {
                    this.updateIndex(indexLabel, word, element.id(), expiredTime, removed);
                }
                break;
            }
            case SECONDARY: {
                if (GraphIndexTransaction.isCollectionIndex(nnPropValues)) {
                    for (Object propValue : (Collection)nnPropValues.get(0)) {
                        String value = ConditionQuery.concatValues(propValue);
                        this.updateIndex(indexLabel, value, element.id(), expiredTime, removed);
                    }
                } else {
                    int n = nnPropValues.size();
                    for (int i = 0; i < n; ++i) {
                        List<Object> prefixValues = nnPropValues.subList(0, i + 1);
                        String value = ConditionQuery.concatValues(prefixValues);
                        this.updateIndex(indexLabel, value, element.id(), expiredTime, removed);
                    }
                }
                break;
            }
            case SHARD: {
                String value = ConditionQuery.concatValues(nnPropValues);
                this.updateIndex(indexLabel, value, element.id(), expiredTime, removed);
                break;
            }
            case UNIQUE: {
                String value = ConditionQuery.concatValues(allPropValues);
                assert (!"".equals(value));
                Id id = element.id();
                if (!removed && this.existUniqueValue(indexLabel, value, id)) {
                    throw new IllegalArgumentException(String.format("Unique constraint %s conflict is found for %s", indexLabel, element));
                }
                this.updateIndex(indexLabel, value, element.id(), expiredTime, removed);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown index type '%s'", indexLabel.indexType()));
            }
        }
    }

    private void updateIndex(IndexLabel indexLabel, Object propValue, Id elementId, long expiredTime, boolean removed) {
        HugeIndex index = new HugeIndex(this.graph(), indexLabel);
        index.fieldValues(propValue);
        index.elementIds(elementId, expiredTime);
        if (removed) {
            this.doEliminate(this.serializer.writeIndex(index));
        } else {
            this.doAppend(this.serializer.writeIndex(index));
        }
    }

    private boolean existUniqueValue(IndexLabel indexLabel, Object value, Id id) {
        return !this.hasEliminateInTx(indexLabel, value, id) && this.existUniqueValueInStore(indexLabel, value);
    }

    private boolean hasEliminateInTx(IndexLabel indexLabel, Object value, Id elementId) {
        HugeIndex index = new HugeIndex(this.graph(), indexLabel);
        index.fieldValues(value);
        index.elementIds(elementId);
        BackendEntry entry = this.serializer.writeIndex(index);
        return this.mutation().contains(entry, Action.ELIMINATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existUniqueValueInStore(IndexLabel indexLabel, Object value) {
        boolean exist;
        ConditionQuery query = new ConditionQuery(HugeType.UNIQUE_INDEX);
        query.eq(HugeKeys.INDEX_LABEL_ID, indexLabel.id());
        query.eq(HugeKeys.FIELD_VALUES, value);
        Iterator<BackendEntry> iterator = this.query(query).iterator();
        try {
            exist = iterator.hasNext();
            if (exist) {
                HugeIndex index = this.serializer.readIndex(this.graph(), query, iterator.next());
                this.removeExpiredIndexIfNeeded(index, query.showExpired());
                if (index.elementIds().isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                LOG.debug("Already has existed unique index record {}", (Object)index.elementId());
            }
            while (iterator.hasNext()) {
                LOG.warn("Unique constraint conflict found by record {}", (Object)iterator.next());
            }
        }
        finally {
            CloseableIterator.closeIterator(iterator);
        }
        return exist;
    }

    @PerfUtil.Watched(prefix="index")
    public IdHolderList queryIndex(ConditionQuery query) {
        query.checkFlattened();
        if (this.hasUpdate()) {
            throw new HugeException("Can't do index query when there are changes in transaction");
        }
        List<Condition> conds = query.syspropConditions();
        if (conds.size() > 1 || conds.size() == 1 && !query.containsCondition(HugeKeys.LABEL)) {
            throw new HugeException("Can't do index query with %s and %s", conds, query.userpropConditions());
        }
        query.optimized(ConditionQuery.OptimizedType.INDEX);
        if (query.allSysprop() && conds.size() == 1 && query.containsCondition(HugeKeys.LABEL)) {
            return this.queryByLabel(query);
        }
        return this.queryByUserprop(query);
    }

    @PerfUtil.Watched(prefix="index")
    private IdHolderList queryByLabel(ConditionQuery query) {
        SchemaLabel schemaLabel;
        HugeType indexType;
        HugeType queryType = query.resultType();
        IndexLabel il = IndexLabel.label(queryType);
        GraphIndexTransaction.validateIndexLabel(il);
        Id label = (Id)query.condition((Object)HugeKeys.LABEL);
        assert (label != null);
        if (queryType.isVertex()) {
            indexType = HugeType.VERTEX_LABEL_INDEX;
            schemaLabel = this.graph().vertexLabel(label);
        } else if (queryType.isEdge()) {
            indexType = HugeType.EDGE_LABEL_INDEX;
            schemaLabel = this.graph().edgeLabel(label);
        } else {
            throw new HugeException("Can't query %s by label", queryType);
        }
        if (!this.store().features().supportsQueryByLabel() && !schemaLabel.enableLabelIndex()) {
            throw new NoIndexException("Don't accept query by label '%s', label index is disabled", schemaLabel);
        }
        ConditionQuery indexQuery = new ConditionQuery(indexType, query);
        indexQuery.eq(HugeKeys.INDEX_LABEL_ID, il.id());
        indexQuery.eq(HugeKeys.FIELD_VALUES, label);
        indexQuery.copyBasic(query);
        indexQuery.limit(Long.MAX_VALUE);
        IdHolder idHolder = this.doIndexQuery(il, indexQuery);
        IdHolderList holders = new IdHolderList(query.paging());
        holders.add(idHolder);
        return holders;
    }

    @PerfUtil.Watched(prefix="index")
    private IdHolderList queryByUserprop(ConditionQuery query) {
        Set<MatchedIndex> indexes;
        if (!this.graph().readMode().showOlap()) {
            for (Id pkId : query.userpropKeys()) {
                PropertyKey propertyKey = this.graph().propertyKey(pkId);
                if (!propertyKey.olap()) continue;
                throw new NotAllowException("Not allowed to query by olap property key '%s' when graph-read-mode is '%s'", new Object[]{propertyKey, this.graph().readMode()});
            }
        }
        if ((indexes = this.collectMatchedIndexes(query)).isEmpty()) {
            Id label = (Id)query.condition((Object)HugeKeys.LABEL);
            throw GraphIndexTransaction.noIndexException(this.graph(), query, label);
        }
        boolean paging = query.paging();
        if (!GraphIndexTransaction.validQueryConditionValues(this.graph(), query)) {
            return IdHolderList.empty(paging);
        }
        IdHolderList holders = new IdHolderList(paging);
        for (MatchedIndex index : indexes) {
            for (IndexLabel il : index.indexLabels()) {
                GraphIndexTransaction.validateIndexLabel(il);
            }
            if (paging && index.indexLabels().size() > 1) {
                throw new NotSupportException("joint index query in paging");
            }
            if (index.containsSearchIndex()) {
                holders.addAll(this.doSearchIndex(query, index));
                continue;
            }
            IndexQueries queries = index.constructIndexQueries(query);
            assert (!paging || queries.size() <= 1);
            IdHolder holder = this.doSingleOrJointIndex(queries);
            holders.add(holder);
        }
        return holders;
    }

    @PerfUtil.Watched(prefix="index")
    private IdHolderList doSearchIndex(ConditionQuery query, MatchedIndex index) {
        query = this.constructSearchQuery(query, index);
        SortByCountIdHolderList holders = new SortByCountIdHolderList(query.paging());
        List<ConditionQuery> flatten = ConditionQueryFlatten.flatten(query);
        for (ConditionQuery q : flatten) {
            if (!q.noLimit() && flatten.size() > 1) {
                GraphIndexTransaction.increaseLimit(q);
            }
            IndexQueries queries = index.constructIndexQueries(q);
            assert (!query.paging() || queries.size() <= 1);
            IdHolder holder = this.doSingleOrJointIndex(queries);
            ((IdHolderList)holders).add(holder);
        }
        return holders;
    }

    @PerfUtil.Watched(prefix="index")
    private IdHolder doSingleOrJointIndex(IndexQueries queries) {
        if (queries.size() == 1) {
            return this.doSingleOrCompositeIndex(queries);
        }
        return this.doJointIndex(queries);
    }

    @PerfUtil.Watched(prefix="index")
    private IdHolder doSingleOrCompositeIndex(IndexQueries queries) {
        assert (queries.size() == 1);
        Map.Entry<IndexLabel, ConditionQuery> entry = queries.one();
        IndexLabel indexLabel = entry.getKey();
        ConditionQuery query = entry.getValue();
        return this.doIndexQuery(indexLabel, query);
    }

    @PerfUtil.Watched(prefix="index")
    private IdHolder doJointIndex(IndexQueries queries) {
        if (queries.oomRisk()) {
            LOG.warn("There is OOM risk if the joint operation is based on a large amount of data, please use single index + filter instead of joint index: {}", (Object)queries.rootQuery());
        }
        Set<Id> intersectIds = null;
        boolean filtering = false;
        IdHolder resultHolder = null;
        for (Map.Entry e : queries.entrySet()) {
            IndexLabel indexLabel = (IndexLabel)e.getKey();
            ConditionQuery query = (ConditionQuery)e.getValue();
            assert (!query.paging());
            if (!query.noLimit() && queries.size() > 1) {
                query.limit(Long.MAX_VALUE);
            }
            IdHolder holder = this.doIndexQuery(indexLabel, query);
            if (resultHolder == null) {
                resultHolder = holder;
                this.storeSelectedIndexField(indexLabel, query);
            }
            assert (this.indexIntersectThresh > 0);
            Set<Id> ids = ((IdHolder.BatchIdHolder)holder).peekNext(this.indexIntersectThresh).ids();
            if (ids.size() >= this.indexIntersectThresh) {
                filtering = true;
                query.optimized(ConditionQuery.OptimizedType.INDEX_FILTER);
                continue;
            }
            if (filtering) {
                assert (ids.size() < this.indexIntersectThresh);
                resultHolder = holder;
                this.storeSelectedIndexField(indexLabel, query);
                break;
            }
            if (intersectIds == null) {
                intersectIds = ids;
            } else {
                CollectionUtil.intersectWithModify(intersectIds, ids);
            }
            if (!intersectIds.isEmpty()) continue;
            break;
        }
        if (filtering) {
            return resultHolder;
        }
        assert (intersectIds != null);
        return new IdHolder.FixedIdHolder(queries.asJointQuery(), intersectIds);
    }

    private void storeSelectedIndexField(IndexLabel indexLabel, ConditionQuery query) {
        if (!indexLabel.indexType().isRange()) {
            return;
        }
        ConditionQuery originConditionQuery = query.originConditionQuery();
        if (originConditionQuery != null) {
            originConditionQuery.selectedIndexField(indexLabel.indexField());
        }
    }

    @PerfUtil.Watched(prefix="index")
    private IdHolder doIndexQuery(IndexLabel indexLabel, ConditionQuery query) {
        if (!query.paging()) {
            return this.doIndexQueryBatch(indexLabel, query);
        }
        return new IdHolder.PagingIdHolder(query, q -> this.doIndexQueryOnce(indexLabel, (ConditionQuery)q));
    }

    @PerfUtil.Watched(prefix="index")
    private IdHolder doIndexQueryBatch(IndexLabel indexLabel, ConditionQuery query) {
        Iterator<BackendEntry> entries = super.query(query).iterator();
        return new IdHolder.BatchIdHolder(query, entries, batch -> {
            LockUtil.Locks locks = new LockUtil.Locks(this.graphName());
            try {
                locks.lockReads("il_delete", indexLabel.id());
                locks.lockReads("il_rebuild", indexLabel.id());
                if (!indexLabel.system()) {
                    this.graph().indexLabel(indexLabel.id());
                }
                Set ids = InsertionOrderUtil.newSet();
                while ((batch == Long.MAX_VALUE || (long)ids.size() < batch) && entries.hasNext()) {
                    HugeIndex index = this.serializer.readIndex(this.graph(), query, (BackendEntry)entries.next());
                    this.removeExpiredIndexIfNeeded(index, query.showExpired());
                    ids.addAll(index.elementIds());
                    Query.checkForceCapacity(ids.size());
                    this.recordIndexValue(query, index);
                }
                Set set = ids;
                return set;
            }
            finally {
                locks.unlock();
            }
        });
    }

    private void recordIndexValue(ConditionQuery query, HugeIndex index) {
        if (!GraphIndexTransaction.shouldRecordIndexValue(query, index)) {
            return;
        }
        ConditionQuery originQuery = query.originConditionQuery();
        Id fieldId = index.indexLabel().indexField();
        for (Id id : index.elementIds()) {
            Object value = index.indexLabel().validValue(index.fieldValues());
            originQuery.recordIndexValue(fieldId, id, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PerfUtil.Watched(prefix="index")
    private PageIds doIndexQueryOnce(IndexLabel indexLabel, ConditionQuery query) {
        Iterator<BackendEntry> entries = null;
        LockUtil.Locks locks = new LockUtil.Locks(this.graphName());
        try {
            PageIds pageIds;
            locks.lockReads("il_delete", indexLabel.id());
            locks.lockReads("il_rebuild", indexLabel.id());
            Set ids = InsertionOrderUtil.newSet();
            entries = super.query(query).iterator();
            while (entries.hasNext()) {
                HugeIndex index = this.serializer.readIndex(this.graph(), query, entries.next());
                this.removeExpiredIndexIfNeeded(index, query.showExpired());
                ids.addAll(index.elementIds());
                if (query.reachLimit(ids.size())) break;
                Query.checkForceCapacity(ids.size());
                this.recordIndexValue(query, index);
            }
            if (ids.isEmpty()) {
                pageIds = PageIds.EMPTY;
                return pageIds;
            }
            if (!query.paging()) {
                pageIds = new PageIds(ids, PageState.EMPTY);
                return pageIds;
            }
            E.checkState((boolean)(entries instanceof Metadatable), (String)"The entries must be Metadatable when query in paging, but got '%s'", (Object[])new Object[]{entries.getClass().getName()});
            pageIds = new PageIds(ids, PageInfo.pageState(entries));
            return pageIds;
        }
        finally {
            locks.unlock();
            CloseableIterator.closeIterator(entries);
        }
    }

    @PerfUtil.Watched(prefix="index")
    private Set<MatchedIndex> collectMatchedIndexes(ConditionQuery query) {
        ImmutableList schemaLabels;
        ISchemaTransaction schema = this.params().schemaTransaction();
        Id label = (Id)query.condition((Object)HugeKeys.LABEL);
        if (label != null) {
            SchemaLabel schemaLabel;
            if (query.resultType().isVertex()) {
                schemaLabel = schema.getVertexLabel(label);
            } else if (query.resultType().isEdge()) {
                schemaLabel = schema.getEdgeLabel(label);
            } else {
                throw new AssertionError((Object)String.format("Unsupported index query type: %s", query.resultType()));
            }
            schemaLabels = ImmutableList.of((Object)schemaLabel);
        } else if (query.resultType().isVertex()) {
            schemaLabels = schema.getVertexLabels();
        } else if (query.resultType().isEdge()) {
            schemaLabels = schema.getEdgeLabels();
        } else {
            throw new AssertionError((Object)String.format("Unsupported index query type: %s", query.resultType()));
        }
        Set matchedIndexes = InsertionOrderUtil.newSet();
        for (SchemaLabel schemaLabel : schemaLabels) {
            MatchedIndex index = this.collectMatchedIndex(schemaLabel, query);
            if (index == null) continue;
            matchedIndexes.add(index);
        }
        return matchedIndexes;
    }

    @PerfUtil.Watched(prefix="index")
    private MatchedIndex collectMatchedIndex(SchemaLabel schemaLabel, ConditionQuery query) {
        ISchemaTransaction schema = this.params().schemaTransaction();
        Set ils = InsertionOrderUtil.newSet();
        for (Id id : schemaLabel.indexLabels()) {
            IndexLabel indexLabel = schema.getIndexLabel(id);
            if (indexLabel == null || indexLabel.indexType().isUnique()) continue;
            ils.add(indexLabel);
        }
        if (this.graph().readMode().showOlap()) {
            for (IndexLabel indexLabel : schema.getIndexLabels()) {
                if (!indexLabel.olap()) continue;
                ils.add(indexLabel);
            }
        }
        if (ils.isEmpty()) {
            return null;
        }
        Set<IndexLabel> matchedILs = GraphIndexTransaction.matchSingleOrCompositeIndex(query, ils);
        if (matchedILs.isEmpty()) {
            matchedILs = GraphIndexTransaction.matchJointIndexes(query, ils);
        }
        if (!matchedILs.isEmpty()) {
            return new MatchedIndex(schemaLabel, matchedILs);
        }
        return null;
    }

    private ConditionQuery constructSearchQuery(ConditionQuery query, MatchedIndex index) {
        ConditionQuery newQuery = query;
        HashSet<Id> indexFields = new HashSet<Id>();
        for (IndexLabel il : index.indexLabels()) {
            if (il.indexType() != IndexType.SEARCH) continue;
            Id indexField = il.indexField();
            String fieldValue = (String)newQuery.userpropValue(indexField);
            Set<String> words = this.segmentWords(fieldValue);
            indexFields.add(indexField);
            newQuery = newQuery.copy();
            newQuery.unsetCondition(indexField);
            newQuery.query(Condition.textContainsAny(indexField, words));
        }
        newQuery.registerResultsFilter(element -> {
            assert (element != null);
            for (Condition cond : query.conditions()) {
                Object key;
                Object object = key = cond.isRelation() ? ((Condition.Relation)cond).key() : null;
                if (key instanceof Id && indexFields.contains(key)) {
                    String fieldValue;
                    Id field = (Id)key;
                    HugeProperty property = element.getProperty(field);
                    String propValue = GraphIndexTransaction.propertyValueToString(property.value());
                    if (this.matchSearchIndexWords(propValue, fieldValue = (String)query.userpropValue(field))) continue;
                    return false;
                }
                if (cond.test(element)) continue;
                return false;
            }
            return true;
        });
        return newQuery;
    }

    private boolean matchSearchIndexWords(String propValue, String fieldValue) {
        Set<String> propValues = this.segmentWords(propValue);
        Set<String> words = this.segmentWords(fieldValue);
        return CollectionUtil.hasIntersection(propValues, words);
    }

    private Set<String> segmentWords(String text) {
        if (text.startsWith(START_SYMBOL) && text.endsWith(END_SYMBOL)) {
            String subText = text.substring(1, text.length() - 1);
            if (subText.contains(WORD_DELIMITER)) {
                Object[] texts = StringUtils.split((String)subText, (String)WORD_DELIMITER);
                return ImmutableSet.copyOf((Object[])texts);
            }
            return ImmutableSet.of((Object)subText);
        }
        Set<String> segments = this.textAnalyzer.segment(text);
        segments.add(text);
        segments.removeAll(ConditionQuery.IGNORE_SYM_SET);
        return segments;
    }

    private boolean needIndexForLabel() {
        return !this.store().features().supportsQueryByLabel();
    }

    private void removeExpiredIndexIfNeeded(HugeIndex index, boolean showExpired) {
        if (this.store().features().supportsTtl() || showExpired) {
            return;
        }
        for (HugeIndex.IdWithExpiredTime id : index.expiredElementIds()) {
            HugeIndex removeIndex = index.clone();
            removeIndex.resetElementIds();
            removeIndex.elementIds(id.id(), id.expiredTime());
            DeleteExpiredJob.asyncDeleteExpiredObject(this.graph(), removeIndex);
        }
    }

    private static Set<IndexLabel> matchSingleOrCompositeIndex(ConditionQuery query, Set<IndexLabel> indexLabels) {
        if (query.hasNeqCondition()) {
            return ImmutableSet.of();
        }
        boolean requireRange = query.hasRangeCondition();
        boolean requireSearch = query.hasSearchCondition();
        Set<Id> queryPropKeys = query.userpropKeys();
        for (IndexLabel indexLabel : indexLabels) {
            List<Id> indexFields = indexLabel.indexFields();
            if (!GraphIndexTransaction.matchIndexFields(queryPropKeys, indexFields)) continue;
            IndexType indexType = indexLabel.indexType();
            if (requireSearch && !indexType.isSearch() || !requireSearch && indexType.isSearch() || requireRange && !indexType.isNumeric()) continue;
            return ImmutableSet.of((Object)indexLabel);
        }
        return ImmutableSet.of();
    }

    private static Set<IndexLabel> matchJointIndexes(ConditionQuery query, Set<IndexLabel> indexLabels) {
        if (query.hasNeqCondition()) {
            return ImmutableSet.of();
        }
        Set<Id> queryPropKeys = query.userpropKeys();
        assert (!queryPropKeys.isEmpty());
        Set allILs = InsertionOrderUtil.newSet(indexLabels);
        Set<IndexLabel> matchedIndexLabels = InsertionOrderUtil.newSet();
        if (query.hasRangeCondition() || query.hasSearchCondition()) {
            matchedIndexLabels = GraphIndexTransaction.matchRangeOrSearchIndexLabels(query, allILs);
            if (matchedIndexLabels.isEmpty()) {
                return ImmutableSet.of();
            }
            allILs.removeAll(matchedIndexLabels);
            for (IndexLabel il : matchedIndexLabels) {
                queryPropKeys.remove(il.indexField());
            }
            if (queryPropKeys.isEmpty()) {
                return matchedIndexLabels;
            }
        }
        Set indexFields = InsertionOrderUtil.newSet();
        for (IndexLabel indexLabel : allILs) {
            if (indexLabel.indexType().isSearch()) continue;
            List<Id> fields = indexLabel.indexFields();
            for (Id field : fields) {
                if (!queryPropKeys.contains(field)) break;
                matchedIndexLabels.add(indexLabel);
                indexFields.add(field);
            }
        }
        if (indexFields.equals(queryPropKeys)) {
            return matchedIndexLabels;
        }
        return ImmutableSet.of();
    }

    private static Set<IndexLabel> matchRangeOrSearchIndexLabels(ConditionQuery query, Set<IndexLabel> indexLabels) {
        Set matchedIndexLabels = InsertionOrderUtil.newSet();
        for (Condition.Relation relation : query.userpropRelations()) {
            if (!relation.relation().isRangeType() && !relation.relation().isSearchType()) continue;
            Id key = (Id)relation.key();
            boolean matched = false;
            for (IndexLabel indexLabel : indexLabels) {
                if (!indexLabel.indexType().isRange() && !indexLabel.indexType().isSearch() || !indexLabel.indexField().equals(key)) continue;
                matched = true;
                matchedIndexLabels.add(indexLabel);
                break;
            }
            if (matched) continue;
            return ImmutableSet.of();
        }
        return matchedIndexLabels;
    }

    private static IndexQueries buildJointIndexesQueries(ConditionQuery query, MatchedIndex index) {
        IndexQueries queries = IndexQueries.of(query);
        ArrayList<IndexLabel> allILs = new ArrayList<IndexLabel>(index.indexLabels());
        if (query.hasRangeCondition() || query.hasSearchCondition()) {
            Set<IndexLabel> matchedILs = GraphIndexTransaction.matchRangeOrSearchIndexLabels(query, index.indexLabels());
            assert (!matchedILs.isEmpty());
            allILs.removeAll(matchedILs);
            Set queryPropKeys = InsertionOrderUtil.newSet();
            for (IndexLabel il : matchedILs) {
                queryPropKeys.add(il.indexField());
            }
            queries.putAll(GraphIndexTransaction.constructQueries(query, matchedILs, queryPropKeys));
            query = query.copy();
            for (Id field : queryPropKeys) {
                query.unsetCondition(field);
            }
            if (query.userpropKeys().isEmpty()) {
                return queries;
            }
        }
        ConditionQuery finalQuery = query;
        int size = allILs.size();
        for (int i = 1; i <= size; ++i) {
            boolean found = GraphIndexTransaction.cmn(allILs, size, i, 0, null, r -> {
                IndexQueries qs = GraphIndexTransaction.constructJointSecondaryQueries(finalQuery, r);
                if (qs.isEmpty()) {
                    return false;
                }
                queries.putAll(qs);
                return true;
            });
            if (!found) continue;
            return queries;
        }
        return IndexQueries.EMPTY;
    }

    private static <T> boolean cmn(List<T> all, int m, int n, int current, List<T> result, Function<List<T>, Boolean> callback) {
        assert (m <= all.size());
        assert (n <= m);
        assert (current <= all.size());
        if (result == null) {
            result = new ArrayList<T>(n);
        }
        int index = result.size();
        if (m == n) {
            result.addAll(all.subList(current, all.size()));
            n = 0;
        }
        if (n == 0) {
            Boolean apply = callback.apply(result);
            while (index < result.size()) {
                result.remove(index);
            }
            return apply;
        }
        if (current >= all.size()) {
            return false;
        }
        result.add(all.get(current));
        if (GraphIndexTransaction.cmn(all, m - 1, n - 1, ++current, result, callback)) {
            return true;
        }
        result.remove(index);
        return GraphIndexTransaction.cmn(all, m - 1, n, current, result, callback);
    }

    private static boolean shouldRecordIndexValue(ConditionQuery query, HugeIndex index) {
        return query.originQuery() instanceof ConditionQuery && index.indexLabel().indexType().isRange();
    }

    private static IndexQueries constructJointSecondaryQueries(ConditionQuery query, List<IndexLabel> ils) {
        Set<IndexLabel> indexLabels = InsertionOrderUtil.newSet();
        indexLabels.addAll(ils);
        indexLabels = GraphIndexTransaction.matchJointIndexes(query, indexLabels);
        if (indexLabels.isEmpty()) {
            return IndexQueries.EMPTY;
        }
        return GraphIndexTransaction.constructQueries(query, indexLabels, query.userpropKeys());
    }

    private static IndexQueries constructQueries(ConditionQuery query, Set<IndexLabel> ils, Set<Id> propKeys) {
        IndexQueries queries = IndexQueries.of(query);
        for (IndexLabel il : ils) {
            List<Id> fields = il.indexFields();
            ConditionQuery newQuery = query.copy();
            newQuery.resetUserpropConditions();
            for (Id field : fields) {
                if (!propKeys.contains(field)) break;
                for (Condition c : query.userpropConditions(field)) {
                    newQuery.query(c);
                }
            }
            ConditionQuery q = GraphIndexTransaction.constructQuery(newQuery, il);
            assert (q != null);
            queries.put(il, q);
        }
        return queries;
    }

    private static ConditionQuery constructQuery(ConditionQuery query, IndexLabel indexLabel) {
        ConditionQuery indexQuery;
        List<Id> indexFields;
        IndexType indexType = indexLabel.indexType();
        boolean requireRange = query.hasRangeCondition();
        boolean supportRange = indexType.isNumeric();
        if (requireRange && !supportRange) {
            LOG.debug("There is range query condition in '{}', but the index label '{}' is unable to match", (Object)query, (Object)indexLabel.name());
            return null;
        }
        Set<Id> queryKeys = query.userpropKeys();
        if (!GraphIndexTransaction.matchIndexFields(queryKeys, indexFields = indexLabel.indexFields())) {
            return null;
        }
        LOG.debug("Matched index fields: {} of index '{}'", indexFields, (Object)indexLabel);
        switch (indexType) {
            case SEARCH: {
                E.checkState((indexFields.size() == 1 ? 1 : 0) != 0, (String)"Invalid index fields size for %s: %s", (Object[])new Object[]{indexType, indexFields});
                Object fieldValue = query.userpropValue(indexFields.get(0));
                assert (fieldValue instanceof String);
                fieldValue = ConditionQuery.concatValues(fieldValue);
                indexQuery = new ConditionQuery(indexType.type(), query);
                indexQuery.eq(HugeKeys.INDEX_LABEL_ID, indexLabel.id());
                indexQuery.eq(HugeKeys.FIELD_VALUES, fieldValue);
                break;
            }
            case SECONDARY: {
                List<Id> joinedKeys = indexFields.subList(0, queryKeys.size());
                String joinedValues = query.userpropValuesString(joinedKeys);
                indexQuery = new ConditionQuery(indexType.type(), query);
                indexQuery.eq(HugeKeys.INDEX_LABEL_ID, indexLabel.id());
                indexQuery.eq(HugeKeys.FIELD_VALUES, joinedValues);
                break;
            }
            case RANGE_INT: 
            case RANGE_FLOAT: 
            case RANGE_LONG: 
            case RANGE_DOUBLE: {
                if (query.userpropConditions().size() > 2) {
                    throw new HugeException("Range query has two conditions at most, but got: %s", query.userpropConditions());
                }
                indexQuery = new ConditionQuery(indexType.type(), query);
                indexQuery.eq(HugeKeys.INDEX_LABEL_ID, indexLabel.id());
                for (Condition condition : query.userpropConditions()) {
                    assert (condition instanceof Condition.Relation);
                    Condition.Relation r = (Condition.Relation)condition;
                    Number value = NumericUtil.convertToNumber((Object)r.value());
                    Condition.SyspropRelation sys = new Condition.SyspropRelation(HugeKeys.FIELD_VALUES, r.relation(), value);
                    condition = condition.replace(r, sys);
                    indexQuery.query(condition);
                }
                break;
            }
            case SHARD: {
                HugeType type = indexLabel.indexType().type();
                indexQuery = new ConditionQuery(type, query);
                indexQuery.eq(HugeKeys.INDEX_LABEL_ID, indexLabel.id());
                List<Condition> conditions = GraphIndexTransaction.constructShardConditions(query, indexLabel.indexFields(), HugeKeys.FIELD_VALUES);
                indexQuery.query(conditions);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown index type '%s'", indexType));
            }
        }
        indexQuery.page(query.page());
        indexQuery.limit(query.total());
        indexQuery.capacity(query.capacity());
        indexQuery.olap(indexLabel.olap());
        return indexQuery;
    }

    protected static List<Condition> constructShardConditions(ConditionQuery query, List<Id> fields, HugeKeys key) {
        String joinedValues;
        ArrayList<Condition> conditions = new ArrayList<Condition>(2);
        boolean hasRange = false;
        int processedCondCount = 0;
        ArrayList<Object> prefixes = new ArrayList<Object>();
        for (Id field : fields) {
            Object num;
            Condition.RelationType type;
            List<Condition> fieldConds = query.userpropConditions(field);
            processedCondCount += fieldConds.size();
            if (fieldConds.isEmpty()) break;
            Condition.RangeConditions range = new Condition.RangeConditions(fieldConds);
            if (!range.hasRange()) {
                E.checkArgument((range.keyEq() != null ? 1 : 0) != 0, (String)"Invalid query: %s", (Object[])new Object[]{query});
                prefixes.add(range.keyEq());
                continue;
            }
            if (range.keyMin() != null) {
                type = range.keyMinEq() ? Condition.RelationType.GTE : Condition.RelationType.GT;
                conditions.add(GraphIndexTransaction.shardFieldValuesCondition(key, prefixes, range.keyMin(), type));
            } else {
                assert (range.keyMax() != null);
                num = range.keyMax();
                num = NumericUtil.minValueOf(NumericUtil.isNumber((Object)num) ? num.getClass() : Long.class);
                conditions.add(GraphIndexTransaction.shardFieldValuesCondition(key, prefixes, num, Condition.RelationType.GTE));
            }
            if (range.keyMax() != null) {
                type = range.keyMaxEq() ? Condition.RelationType.LTE : Condition.RelationType.LT;
                conditions.add(GraphIndexTransaction.shardFieldValuesCondition(key, prefixes, range.keyMax(), type));
            } else {
                num = range.keyMin();
                num = NumericUtil.maxValueOf(NumericUtil.isNumber((Object)num) ? num.getClass() : Long.class);
                conditions.add(GraphIndexTransaction.shardFieldValuesCondition(key, prefixes, num, Condition.RelationType.LTE));
            }
            hasRange = true;
            break;
        }
        if (key == HugeKeys.FIELD_VALUES && processedCondCount < query.userpropKeys().size()) {
            throw new HugeException("Invalid shard index query: %s", query);
        }
        if (hasRange) {
            return conditions;
        }
        if (prefixes.size() == fields.size()) {
            joinedValues = ConditionQuery.concatValues(prefixes);
            conditions.add(Condition.eq(key, (Object)joinedValues));
            return conditions;
        }
        prefixes.add("<empty>");
        joinedValues = ConditionQuery.concatValues(prefixes);
        Condition.Relation min = Condition.gte(key, (Object)joinedValues);
        conditions.add(min);
        Condition.Relation max = Condition.lt(key, (Object)GraphIndexTransaction.increaseString(joinedValues));
        conditions.add(max);
        return conditions;
    }

    private static Condition.Relation shardFieldValuesCondition(HugeKeys key, List<Object> prefixes, Object number, Condition.RelationType type) {
        ArrayList<Object> values = new ArrayList<Object>(prefixes);
        String num = LongEncoding.encodeNumber((Object)number);
        if (type == Condition.RelationType.LTE) {
            type = Condition.RelationType.LT;
            num = GraphIndexTransaction.increaseString(num);
        } else if (type == Condition.RelationType.GT) {
            type = Condition.RelationType.GTE;
            num = GraphIndexTransaction.increaseString(num);
        }
        values.add(num);
        String value = ConditionQuery.concatValues(values);
        return new Condition.SyspropRelation(key, type, value);
    }

    private static String increaseString(String value) {
        int lastIndex;
        int length = value.length();
        CharBuffer cbuf = CharBuffer.wrap(value.toCharArray());
        char last = cbuf.charAt(lastIndex = length - 1);
        E.checkArgument((last == '!' || LongEncoding.validB64Char((char)last) ? 1 : 0) != 0, (String)"Illegal ending char '\\u%s' for String Index", (Object[])new Object[]{(int)last});
        cbuf.put(lastIndex, (char)(last + '\u0001'));
        return cbuf.toString();
    }

    private static boolean matchIndexFields(Set<Id> queryKeys, List<Id> indexFields) {
        if (queryKeys.size() > indexFields.size()) {
            return false;
        }
        List<Id> subFields = indexFields.subList(0, queryKeys.size());
        return subFields.containsAll(queryKeys);
    }

    private static boolean validQueryConditionValues(HugeGraph graph, ConditionQuery query) {
        Set<Id> keys = query.userpropKeys();
        for (Id key : keys) {
            PropertyKey pk = graph.propertyKey(key);
            Set<Object> values = query.userpropValues(key);
            E.checkState((!values.isEmpty() ? 1 : 0) != 0, (String)"Expect user property values for key '%s', but got none", (Object[])new Object[]{pk});
            boolean hasContains = query.containsContainsCondition(key);
            if (pk.cardinality().multiple()) {
                E.checkState((boolean)hasContains, (String)"The relation of property '%s' must be CONTAINS or TEXT_CONTAINS, but got %s", (Object[])new Object[]{pk.name(), query.relation(key).relation()});
            }
            for (Object value : values) {
                if (hasContains) {
                    value = GraphIndexTransaction.toCollectionIfNeeded(pk, value);
                }
                if (pk.checkValueType(value)) continue;
                return false;
            }
        }
        return true;
    }

    private static Object toCollectionIfNeeded(PropertyKey pk, Object value) {
        switch (pk.cardinality()) {
            case SET: {
                if (value instanceof Set) break;
                value = CollectionUtil.toSet((Object)value);
                break;
            }
            case LIST: {
                if (value instanceof List) break;
                value = CollectionUtil.toList((Object)value);
                break;
            }
        }
        return value;
    }

    private static boolean isCollectionIndex(List<Object> propValues) {
        return propValues.size() == 1 && propValues.get(0) instanceof Collection;
    }

    private static String propertyValueToString(Object value) {
        return value instanceof Collection ? StringUtils.join((Iterable)((Iterable)value), (String)" ") : value.toString();
    }

    private static NoIndexException noIndexException(HugeGraph graph, ConditionQuery query, Id label) {
        String name = label == null ? "any label" : String.format("label '%s'", query.resultType().isVertex() ? graph.vertexLabel(label).name() : graph.edgeLabel(label).name());
        ArrayList<String> mismatched = new ArrayList<String>();
        if (query.hasSecondaryCondition()) {
            mismatched.add("secondary");
        }
        if (query.hasRangeCondition()) {
            mismatched.add("range");
        }
        if (query.hasSearchCondition()) {
            mismatched.add("search");
        }
        if (query.hasNeqCondition()) {
            mismatched.add("not-equal");
        }
        if (mismatched.isEmpty()) {
            mismatched.add(query.relations().toString());
        }
        return new NoIndexException("Don't accept query based on properties %s that are not indexed in %s, may not match %s condition", graph.mapPkId2Name(query.userpropKeys()), name, String.join((CharSequence)"/", mismatched));
    }

    private static void validateIndexLabel(IndexLabel indexLabel) {
        E.checkArgument((boolean)indexLabel.status().ok(), (String)"Can't query by label index '%s' due to it's in status %s(CREATED expected)", (Object[])new Object[]{indexLabel, indexLabel.status()});
    }

    private static boolean hasNullableProp(HugeElement element, Id key) {
        return element.schemaLabel().nullableKeys().contains(key);
    }

    private static Set<IndexLabel> relatedIndexLabels(HugeElement element) {
        Set indexLabels = InsertionOrderUtil.newSet();
        Set<Id> indexLabelIds = element.schemaLabel().indexLabels();
        for (Id id : indexLabelIds) {
            IndexLabel indexLabel = element.graph().indexLabel(id);
            indexLabels.add(indexLabel);
        }
        return indexLabels;
    }

    private static void increaseLimit(Query query) {
        assert (!query.noLimit());
        if (!query.paging()) {
            long limit = Math.min(query.limit() * 10L + 8L, 800000L);
            query.limit(limit);
        }
    }

    protected void removeIndex(IndexLabel indexLabel) {
        HugeIndex index = new HugeIndex(this.graph(), indexLabel);
        this.doRemove(this.serializer.writeIndex(index));
    }

    public static class RemoveLeftIndexJob
    extends EphemeralJob<Long>
    implements EphemeralJobQueue.Reduce<Long> {
        private static final String REMOVE_LEFT_INDEX = "remove_left_index";
        private final ConditionQuery query;
        private final HugeElement element;
        private GraphIndexTransaction tx;
        private Set<ConditionQuery.LeftIndex> leftIndexes;

        private RemoveLeftIndexJob(ConditionQuery query, HugeElement element) {
            E.checkArgumentNotNull((Object)query, (String)"query", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)element, (String)"element", (Object[])new Object[0]);
            this.query = query;
            this.element = element;
            this.tx = null;
            this.leftIndexes = query.getLeftIndexOfElement(element.id());
        }

        @Override
        public String type() {
            return REMOVE_LEFT_INDEX;
        }

        @Override
        public Long execute() {
            this.tx = this.element.schemaLabel().system() ? this.params().systemTransaction().indexTransaction() : this.params().graphTransaction().indexTransaction();
            return this.removeIndexLeft(this.query, this.element);
        }

        protected long removeIndexLeft(ConditionQuery query, HugeElement element) {
            if (element.type() != HugeType.VERTEX && element.type() != HugeType.EDGE_OUT && element.type() != HugeType.EDGE_IN && element.type() != HugeType.TASK && element.type() != HugeType.SERVER) {
                throw new HugeException("Only accept element of type VERTEX and EDGE to remove left index, but got: '%s'", element.type());
            }
            Id label = (Id)query.condition((Object)HugeKeys.LABEL);
            if (label != null && !element.schemaLabel().id().equals(label)) {
                String labelName = element.type().isVertex() ? this.graph().vertexLabel(label).name() : this.graph().edgeLabel(label).name();
                E.checkState((boolean)false, (String)"Found element %s with unexpected label '%s', expected label '%s', query: %s", (Object[])new Object[]{element, element.label(), labelName, query});
            }
            long rCount = 0L;
            long sCount = 0L;
            for (ConditionQuery cq : ConditionQueryFlatten.flatten(query)) {
                rCount += this.processRangeIndexLeft(cq, element);
                sCount += this.processSecondaryOrSearchIndexLeft(cq, element);
            }
            return rCount + sCount;
        }

        private long processRangeIndexLeft(ConditionQuery query, HugeElement element) {
            long count = 0L;
            if (this.leftIndexes == null) {
                return count;
            }
            for (ConditionQuery.LeftIndex leftIndex : this.leftIndexes) {
                Set<Object> indexValues = leftIndex.indexFieldValues();
                IndexLabel indexLabel = this.findMatchedIndexLabel(query, leftIndex);
                assert (indexLabel != null);
                AbstractSerializer serializer = this.tx.serializer;
                for (Object value : indexValues) {
                    HugeIndex index = new HugeIndex(this.graph(), indexLabel);
                    index.elementIds(element.id());
                    index.fieldValues(value);
                    this.tx.doEliminate(serializer.writeIndex(index));
                    ++count;
                }
            }
            this.query.removeElementLeftIndex(element.id());
            return count;
        }

        private IndexLabel findMatchedIndexLabel(ConditionQuery query, ConditionQuery.LeftIndex leftIndex) {
            Set<MatchedIndex> matchedIndexes = this.tx.collectMatchedIndexes(query);
            for (MatchedIndex index : matchedIndexes) {
                for (IndexLabel label : index.indexLabels()) {
                    if (!label.indexField().equals(leftIndex.indexField())) continue;
                    return label;
                }
            }
            return null;
        }

        private long processSecondaryOrSearchIndexLeft(ConditionQuery query, HugeElement element) {
            Map incorrectPKs = InsertionOrderUtil.newMap();
            HugeElement deletion = this.constructErrorElem(query, element, incorrectPKs);
            if (deletion == null) {
                return 0L;
            }
            long count = 0L;
            for (IndexLabel il : GraphIndexTransaction.relatedIndexLabels(deletion)) {
                Set incorrectPkIds = incorrectPKs.keySet().stream().map(SchemaElement::id).collect(Collectors.toSet());
                Collection incorrectIndexFields = CollectionUtil.intersect(il.indexFields(), incorrectPkIds);
                if (incorrectIndexFields.isEmpty()) continue;
                if (il.indexType().isSearch()) {
                    Id field = il.indexField();
                    String cond = (String)deletion.getPropertyValue(field);
                    String actual = (String)element.getPropertyValue(field);
                    if (this.tx.matchSearchIndexWords(actual, cond)) continue;
                }
                this.tx.updateIndex(il.id(), deletion, true);
                if (il.indexType().isSecondary()) {
                    this.tx.updateIndex(il.id(), element, false);
                }
                if (this.deletedByError(element, incorrectIndexFields, incorrectPKs)) {
                    this.tx.updateIndex(il.id(), deletion, false);
                    continue;
                }
                ++count;
            }
            return count;
        }

        private HugeElement constructErrorElem(ConditionQuery query, HugeElement element, Map<PropertyKey, Object> incorrectPKs) {
            HugeElement errorElem = element.copyAsFresh();
            Set<Id> propKeys = query.userpropKeys();
            for (Id key : propKeys) {
                Set<Object> conditionValues = query.userpropValues(key);
                E.checkState((!conditionValues.isEmpty() ? 1 : 0) != 0, (String)"Expect user property values for key '%s', but got none", (Object[])new Object[]{key});
                if (conditionValues.size() > 1) {
                    return null;
                }
                HugeProperty prop = element.getProperty(key);
                Object errorValue = conditionValues.iterator().next();
                if (prop != null && Objects.equals(prop.value(), errorValue)) continue;
                PropertyKey pkey = this.graph().propertyKey(key);
                errorElem.addProperty(pkey, errorValue);
                incorrectPKs.put(pkey, errorValue);
            }
            return errorElem;
        }

        private boolean deletedByError(ConditionQuery query, HugeElement element) {
            HugeElement elem = this.newestElement(element);
            if (elem == null) {
                return false;
            }
            return query.test(elem);
        }

        private boolean deletedByError(HugeElement element, Collection<Id> ilFields, Map<PropertyKey, Object> incorrectPKs) {
            HugeElement elem = this.newestElement(element);
            if (elem == null) {
                return false;
            }
            for (Map.Entry<PropertyKey, Object> e : incorrectPKs.entrySet()) {
                PropertyKey pk = e.getKey();
                Object value = e.getValue();
                if (!ilFields.contains(pk.id()) || !value.equals(elem.getPropertyValue(pk.id()))) continue;
                return true;
            }
            return false;
        }

        private HugeElement newestElement(HugeElement element) {
            boolean isVertex = element instanceof HugeVertex;
            if (isVertex) {
                Iterator<Vertex> iter = this.graph().vertices(element.id());
                return (HugeVertex)QueryResults.one(iter);
            }
            assert (element instanceof HugeEdge);
            Iterator<Edge> iter = this.graph().edges(element.id());
            return (HugeEdge)QueryResults.one(iter);
        }

        @Override
        public Long reduce(Long t1, Long t2) {
            if (t1 == null) {
                return t2;
            }
            if (t2 == null) {
                return t1;
            }
            return t1 + t2;
        }
    }

    private static class IndexQueries
    extends HashMap<IndexLabel, ConditionQuery> {
        private static final long serialVersionUID = 1400326138090922676L;
        private static final IndexQueries EMPTY = new IndexQueries(null);
        private final ConditionQuery parentQuery;

        public IndexQueries(ConditionQuery parentQuery) {
            this.parentQuery = parentQuery;
        }

        public static IndexQueries of(IndexLabel il, ConditionQuery query) {
            IndexQueries indexQueries = new IndexQueries(query);
            indexQueries.put(il, query);
            return indexQueries;
        }

        public static IndexQueries of(ConditionQuery parentQuery) {
            IndexQueries indexQueries = new IndexQueries(parentQuery);
            return indexQueries;
        }

        public boolean oomRisk() {
            for (Query subQuery : this.values()) {
                if (!subQuery.bigCapacity() || subQuery.aggregate() == null) continue;
                return true;
            }
            return false;
        }

        public Map.Entry<IndexLabel, ConditionQuery> one() {
            E.checkState((this.size() == 1 ? 1 : 0) != 0, (String)"Please ensure index queries only contains one entry", (Object[])new Object[0]);
            return this.entrySet().iterator().next();
        }

        public Query rootQuery() {
            if (this.size() > 0) {
                return ((ConditionQuery)this.values().iterator().next()).rootOriginQuery();
            }
            return null;
        }

        public Query asJointQuery() {
            Collection<Query> queries = this.values();
            return new JointQuery(this.rootQuery().resultType(), this.parentQuery, queries);
        }

        private static class JointQuery
        extends Query {
            private final Collection<Query> queries;
            private final ConditionQuery parentQuery;

            public JointQuery(HugeType type, ConditionQuery parentQuery, Collection<Query> queries) {
                super(type, JointQuery.parent(queries));
                this.parentQuery = parentQuery;
                this.queries = queries;
            }

            @Override
            public Query originQuery() {
                return this.parentQuery;
            }

            public Query originJointQuery() {
                ArrayList<Query> origins = new ArrayList<Query>();
                for (Query q : this.queries) {
                    origins.add(q.originQuery());
                }
                return new JointQuery(this.resultType(), this.parentQuery, origins);
            }

            @Override
            public String toString() {
                return String.format("JointQuery %s", this.queries);
            }

            private static Query parent(Collection<Query> queries) {
                if (!queries.isEmpty()) {
                    return queries.iterator().next();
                }
                return null;
            }
        }
    }

    private static class MatchedIndex {
        private SchemaLabel schemaLabel;
        private Set<IndexLabel> indexLabels;

        public MatchedIndex(SchemaLabel schemaLabel, Set<IndexLabel> indexLabels) {
            this.schemaLabel = schemaLabel;
            this.indexLabels = indexLabels;
        }

        public SchemaLabel schemaLabel() {
            return this.schemaLabel;
        }

        public Set<IndexLabel> indexLabels() {
            return Collections.unmodifiableSet(this.indexLabels);
        }

        public IndexQueries constructIndexQueries(ConditionQuery query) {
            if (this.indexLabels().size() == 1) {
                IndexLabel il = this.indexLabels().iterator().next();
                ConditionQuery indexQuery = GraphIndexTransaction.constructQuery(query, il);
                assert (indexQuery != null);
                return IndexQueries.of(il, indexQuery);
            }
            IndexQueries queries = GraphIndexTransaction.buildJointIndexesQueries(query, this);
            assert (!queries.isEmpty());
            return queries;
        }

        public boolean containsSearchIndex() {
            for (IndexLabel il : this.indexLabels) {
                if (!il.indexType().isSearch()) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.indexLabels.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof MatchedIndex)) {
                return false;
            }
            Set<IndexLabel> indexLabels = ((MatchedIndex)other).indexLabels;
            return Objects.equals(this.indexLabels, indexLabels);
        }
    }
}

