/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.computer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.job.computer.Computer;
import org.apache.hugegraph.job.computer.LouvainComputer;
import org.apache.hugegraph.job.computer.LpaComputer;
import org.apache.hugegraph.job.computer.PageRankComputer;
import org.apache.hugegraph.job.computer.TriangleCountComputer;
import org.apache.hugegraph.job.computer.WeakConnectedComponentComputer;

public class ComputerPool {
    private static final ComputerPool INSTANCE = new ComputerPool();
    private final Map<String, Computer> computers = new ConcurrentHashMap<String, Computer>();

    public Computer register(Computer computer) {
        assert (!this.computers.containsKey(computer.name()));
        return this.computers.put(computer.name(), computer);
    }

    public Computer find(String name) {
        return this.computers.get(name);
    }

    public static ComputerPool instance() {
        return INSTANCE;
    }

    static {
        INSTANCE.register(new PageRankComputer());
        INSTANCE.register(new WeakConnectedComponentComputer());
        INSTANCE.register(new LpaComputer());
        INSTANCE.register(new TriangleCountComputer());
        INSTANCE.register(new LouvainComputer());
    }
}

