/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.meta.managers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.auth.HugeAccess;
import org.apache.hugegraph.auth.HugeBelong;
import org.apache.hugegraph.auth.HugeGroup;
import org.apache.hugegraph.auth.HugePermission;
import org.apache.hugegraph.auth.HugeRole;
import org.apache.hugegraph.auth.HugeTarget;
import org.apache.hugegraph.auth.HugeUser;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.meta.MetaDriver;
import org.apache.hugegraph.meta.MetaManager;
import org.apache.hugegraph.meta.managers.AbstractMetaManager;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;

public class AuthMetaManager
extends AbstractMetaManager {
    public AuthMetaManager(MetaDriver metaDriver, String cluster) {
        super(metaDriver, cluster);
    }

    public void createUser(HugeUser user) throws IOException {
        String result = this.metaDriver.get(this.userKey(user.name()));
        E.checkArgument((boolean)StringUtils.isEmpty((CharSequence)result), (String)"The user name '%s' has existed", (Object[])new Object[]{user.name()});
        this.metaDriver.put(this.userKey(user.name()), AuthMetaManager.serialize(user));
    }

    public HugeUser updateUser(HugeUser user) throws IOException {
        String result = this.metaDriver.get(this.userKey(user.name()));
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)result), (String)"The user name '%s' does not existed", (Object[])new Object[]{user.name()});
        HugeUser ori = HugeUser.fromMap(JsonUtil.fromJson(result, Map.class));
        ori.update(new Date());
        ori.nickname(user.nickname());
        ori.password(user.password());
        ori.phone(user.phone());
        ori.email(user.email());
        ori.avatar(user.avatar());
        ori.description(user.description());
        this.metaDriver.put(this.userKey(user.name()), AuthMetaManager.serialize(ori));
        return ori;
    }

    public HugeUser deleteUser(Id id) throws IOException, ClassNotFoundException {
        String result = this.metaDriver.get(this.userKey(id.asString()));
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)result), (String)"The user name '%s' does not existed", (Object[])new Object[]{id.asString()});
        this.metaDriver.delete(this.userKey(id.asString()));
        this.putAuthEvent(new MetaManager.AuthEvent("DELETE", "USER", id.asString()));
        Map map = JsonUtil.fromJson(result, Map.class);
        return HugeUser.fromMap(map);
    }

    public HugeUser findUser(String name) throws IOException, ClassNotFoundException {
        String result = this.metaDriver.get(this.userKey(name));
        if (StringUtils.isEmpty((CharSequence)result)) {
            return null;
        }
        return HugeUser.fromMap(JsonUtil.fromJson(result, Map.class));
    }

    public List<HugeUser> listUsers(List<Id> ids) throws IOException, ClassNotFoundException {
        ArrayList<HugeUser> result = new ArrayList<HugeUser>();
        Map<String, String> userMap = this.metaDriver.scanWithPrefix(this.userListKey());
        for (Id id : ids) {
            if (!userMap.containsKey(this.userKey(id.asString()))) continue;
            String value = userMap.get(this.userKey(id.asString()));
            Map map = JsonUtil.fromJson(value, Map.class);
            HugeUser user = HugeUser.fromMap(map);
            result.add(user);
        }
        return result;
    }

    public List<HugeUser> listUsersByGroup(String group, long limit) throws IOException, ClassNotFoundException {
        ArrayList<HugeUser> result = new ArrayList<HugeUser>();
        Map<String, String> userMap = this.metaDriver.scanWithPrefix(this.userListKey());
        for (Map.Entry<String, String> item : userMap.entrySet()) {
            if (limit >= 0L && (long)result.size() >= limit) break;
            Map map = JsonUtil.fromJson(item.getValue(), Map.class);
            HugeUser user = HugeUser.fromMap(map);
            result.add(user);
        }
        ArrayList<HugeBelong> belongs = new ArrayList<HugeBelong>();
        Map<String, String> belongMap = this.metaDriver.scanWithPrefix(this.belongListKey("*"));
        for (Map.Entry<String, String> item : belongMap.entrySet()) {
            if (limit >= 0L && (long)belongs.size() >= limit) break;
            String groupName = this.arrayFromBelong(item.getKey())[2];
            if (!groupName.equals(group)) continue;
            Map map = JsonUtil.fromJson(item.getValue(), Map.class);
            HugeBelong belong = HugeBelong.fromMap(map);
            belongs.add(belong);
        }
        return result;
    }

    public List<HugeUser> listAllUsers(long limit) throws IOException, ClassNotFoundException {
        ArrayList<HugeUser> result = new ArrayList<HugeUser>();
        Map<String, String> userMap = this.metaDriver.scanWithPrefix(this.userListKey());
        for (Map.Entry<String, String> item : userMap.entrySet()) {
            if (limit >= 0L && (long)result.size() >= limit) break;
            Map map = JsonUtil.fromJson(item.getValue(), Map.class);
            HugeUser user = HugeUser.fromMap(map);
            result.add(user);
        }
        return result;
    }

    public Id createGroup(HugeGroup group) throws IOException {
        String key = this.groupKey(group.name());
        String result = this.metaDriver.get(key);
        E.checkArgument((boolean)StringUtils.isEmpty((CharSequence)result), (String)"The group name '%s' has existed", (Object[])new Object[]{group.name()});
        this.metaDriver.put(key, AuthMetaManager.serialize(group));
        return group.id();
    }

    public HugeGroup updateGroup(HugeGroup group) throws IOException {
        String key = this.groupKey(group.name());
        String result = this.metaDriver.get(key);
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)result), (String)"The group name '%s' is not existed", (Object[])new Object[]{group.name()});
        Map map = JsonUtil.fromJson(result, Map.class);
        HugeGroup ori = HugeGroup.fromMap(map);
        ori.update(new Date());
        ori.nickname(group.nickname());
        ori.description(group.description());
        this.metaDriver.put(key, AuthMetaManager.serialize(ori));
        return ori;
    }

    public HugeGroup deleteGroup(Id id) throws IOException, ClassNotFoundException {
        String name = id.asString();
        String key = this.groupKey(name);
        String result = this.metaDriver.get(key);
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)result), (String)"The group name '%s' is not existed", (Object[])new Object[]{name});
        this.metaDriver.delete(key);
        this.putAuthEvent(new MetaManager.AuthEvent("DELETE", "GROUP", name));
        Map map = JsonUtil.fromJson(result, Map.class);
        return HugeGroup.fromMap(map);
    }

    public HugeGroup findGroup(String name) throws IOException, ClassNotFoundException {
        String result = this.metaDriver.get(this.groupKey(name));
        if (StringUtils.isEmpty((CharSequence)result)) {
            return null;
        }
        return HugeGroup.fromMap(JsonUtil.fromJson(result, Map.class));
    }

    public List<HugeGroup> listGroups(long limit) throws IOException, ClassNotFoundException {
        ArrayList<HugeGroup> result = new ArrayList<HugeGroup>();
        Map<String, String> groupMap = this.metaDriver.scanWithPrefix(this.groupListKey());
        for (Map.Entry<String, String> item : groupMap.entrySet()) {
            if (limit >= 0L && (long)result.size() >= limit) break;
            Map map = JsonUtil.fromJson(item.getValue(), Map.class);
            HugeGroup group = HugeGroup.fromMap(map);
            result.add(group);
        }
        return result;
    }

    public Id createRole(String graphSpace, HugeRole role) throws IOException {
        Id roleId = IdGenerator.of(role.name());
        HugeRole existed = this.findRole(graphSpace, roleId);
        E.checkArgument((existed == null ? 1 : 0) != 0, (String)"The role name '%s' has existed", (Object[])new Object[]{role.name()});
        role.name(roleId.asString());
        this.metaDriver.put(this.roleKey(graphSpace, role.name()), AuthMetaManager.serialize(role));
        return roleId;
    }

    public HugeRole updateRole(String graphSpace, HugeRole role) throws IOException {
        String result = this.metaDriver.get(this.roleKey(graphSpace, role.name()));
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)result), (String)"The role name '%s' is not existed", (Object[])new Object[]{role.name()});
        Map map = JsonUtil.fromJson(result, Map.class);
        HugeRole ori = HugeRole.fromMap(map);
        ori.update(new Date());
        ori.nickname(role.nickname());
        ori.description(role.description());
        this.metaDriver.put(this.roleKey(graphSpace, ori.name()), AuthMetaManager.serialize(ori));
        return ori;
    }

    public HugeRole deleteRole(String graphSpace, Id id) throws IOException, ClassNotFoundException {
        String result = this.metaDriver.get(this.roleKey(graphSpace, id.asString()));
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)result), (String)"The role name '%s' is not existed", (Object[])new Object[]{id.asString()});
        this.metaDriver.delete(this.roleKey(graphSpace, id.asString()));
        this.putAuthEvent(new MetaManager.AuthEvent("DELETE", "ROLE", id.asString()));
        Map map = JsonUtil.fromJson(result, Map.class);
        return HugeRole.fromMap(map);
    }

    public HugeRole findRole(String graphSpace, Id id) {
        String result = this.metaDriver.get(this.roleKey(graphSpace, id.asString()));
        if (StringUtils.isEmpty((CharSequence)result)) {
            return null;
        }
        Map map = JsonUtil.fromJson(result, Map.class);
        return HugeRole.fromMap(map);
    }

    public HugeRole getRole(String graphSpace, Id id) throws IOException, ClassNotFoundException {
        String result = this.metaDriver.get(this.roleKey(graphSpace, id.asString()));
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)result), (String)"The role name '%s' is not existed", (Object[])new Object[]{id.asString()});
        Map map = JsonUtil.fromJson(result, Map.class);
        return HugeRole.fromMap(map);
    }

    public List<HugeRole> listRoles(String graphSpace, List<Id> ids) throws IOException, ClassNotFoundException {
        ArrayList<HugeRole> result = new ArrayList<HugeRole>();
        Map<String, String> roleMap = this.metaDriver.scanWithPrefix(this.roleListKey(graphSpace));
        for (Id id : ids) {
            if (!roleMap.containsKey(this.roleKey(graphSpace, id.asString()))) continue;
            String roleString = roleMap.get(this.roleKey(graphSpace, id.asString()));
            Map map = JsonUtil.fromJson(roleString, Map.class);
            HugeRole role = HugeRole.fromMap(map);
            result.add(role);
        }
        return result;
    }

    public List<HugeRole> listAllRoles(String graphSpace, long limit) throws IOException, ClassNotFoundException {
        ArrayList<HugeRole> result = new ArrayList<HugeRole>();
        Map<String, String> roleMap = this.metaDriver.scanWithPrefix(this.roleListKey(graphSpace));
        for (Map.Entry<String, String> item : roleMap.entrySet()) {
            if (limit >= 0L && (long)result.size() >= limit) break;
            Map map = JsonUtil.fromJson(item.getValue(), Map.class);
            HugeRole role = HugeRole.fromMap(map);
            result.add(role);
        }
        return result;
    }

    public Id createTarget(String graphSpace, HugeTarget target) throws IOException {
        String result = this.metaDriver.get(this.targetKey(graphSpace, target.name()));
        E.checkArgument((boolean)StringUtils.isEmpty((CharSequence)result), (String)"The target name '%s' has existed", (Object[])new Object[]{target.name()});
        this.metaDriver.put(this.targetKey(graphSpace, target.name()), AuthMetaManager.serialize(target));
        return target.id();
    }

    public HugeTarget updateTarget(String graphSpace, HugeTarget target) throws IOException {
        String result = this.metaDriver.get(this.targetKey(graphSpace, target.name()));
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)result), (String)"The target name '%s' is not existed", (Object[])new Object[]{target.name()});
        Map map = JsonUtil.fromJson(result, Map.class);
        HugeTarget ori = HugeTarget.fromMap(map);
        ori.update(new Date());
        ori.graph(target.graph());
        ori.description(target.description());
        ori.resources(target.resources());
        this.metaDriver.put(this.targetKey(graphSpace, target.name()), AuthMetaManager.serialize(ori));
        this.putAuthEvent(new MetaManager.AuthEvent("UPDATE", "TARGET", ori.id().asString()));
        return ori;
    }

    public HugeTarget deleteTarget(String graphSpace, Id id) throws IOException, ClassNotFoundException {
        String result = this.metaDriver.get(this.targetKey(graphSpace, id.asString()));
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)result), (String)"The target name '%s' is not existed", (Object[])new Object[]{id.asString()});
        this.metaDriver.delete(this.targetKey(graphSpace, id.asString()));
        this.putAuthEvent(new MetaManager.AuthEvent("DELETE", "TARGET", id.asString()));
        Map map = JsonUtil.fromJson(result, Map.class);
        return HugeTarget.fromMap(map);
    }

    public HugeTarget findTarget(String graphSpace, Id id) {
        String result = this.metaDriver.get(this.targetKey(graphSpace, id.asString()));
        if (StringUtils.isEmpty((CharSequence)result)) {
            return null;
        }
        Map map = JsonUtil.fromJson(result, Map.class);
        return HugeTarget.fromMap(map);
    }

    public HugeTarget getTarget(String graphSpace, Id id) throws IOException, ClassNotFoundException {
        String result = this.metaDriver.get(this.targetKey(graphSpace, id.asString()));
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)result), (String)"The target name '%s' is not existed", (Object[])new Object[]{id.asString()});
        Map map = JsonUtil.fromJson(result, Map.class);
        return HugeTarget.fromMap(map);
    }

    public List<HugeTarget> listTargets(String graphSpace, List<Id> ids) throws IOException, ClassNotFoundException {
        ArrayList<HugeTarget> result = new ArrayList<HugeTarget>();
        Map<String, String> targetMap = this.metaDriver.scanWithPrefix(this.targetListKey(graphSpace));
        for (Id id : ids) {
            if (!targetMap.containsKey(this.targetKey(graphSpace, id.asString()))) continue;
            String targetString = targetMap.get(this.targetKey(graphSpace, id.asString()));
            Map map = JsonUtil.fromJson(targetString, Map.class);
            HugeTarget target = HugeTarget.fromMap(map);
            result.add(target);
        }
        return result;
    }

    public List<HugeTarget> listAllTargets(String graphSpace, long limit) throws IOException, ClassNotFoundException {
        ArrayList<HugeTarget> result = new ArrayList<HugeTarget>();
        Map<String, String> targetMap = this.metaDriver.scanWithPrefix(this.targetListKey(graphSpace));
        for (Map.Entry<String, String> item : targetMap.entrySet()) {
            if (limit >= 0L && (long)result.size() >= limit) break;
            Map map = JsonUtil.fromJson(item.getValue(), Map.class);
            HugeTarget target = HugeTarget.fromMap(map);
            result.add(target);
        }
        return result;
    }

    public Id createBelong(String graphSpace, HugeBelong belong) throws IOException, ClassNotFoundException {
        String belongId = this.checkBelong(graphSpace, belong);
        String result = this.metaDriver.get(this.belongKey(graphSpace, belongId));
        E.checkArgument((boolean)StringUtils.isEmpty((CharSequence)result), (String)"The belong name '%s' has existed", (Object[])new Object[]{belongId});
        this.metaDriver.put(this.belongKey(graphSpace, belongId), AuthMetaManager.serialize(belong));
        this.putAuthEvent(new MetaManager.AuthEvent("CREATE", "BELONG", belongId));
        return IdGenerator.of(belongId);
    }

    public HugeBelong updateBelong(String graphSpace, HugeBelong belong) throws IOException, ClassNotFoundException {
        String belongId = this.checkBelong(graphSpace, belong);
        String result = this.metaDriver.get(this.belongKey(graphSpace, belongId));
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)result), (String)"The belong name '%s' is not existed", (Object[])new Object[]{belongId});
        Map map = JsonUtil.fromJson(result, Map.class);
        HugeBelong ori = HugeBelong.fromMap(map);
        ori.update(new Date());
        ori.description(belong.description());
        this.metaDriver.put(this.belongKey(graphSpace, belongId), AuthMetaManager.serialize(ori));
        return ori;
    }

    public String checkBelong(String graphSpace, HugeBelong belong) throws IOException, ClassNotFoundException {
        String source = belong.source().asString();
        String target = belong.target().asString();
        String link = belong.link();
        HugeUser user = this.findUser(source);
        HugeGroup group = this.findGroup(source);
        E.checkArgument((user != null || group != null ? 1 : 0) != 0, (String)"The source name '%s' is not existed", (Object[])new Object[]{source});
        HugeGroup groupTarget = this.findGroup(target);
        HugeRole role = this.findRole(graphSpace, belong.target());
        E.checkArgument((role != null || groupTarget != null ? 1 : 0) != 0, (String)"The target name '%s' is not existed", (Object[])new Object[]{target});
        return this.belongId(source, target, link);
    }

    public HugeBelong deleteBelong(String graphSpace, Id id) throws IOException, ClassNotFoundException {
        String result = this.metaDriver.get(this.belongKey(graphSpace, id.asString()));
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)result), (String)"The belong name '%s' is not existed", (Object[])new Object[]{id.asString()});
        this.metaDriver.delete(this.belongKey(graphSpace, id.asString()));
        this.putAuthEvent(new MetaManager.AuthEvent("DELETE", "BELONG", id.asString()));
        Map map = JsonUtil.fromJson(result, Map.class);
        return HugeBelong.fromMap(map);
    }

    public HugeBelong getBelong(String graphSpace, Id id) throws IOException, ClassNotFoundException {
        String result = this.metaDriver.get(this.belongKey(graphSpace, id.asString()));
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)result), (String)"The belong name '%s' is not existed", (Object[])new Object[]{id.asString()});
        Map map = JsonUtil.fromJson(result, Map.class);
        return HugeBelong.fromMap(map);
    }

    public boolean existBelong(String graphSpace, Id id) {
        String result = this.metaDriver.get(this.belongKey(graphSpace, id.asString()));
        return StringUtils.isNotEmpty((CharSequence)result);
    }

    public List<HugeBelong> listBelong(String graphSpace, List<Id> ids) throws IOException, ClassNotFoundException {
        ArrayList<HugeBelong> result = new ArrayList<HugeBelong>();
        Map<String, String> belongMap = this.metaDriver.scanWithPrefix(this.belongListKey(graphSpace));
        for (Id id : ids) {
            if (!belongMap.containsKey(this.belongKey(graphSpace, id.asString()))) continue;
            String belongString = belongMap.get(this.belongKey(graphSpace, id.asString()));
            Map map = JsonUtil.fromJson(belongString, Map.class);
            HugeBelong belong = HugeBelong.fromMap(map);
            result.add(belong);
        }
        return result;
    }

    public List<HugeBelong> listAllBelong(String graphSpace, long limit) throws IOException, ClassNotFoundException {
        ArrayList<HugeBelong> result = new ArrayList<HugeBelong>();
        Map<String, String> belongMap = this.metaDriver.scanWithPrefix(this.belongListKey(graphSpace));
        for (Map.Entry<String, String> item : belongMap.entrySet()) {
            if (limit >= 0L && (long)result.size() >= limit) break;
            Map map = JsonUtil.fromJson(item.getValue(), Map.class);
            HugeBelong belong = HugeBelong.fromMap(map);
            result.add(belong);
        }
        return result;
    }

    public List<HugeBelong> listBelongBySource(String graphSpace, Id source, String link, long limit) throws IOException, ClassNotFoundException {
        ArrayList<HugeBelong> result = new ArrayList<HugeBelong>();
        String sourceLink = "*".equals(link) ? source.asString() : source.asString() + "->" + link;
        String key = this.belongListKeyBySource(graphSpace, sourceLink);
        Map<String, String> belongMap = this.metaDriver.scanWithPrefix(key);
        for (Map.Entry<String, String> item : belongMap.entrySet()) {
            if (limit >= 0L && (long)result.size() >= limit) break;
            Map map = JsonUtil.fromJson(item.getValue(), Map.class);
            HugeBelong belong = HugeBelong.fromMap(map);
            result.add(belong);
        }
        return result;
    }

    public String[] arrayFromBelong(String belongKey) {
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)belongKey), (String)"The belong name '%s' is empty", (Object[])new Object[]{belongKey});
        E.checkArgument((boolean)belongKey.contains("->"), (String)"The belong name '%s' is invalid", (Object[])new Object[]{belongKey});
        String[] items = belongKey.split("->");
        E.checkArgument((items.length == 3 ? 1 : 0) != 0, (String)"The belong name '%s' is invalid", (Object[])new Object[]{belongKey});
        return items;
    }

    public List<HugeBelong> listBelongByTarget(String graphSpace, Id role, String link, long limit) throws IOException, ClassNotFoundException {
        ArrayList<HugeBelong> result = new ArrayList<HugeBelong>();
        Map<String, String> belongMap = this.metaDriver.scanWithPrefix(this.belongListKey(graphSpace));
        for (Map.Entry<String, String> item : belongMap.entrySet()) {
            if (limit >= 0L && (long)result.size() >= limit) break;
            String[] array = this.arrayFromBelong(item.getKey());
            String linkName = array[1];
            String roleName = array[2];
            if (!linkName.equals(link) && !"*".equals(link) || !roleName.equals(role.asString())) continue;
            Map map = JsonUtil.fromJson(item.getValue(), Map.class);
            HugeBelong belong = HugeBelong.fromMap(map);
            result.add(belong);
        }
        return result;
    }

    public Id createAccess(String graphSpace, HugeAccess access) throws IOException, ClassNotFoundException {
        String accessId = this.checkAccess(graphSpace, access);
        String result = this.metaDriver.get(this.accessKey(graphSpace, accessId));
        E.checkArgument((boolean)StringUtils.isEmpty((CharSequence)result), (String)"The access name '%s' has existed", (Object[])new Object[]{accessId});
        this.metaDriver.put(this.accessKey(graphSpace, accessId), AuthMetaManager.serialize(access));
        this.putAuthEvent(new MetaManager.AuthEvent("CREATE", "ACCESS", accessId));
        return IdGenerator.of(accessId);
    }

    public HugeAccess updateAccess(String graphSpace, HugeAccess access) throws IOException, ClassNotFoundException {
        String accessId = this.checkAccess(graphSpace, access);
        String result = this.metaDriver.get(this.accessKey(graphSpace, accessId));
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)result), (String)"The access name '%s' is not existed", (Object[])new Object[]{accessId});
        Map map = JsonUtil.fromJson(result, Map.class);
        HugeAccess existed = HugeAccess.fromMap(map);
        E.checkArgument((existed.permission().code() == access.permission().code() ? 1 : 0) != 0, (String)"The access name '%s' has existed", (Object[])new Object[]{accessId});
        Map oriMap = JsonUtil.fromJson(result, Map.class);
        HugeAccess ori = HugeAccess.fromMap(oriMap);
        ori.update(new Date());
        ori.description(access.description());
        this.metaDriver.put(this.accessKey(graphSpace, accessId), AuthMetaManager.serialize(ori));
        return ori;
    }

    public String checkAccess(String graphSpace, HugeAccess access) throws IOException, ClassNotFoundException {
        HugeRole role = this.getRole(graphSpace, access.source());
        E.checkArgument((role != null ? 1 : 0) != 0, (String)"The role name '%s' is not existed", (Object[])new Object[]{access.source().asString()});
        HugeTarget target = this.getTarget(graphSpace, access.target());
        E.checkArgument((target != null ? 1 : 0) != 0, (String)"The target name '%s' is not existed", (Object[])new Object[]{access.target().asString()});
        return this.accessId(role.name(), target.name(), access.permission());
    }

    public HugeAccess deleteAccess(String graphSpace, Id id) throws IOException, ClassNotFoundException {
        String result = this.metaDriver.get(this.accessKey(graphSpace, id.asString()));
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)result), (String)"The access name '%s' is not existed", (Object[])new Object[]{id.asString()});
        this.metaDriver.delete(this.accessKey(graphSpace, id.asString()));
        this.putAuthEvent(new MetaManager.AuthEvent("DELETE", "ACCESS", id.asString()));
        Map map = JsonUtil.fromJson(result, Map.class);
        return HugeAccess.fromMap(map);
    }

    public HugeAccess findAccess(String graphSpace, Id id) {
        String result = this.metaDriver.get(this.accessKey(graphSpace, id.asString()));
        if (StringUtils.isEmpty((CharSequence)result)) {
            return null;
        }
        Map map = JsonUtil.fromJson(result, Map.class);
        return HugeAccess.fromMap(map);
    }

    public HugeAccess getAccess(String graphSpace, Id id) throws IOException, ClassNotFoundException {
        String result = this.metaDriver.get(this.accessKey(graphSpace, id.asString()));
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)result), (String)"The access name '%s' is not existed", (Object[])new Object[]{id.asString()});
        Map map = JsonUtil.fromJson(result, Map.class);
        return HugeAccess.fromMap(map);
    }

    public List<HugeAccess> listAccess(String graphSpace, List<Id> ids) throws IOException, ClassNotFoundException {
        ArrayList<HugeAccess> result = new ArrayList<HugeAccess>();
        Map<String, String> accessMap = this.metaDriver.scanWithPrefix(this.accessListKey(graphSpace));
        for (Id id : ids) {
            if (!accessMap.containsKey(this.accessKey(graphSpace, id.asString()))) continue;
            String accessString = accessMap.get(this.accessKey(graphSpace, id.asString()));
            Map map = JsonUtil.fromJson(accessString, Map.class);
            HugeAccess access = HugeAccess.fromMap(map);
            result.add(access);
        }
        return result;
    }

    public List<HugeAccess> listAllAccess(String graphSpace, long limit) throws IOException, ClassNotFoundException {
        ArrayList<HugeAccess> result = new ArrayList<HugeAccess>();
        Map<String, String> accessMap = this.metaDriver.scanWithPrefix(this.accessListKey(graphSpace));
        for (Map.Entry<String, String> item : accessMap.entrySet()) {
            if (limit >= 0L && (long)result.size() >= limit) break;
            Map map = JsonUtil.fromJson(item.getValue(), Map.class);
            HugeAccess access = HugeAccess.fromMap(map);
            result.add(access);
        }
        return result;
    }

    public List<HugeAccess> listAccessByRole(String graphSpace, Id role, long limit) throws IOException, ClassNotFoundException {
        ArrayList<HugeAccess> result = new ArrayList<HugeAccess>();
        Map<String, String> accessMap = this.metaDriver.scanWithPrefix(this.accessListKeyByRole(graphSpace, role.asString()));
        for (Map.Entry<String, String> item : accessMap.entrySet()) {
            if (limit >= 0L && (long)result.size() >= limit) break;
            Map map = JsonUtil.fromJson(item.getValue(), Map.class);
            HugeAccess access = HugeAccess.fromMap(map);
            result.add(access);
        }
        return result;
    }

    public String targetFromAccess(String accessKey) {
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)accessKey), (String)"The access name '%s' is empty", (Object[])new Object[]{accessKey});
        E.checkArgument((boolean)accessKey.contains("->"), (String)"The access name '%s' is invalid", (Object[])new Object[]{accessKey});
        String[] items = accessKey.split("->");
        E.checkArgument((items.length == 3 ? 1 : 0) != 0, (String)"The access name '%s' is invalid", (Object[])new Object[]{accessKey});
        return items[2];
    }

    public void clearGraphAuth(String graphSpace) {
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)graphSpace), (String)"The graphSpace is empty", (Object[])new Object[0]);
        String prefix = this.authPrefix(graphSpace);
        this.metaDriver.deleteWithPrefix(prefix);
    }

    public List<HugeAccess> listAccessByTarget(String graphSpace, Id target, long limit) throws IOException, ClassNotFoundException {
        ArrayList<HugeAccess> result = new ArrayList<HugeAccess>();
        Map<String, String> accessMap = this.metaDriver.scanWithPrefix(this.accessListKey(graphSpace));
        for (Map.Entry<String, String> item : accessMap.entrySet()) {
            if (limit >= 0L && (long)result.size() >= limit) break;
            String targetName = this.targetFromAccess(item.getKey());
            if (!targetName.equals(target.asString())) continue;
            Map map = JsonUtil.fromJson(item.getValue(), Map.class);
            HugeAccess access = HugeAccess.fromMap(map);
            result.add(access);
        }
        return result;
    }

    public <T> void listenAuthEvent(Consumer<T> consumer) {
        this.listen(this.authEventKey(), consumer);
    }

    public void putAuthEvent(MetaManager.AuthEvent event) {
        this.metaDriver.put(this.authEventKey(), JsonUtil.toJson(event.asMap()));
    }

    public String belongId(String source, String target, String link) {
        E.checkArgument((StringUtils.isNotEmpty((CharSequence)source) && StringUtils.isNotEmpty((CharSequence)target) ? 1 : 0) != 0, (String)"The source name '%s' or target name '%s' is empty", (Object[])new Object[]{source, target});
        return String.join((CharSequence)"->", source, link, target);
    }

    public String accessId(String roleName, String targetName, HugePermission permission) {
        E.checkArgument((StringUtils.isNotEmpty((CharSequence)roleName) && StringUtils.isNotEmpty((CharSequence)targetName) ? 1 : 0) != 0, (String)"The role name '%s' or target name '%s' is empty", (Object[])new Object[]{roleName, targetName});
        String code = String.valueOf(permission.code());
        return String.join((CharSequence)"->", roleName, code, targetName);
    }

    public String authEventKey() {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "AUTH_EVENT");
    }

    private String userKey(String name) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "AUTH", "USER", name);
    }

    private String userListKey() {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "AUTH", "USER");
    }

    private String authPrefix(String graphSpace) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, "AUTH");
    }

    private String groupKey(String group) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "AUTH", "GROUP", group);
    }

    private String groupListKey() {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "AUTH", "GROUP");
    }

    private String roleKey(String graphSpace, String role) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, "AUTH", "ROLE", role);
    }

    private String roleListKey(String graphSpace) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, "AUTH", "ROLE");
    }

    private String targetKey(String graphSpace, String target) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, "AUTH", "TARGET", target);
    }

    private String targetListKey(String graphSpace) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, "AUTH", "TARGET");
    }

    private String belongKey(String graphSpace, String belong) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, "AUTH", "BELONG", belong);
    }

    private String belongListKey(String graphSpace) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, "AUTH", "BELONG");
    }

    private String belongListKeyBySource(String graphSpace, String source) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, "AUTH", "BELONG", source + "->");
    }

    private String accessKey(String graphSpace, String access) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, "AUTH", "ACCESS", access);
    }

    private String accessListKey(String graphSpace) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, "AUTH", "ACCESS");
    }

    private String accessListKeyByRole(String graphSpace, String roleName) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, "AUTH", "ACCESS", roleName + "->");
    }
}

